/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.order.busi.impl;

import com.tydic.contract.api.order.bo.ContractAccessoryReqBO;
import com.tydic.contract.api.order.bo.ContractOrderUpdateReqBO;
import com.tydic.contract.api.order.bo.ContractOrderUpdateRspBO;
import com.tydic.contract.api.order.service.ContractOrderUpdateService;
import com.tydic.contract.api.supplier.bo.ContractPayTypeReqBO;
import com.tydic.contract.constant.Constant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractPayTypeMapper;
import com.tydic.contract.dao.ContractSequenceMapper;
import com.tydic.contract.dao.ContractTaskHisMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.ContractAccessoryPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractPayTypePO;
import com.tydic.contract.po.ContractSequencePO;
import com.tydic.contract.po.ContractTaskHisPO;
import com.tydic.contract.po.ContractTermsPO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uac.exception.BusinessException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.order.service.ContractOrderUpdateService"})
public class ContractOrderUpdateServiceImpl
implements ContractOrderUpdateService {
    private static final Logger log = LoggerFactory.getLogger(ContractOrderUpdateServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractTermsMapper contractTermsMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private ContractTaskHisMapper contractTaskHisMapper;
    @Autowired
    private ContractPayTypeMapper contractPayTypeMapper;
    @Autowired
    private ContractSequenceMapper contractSequenceMapper;

    @PostMapping(value={"contractOrderUpdate"})
    public ContractOrderUpdateRspBO contractOrderUpdate(@RequestBody ContractOrderUpdateReqBO contractOrderUpdateReqBO) {
        ContractOrderUpdateRspBO contractOrderUpdateRspBO = new ContractOrderUpdateRspBO();
        if (contractOrderUpdateReqBO.getContractId() == null) {
            contractOrderUpdateRspBO.setCode("8888");
            contractOrderUpdateRspBO.setMessage("\u5408\u540c\u4fee\u6539\uff0ccontractId\u4e0d\u80fd\u4e3a\u7a7a");
            return contractOrderUpdateRspBO;
        }
        ContractInfoPO contractInfoPO = new ContractInfoPO();
        if (contractOrderUpdateReqBO.getSaveOrSubmit() == 2 && (contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(contractOrderUpdateReqBO.getContractId())).getContractDocUrl() == null) {
            contractOrderUpdateRspBO.setCode("8888");
            contractOrderUpdateRspBO.setMessage("\u8bf7\u5148\u751f\u6210\u5408\u540c\u6587\u672c\uff0c\u5426\u5219\u65e0\u6cd5\u63d0\u4ea4\u5408\u540c");
            return contractOrderUpdateRspBO;
        }
        ContractInfoPO contractInfoPO1 = null;
        if (contractOrderUpdateReqBO.getSaveOrSubmit() == 1) {
            contractInfoPO1 = this.updateContract(contractOrderUpdateReqBO);
        } else if (contractOrderUpdateReqBO.getSaveOrSubmit() == 2) {
            contractInfoPO1 = this.updateContract(contractOrderUpdateReqBO);
            ContractTaskHisPO contractTaskHisPO = new ContractTaskHisPO();
            contractTaskHisPO.setContractId(contractOrderUpdateReqBO.getContractId());
            contractTaskHisPO.setOperName(contractOrderUpdateReqBO.getName());
            contractTaskHisPO.setOperId(contractOrderUpdateReqBO.getUserId());
            contractTaskHisPO.setOperOrgId(contractOrderUpdateReqBO.getOrgId());
            contractTaskHisPO.setOperOrgName(contractOrderUpdateReqBO.getOrgName());
            contractTaskHisPO.setArrivalTime(new Date());
            contractTaskHisPO.setOperateTime(new Date());
            contractTaskHisPO.setBusiStep(Constant.CONTRACT_STEP_SUBMIT);
            contractTaskHisPO.setBusiStepName("\u521b\u5efa\u5408\u540c");
            contractTaskHisPO.setOperateBehavior("\u63d0\u4ea4\u5408\u540c");
            contractTaskHisPO.setRoleName("\u5408\u540c\u7ba1\u7406");
            this.contractTaskHisMapper.insertSelective(contractTaskHisPO);
            UacNoTaskAuditCreateReqBO noTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
            noTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
            noTaskAuditCreateReqBO.setCreateOperId(contractOrderUpdateReqBO.getCreateUserId().toString());
            noTaskAuditCreateReqBO.setCreateOperName(contractOrderUpdateReqBO.getCreateUserName());
            UacNoTaskAuditCreateInfoReqBO infoReqBO = new UacNoTaskAuditCreateInfoReqBO();
            infoReqBO.setCreateOperId(contractOrderUpdateReqBO.getCreateUserId().toString());
            infoReqBO.setUsername(contractOrderUpdateReqBO.getCreateUserName());
            infoReqBO.setRemark("\u8ba2\u5355\u5408\u540c\u521b\u5efa\u5ba1\u6279");
            infoReqBO.setOrderId(contractOrderUpdateReqBO.getContractId());
            infoReqBO.setObjType(Constant.CONTRACT_CREATE_TYPE);
            infoReqBO.setObjNum("1");
            ApprovalObjBO approvalObjBO = new ApprovalObjBO();
            noTaskAuditCreateReqBO.setProcDefKey("cnnc_contract_create");
            approvalObjBO.setObjId(contractOrderUpdateReqBO.getContractId().toString());
            approvalObjBO.setOrderId(contractOrderUpdateReqBO.getContractId());
            ArrayList<ApprovalObjBO> objBOS = new ArrayList<ApprovalObjBO>(1);
            objBOS.add(approvalObjBO);
            infoReqBO.setApprovalObjInfo(objBOS);
            ArrayList<UacNoTaskAuditCreateInfoReqBO> infoReqBOS = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(1);
            infoReqBOS.add(infoReqBO);
            noTaskAuditCreateReqBO.setCreateBusiReqBO(infoReqBOS);
            UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(noTaskAuditCreateReqBO);
            if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u8c03\u7528\u5ba1\u6279\u521b\u5efa\u5931\u8d25" + uacNoTaskAuditCreateRspBO.getRespDesc());
            }
            ContractInfoPO record = new ContractInfoPO();
            record.setContractId(contractOrderUpdateReqBO.getContractId());
            record.setContractStatus(Constant.CONTRACT_STATUS_AUDIT);
            this.contractInfoMapper.updateByContractID(record);
        }
        contractOrderUpdateRspBO.setContractId(contractOrderUpdateReqBO.getContractId());
        contractOrderUpdateRspBO.setContractCode(contractInfoPO.getContractCode());
        contractOrderUpdateRspBO.setCode("0000");
        contractOrderUpdateRspBO.setMessage("\u6210\u529f");
        return contractOrderUpdateRspBO;
    }

    public ContractInfoPO updateContract(ContractOrderUpdateReqBO contractOrderUpdateReqBO) {
        this.newContractName(contractOrderUpdateReqBO);
        ContractInfoPO contractInfoPO = new ContractInfoPO();
        BeanUtils.copyProperties((Object)contractOrderUpdateReqBO, (Object)contractInfoPO);
        if (contractOrderUpdateReqBO.getSaveOrSubmit() == 2) {
            contractInfoPO.setSubmitTime(new Date());
            contractInfoPO.setContractStatus(Constant.CONTRACT_STATUS_AUDIT);
        }
        if (contractOrderUpdateReqBO.getQuaPay() != null && !contractOrderUpdateReqBO.getQuaPay().equals("")) {
            double quaPayDouble = Double.parseDouble(contractOrderUpdateReqBO.getQuaPay());
            Long quaAmount = (long)(quaPayDouble * 100.0);
            contractInfoPO.setQuaAmount(quaAmount);
        }
        contractInfoPO.setUpdateTime(new Date());
        ContractTermsPO contractTermsPO = this.contractTermsMapper.selectByPrimaryKey(contractOrderUpdateReqBO.getContractTermId());
        contractInfoPO.setContractTermText(contractTermsPO.getTermText());
        this.contractInfoMapper.updateByPrimaryKeySelective(contractInfoPO);
        this.contractAccessoryMapper.deleteByContractId(contractOrderUpdateReqBO.getContractId());
        if (contractOrderUpdateReqBO.getContractAccessoryList() != null && contractOrderUpdateReqBO.getContractAccessoryList().size() > 0) {
            for (ContractAccessoryReqBO contractAccessoryReqBO : contractOrderUpdateReqBO.getContractAccessoryList()) {
                ContractAccessoryPO contractAccessoryPO = new ContractAccessoryPO();
                contractAccessoryPO.setAcceessoryName(contractAccessoryReqBO.getAcceessoryName());
                contractAccessoryPO.setContractId(contractOrderUpdateReqBO.getContractId());
                contractAccessoryPO.setContractType(contractOrderUpdateReqBO.getContractType());
                contractAccessoryPO.setCreateTime(new Date());
                contractAccessoryPO.setValidStatus(Constant.VALID_STATUS_YES);
                contractAccessoryPO.setAcceessoryUrl(contractAccessoryReqBO.getAcceessoryUrl());
                contractAccessoryPO.setAcceessoryType(Constant.ACCEESSORY_TYPE_1);
                this.contractAccessoryMapper.insertSelective(contractAccessoryPO);
            }
        }
        ContractPayTypePO contractPayTypePO = new ContractPayTypePO();
        contractPayTypePO.setValidStatus(Constant.VALID_STATUS_NO);
        contractPayTypePO.setContractId(contractOrderUpdateReqBO.getContractId());
        this.contractPayTypeMapper.updateByContractId(contractPayTypePO);
        if (contractOrderUpdateReqBO.getContractPayTypeList() != null) {
            for (ContractPayTypeReqBO contractPayTypeReqBO : contractOrderUpdateReqBO.getContractPayTypeList()) {
                ContractPayTypePO contractPayTypePO1 = new ContractPayTypePO();
                BeanUtils.copyProperties((Object)contractPayTypeReqBO, (Object)contractPayTypePO1);
                contractPayTypePO1.setContractId(contractOrderUpdateReqBO.getContractId());
                contractPayTypePO1.setValidStatus(Constant.VALID_STATUS_YES);
                this.contractPayTypeMapper.insertSelective(contractPayTypePO1);
            }
        }
        return contractInfoPO;
    }

    private void newContractName(ContractOrderUpdateReqBO contractOrderUpdateReqBO) {
        ContractSequencePO sequencePO = this.contractSequenceMapper.selectValue(String.valueOf(contractOrderUpdateReqBO.getContractType()));
        Optional<ContractSequencePO> optional = Optional.ofNullable(sequencePO);
        if (optional.isPresent()) {
            String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(new Date()).replace("-", "");
            String newContractName = "\u91c7\u8d2d\u8ba2\u5355\u5408\u540c" + dateStr + "-" + sequencePO.getCurrentValue();
            contractOrderUpdateReqBO.setContractName(newContractName);
            sequencePO.setCreateTime(new Date());
            if (sequencePO.getCurrentValue() >= 9999L) {
                sequencePO.setCurrentValue(999L);
            }
            sequencePO.setContractType(String.valueOf(contractOrderUpdateReqBO.getContractType()));
            this.contractSequenceMapper.updateValue(sequencePO);
        }
    }
}

