/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.supplier.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.supplier.bo.QuerySupplierByCategoryIdReqBO;
import com.tydic.contract.api.supplier.bo.QuerySupplierByCategoryIdRspBO;
import com.tydic.contract.api.supplier.service.QuerySupplierByCategoryIdService;
import com.tydic.contract.dao.ContractSupplierSaleMapper;
import com.tydic.contract.po.ContractSupplierSalePO;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.supplier.service.QuerySupplierByCategoryIdService"})
public class QuerySupplierByCategoryIdServiceImpl
implements QuerySupplierByCategoryIdService {
    private static final Logger log = LoggerFactory.getLogger(QuerySupplierByCategoryIdServiceImpl.class);
    @Autowired
    private ContractSupplierSaleMapper contractSupplierSaleMapper;

    @PostMapping(value={"querySupplierByCategoryId"})
    public QuerySupplierByCategoryIdRspBO querySupplierByCategoryId(@RequestBody QuerySupplierByCategoryIdReqBO reqBO) {
        QuerySupplierByCategoryIdRspBO rspBO = new QuerySupplierByCategoryIdRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getCategoryIds())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u7269\u6599\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546API\u5165\u53c2\u7c7b\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ContractSupplierSalePO salePO = new ContractSupplierSalePO();
        salePO.setCategoryIds(reqBO.getCategoryIds());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ContractSupplierSalePO> resultPO = this.contractSupplierSaleMapper.querySupplierByCategoryId(salePO, (Page<ContractSupplierSalePO>)page);
        if (!CollectionUtils.isEmpty(resultPO)) {
            ArrayList supplierIdList = new ArrayList();
            HashMap supplierInfoMap = new HashMap();
            resultPO.forEach(po -> {
                supplierIdList.add(po.getEnterPurchaserId());
                supplierInfoMap.put(po.getEnterPurchaserId(), po.getEnterPurchaserName());
            });
            rspBO.setSupplierIdList(supplierIdList);
            rspBO.setSupplierInfoMap(supplierInfoMap);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }
}

