/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.supplier.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.api.supplier.bo.CategoryNameListBO;
import com.tydic.contract.api.supplier.bo.QueryAllContractCategoryIdReqBO;
import com.tydic.contract.api.supplier.bo.QueryAllContractCategoryIdRspBO;
import com.tydic.contract.api.supplier.service.QueryAllContractCategoryIdService;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractSupplierSaleMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractSupplierSalePO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.supplier.service.QueryAllContractCategoryIdService"})
public class QueryAllContractCategoryIdServiceImpl
implements QueryAllContractCategoryIdService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractSupplierSaleMapper contractSupplierSaleMapper;

    @PostMapping(value={"queryAllContractCategoryId"})
    public QueryAllContractCategoryIdRspBO queryAllContractCategoryId(@RequestBody QueryAllContractCategoryIdReqBO reqBO) {
        QueryAllContractCategoryIdRspBO rspBO = new QueryAllContractCategoryIdRspBO();
        if (reqBO.getEnterPurchaserId() == null) {
            throw new ZTBusinessException("\u5165\u9a7b\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enterPurchaserId", reqBO.getEnterPurchaserId());
        List<ContractInfoPO> contractInfoPOList = this.contractInfoMapper.queryContractIdWithApproving(map);
        ArrayList<CategoryNameListBO> categoryNameList = new ArrayList<CategoryNameListBO>();
        if (!CollectionUtils.isEmpty(contractInfoPOList)) {
            ArrayList<Long> contractIds = new ArrayList<Long>();
            contractInfoPOList.forEach(contractInfoPO -> contractIds.add(contractInfoPO.getContractId()));
            List<ContractSupplierSalePO> contractSupplierSalePOS = this.contractSupplierSaleMapper.queryByContractIdList(contractIds);
            if (!CollectionUtils.isEmpty(contractSupplierSalePOS)) {
                for (ContractSupplierSalePO supplierSalePO : contractSupplierSalePOS) {
                    CategoryNameListBO categoryNameListBO = new CategoryNameListBO();
                    categoryNameListBO.setCategoryId(supplierSalePO.getCategoryId());
                    categoryNameListBO.setCategoryName(supplierSalePO.getCategoryName());
                    categoryNameList.add(categoryNameListBO);
                }
            }
        }
        rspBO.setCategoryNameList(categoryNameList);
        return rspBO;
    }
}

