/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.supplier.busi.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.supplier.bo.QuerySupplierByStaffWelfareContractReqBO;
import com.tydic.contract.api.supplier.bo.QuerySupplierByStaffWelfareContractRspBO;
import com.tydic.contract.api.supplier.service.QuerySupplierByStaffWelfareContractService;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.supplier.service.QuerySupplierByStaffWelfareContractService"})
public class QuerySupplierByStaffWelfareContractServiceImpl
implements QuerySupplierByStaffWelfareContractService {
    private static final Logger log = LoggerFactory.getLogger(QuerySupplierByStaffWelfareContractServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @PostMapping(value={"querySupplierByStaffWelfareContract"})
    public QuerySupplierByStaffWelfareContractRspBO querySupplierByStaffWelfareContract(@RequestBody QuerySupplierByStaffWelfareContractReqBO reqBO) {
        QuerySupplierByStaffWelfareContractRspBO rspBO = new QuerySupplierByStaffWelfareContractRspBO();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        condition.put("isStaffWelfare", StringUtils.trimToNull((String)reqBO.getIsStaffWelfare().toString()));
        condition.put("validStatus", StringUtils.trimToNull((String)"1"));
        condition.put("contractStatusList", Lists.newArrayList((Object[])new Integer[]{4, 6}));
        List<ContractInfoPO> contractOrderInfos = this.contractInfoMapper.selectListByCondition(condition, (Page<ContractInfoPO>)page);
        ArrayList supplierIdList = new ArrayList();
        if (!CollectionUtils.isEmpty(contractOrderInfos)) {
            contractOrderInfos.forEach(po -> {
                if (!supplierIdList.contains(po.getEnterPurchaserId())) {
                    supplierIdList.add(po.getEnterPurchaserId());
                }
            });
            rspBO.setSupplierIdList(supplierIdList);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }
}

