/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.supplier.busi.impl;

import com.tydic.contract.api.supplier.bo.QueryContractIdBySupplierReqBO;
import com.tydic.contract.api.supplier.bo.QueryContractIdBySupplierRspBO;
import com.tydic.contract.api.supplier.service.QueryContractIdBySupplierService;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.supplier.service.QueryContractIdBySupplierService"})
public class QueryContractIdBySupplierServiceImpl
implements QueryContractIdBySupplierService {
    private static final Logger log = LoggerFactory.getLogger(QueryContractIdBySupplierServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @PostMapping(value={"queryContractIdBySupplier"})
    public QueryContractIdBySupplierRspBO queryContractIdBySupplier(@RequestBody QueryContractIdBySupplierReqBO reqBO) {
        QueryContractIdBySupplierRspBO rspBO = new QueryContractIdBySupplierRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSupplierIds())) {
            throw new BusinessException("8888", "\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u4fe1\u606f!");
        }
        ContractInfoPO contractInfoPO = new ContractInfoPO();
        contractInfoPO.setEnterPurchaserIdS(reqBO.getSupplierIds());
        contractInfoPO.setIsStaffWelfare(reqBO.getIsStaffWelfare());
        List<ContractInfoPO> result = this.contractInfoMapper.selectBy(contractInfoPO);
        HashMap rows = new HashMap();
        Map<Long, List<ContractInfoPO>> skuInfo = result.stream().collect(Collectors.groupingBy(ContractInfoPO::getEnterPurchaserId));
        for (Long supplierId : skuInfo.keySet()) {
            ArrayList<Long> contractId = new ArrayList<Long>();
            for (ContractInfoPO contractPO : skuInfo.get(supplierId)) {
                contractId.add(contractPO.getContractId());
            }
            rows.put(supplierId, contractId);
        }
        rspBO.setSupplierInfoMap(rows);
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }
}

