/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.supplier.busi.impl;

import com.tydic.contract.api.agreement.bo.ContractAccessoryRspBO;
import com.tydic.contract.api.maintenance.bo.ContractSupplierLadderRspBO;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleRspBO;
import com.tydic.contract.api.supplier.bo.ContractSupCatListDetailBO;
import com.tydic.contract.api.supplier.bo.ContractSupCatListRspBO;
import com.tydic.contract.api.supplier.bo.ContractSupplierDetailBO;
import com.tydic.contract.api.supplier.bo.QuerySupplierContractReqBO;
import com.tydic.contract.api.supplier.bo.QuerySupplierContractRspBO;
import com.tydic.contract.api.supplier.bo.SupplierContractBO;
import com.tydic.contract.api.supplier.service.QrySupplierContractDetailService;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractSupplierLadderMapper;
import com.tydic.contract.dao.ContractSupplierSaleMapper;
import com.tydic.contract.po.ContractAccessoryPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractSupplierLadderPO;
import com.tydic.contract.po.ContractSupplierSalePO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.supplier.service.QrySupplierContractDetailService"})
public class QrySupplierContractDetailServiceImpl
implements QrySupplierContractDetailService {
    private static final Logger log = LoggerFactory.getLogger(QrySupplierContractDetailServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractSupplierSaleMapper contractSupplierSaleMapper;
    @Autowired
    private ContractSupplierLadderMapper contractSupplierLadderMapper;
    @Autowired
    private ContractAccessoryMapper accessoryMapper;

    @PostMapping(value={"qrySupplierContractDetail"})
    public QuerySupplierContractRspBO qrySupplierContractDetail(@RequestBody QuerySupplierContractReqBO reqBO) {
        QuerySupplierContractRspBO rspBO = new QuerySupplierContractRspBO();
        ArrayList<ContractInfoPO> contractIdList = new ArrayList<ContractInfoPO>();
        for (SupplierContractBO supplierContractBO : reqBO.getSupplierContractBOList()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("enterPurchaserId", supplierContractBO.getEnterPurchaserId());
            map.put("categoryName", supplierContractBO.getCategoryName());
            List<ContractInfoPO> contractInfoPOList = this.contractInfoMapper.queryByMap(map);
            if (CollectionUtils.isEmpty(contractInfoPOList)) continue;
            contractIdList.add(contractInfoPOList.get(0));
        }
        if (!CollectionUtils.isEmpty(contractIdList)) {
            ArrayList<ContractSupplierDetailBO> contractSupplierDetailBOList = new ArrayList<ContractSupplierDetailBO>();
            for (ContractInfoPO contractInfoPO : contractIdList) {
                List<ContractSupplierLadderPO> contractSupplierLadderPOList;
                List<ContractSupplierSalePO> contractSupplierSalePOList;
                ContractInfoPO po = this.contractInfoMapper.selectByPrimaryKey(contractInfoPO.getContractId());
                ContractSupplierDetailBO bo = new ContractSupplierDetailBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                Long contractIdL = po.getContractId();
                String contractId = contractIdL.toString();
                bo.setContractId(contractId);
                List<ContractAccessoryPO> contractAccessoryPOList = this.accessoryMapper.selectByContractId(contractInfoPO.getContractId());
                if (!CollectionUtils.isEmpty(contractAccessoryPOList)) {
                    ArrayList<ContractAccessoryRspBO> contractAccessoryRspBOList = new ArrayList<ContractAccessoryRspBO>();
                    for (ContractAccessoryPO contractAccessoryPO : contractAccessoryPOList) {
                        ContractAccessoryRspBO contractAccessoryRspBO = new ContractAccessoryRspBO();
                        BeanUtils.copyProperties((Object)contractAccessoryPO, (Object)contractAccessoryRspBO);
                        contractAccessoryRspBOList.add(contractAccessoryRspBO);
                    }
                    bo.setContractAccessoryRspBOList(contractAccessoryRspBOList);
                }
                if (!CollectionUtils.isEmpty(contractSupplierSalePOList = this.contractSupplierSaleMapper.selectByContractId(contractInfoPO.getContractId()))) {
                    ArrayList<ContractSupplierSaleRspBO> contractSupplierSaleRspBOList = new ArrayList<ContractSupplierSaleRspBO>();
                    for (ContractSupplierSalePO contractSupplierSalePO : contractSupplierSalePOList) {
                        ContractSupplierSaleRspBO contractSupplierSaleRspBO = new ContractSupplierSaleRspBO();
                        BeanUtils.copyProperties((Object)contractSupplierSalePO, (Object)contractSupplierSaleRspBO);
                        contractSupplierSaleRspBOList.add(contractSupplierSaleRspBO);
                    }
                    bo.setContractSupplierSaleRspBOList(contractSupplierSaleRspBOList);
                }
                if (!CollectionUtils.isEmpty(contractSupplierLadderPOList = this.contractSupplierLadderMapper.selectByContractId(contractInfoPO.getContractId()))) {
                    ArrayList<ContractSupplierLadderRspBO> arrayList = new ArrayList<ContractSupplierLadderRspBO>();
                    for (ContractSupplierLadderPO contractSupplierLadderPO : contractSupplierLadderPOList) {
                        ContractSupplierLadderRspBO contractSupplierLadderRspBO = new ContractSupplierLadderRspBO();
                        BeanUtils.copyProperties((Object)contractSupplierLadderPO, (Object)contractSupplierLadderRspBO);
                        arrayList.add(contractSupplierLadderRspBO);
                    }
                    bo.setContractSupplierLadderRspBOList(arrayList);
                }
                contractSupplierDetailBOList.add(bo);
            }
            rspBO.setContractSupplierDetailBOList(contractSupplierDetailBOList);
        }
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"qrySupplierContractDetailBySupId"})
    public ContractSupCatListRspBO qrySupplierContractDetailBySupId(@RequestBody QuerySupplierContractReqBO reqBO) {
        ContractSupCatListRspBO rspBO = new ContractSupCatListRspBO();
        ArrayList<ContractInfoPO> contractIdList = new ArrayList<ContractInfoPO>();
        for (SupplierContractBO supplierContractBO : reqBO.getSupplierContractBOList()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("enterPurchaserId", supplierContractBO.getEnterPurchaserId());
            map.put("categoryId", supplierContractBO.getCategoryId());
            List<ContractInfoPO> contractInfoPOList = this.contractInfoMapper.queryByMapBySupId(map);
            if (CollectionUtils.isEmpty(contractInfoPOList)) continue;
            contractIdList.add(contractInfoPOList.get(0));
        }
        if (!CollectionUtils.isEmpty(contractIdList)) {
            ArrayList<ContractSupCatListDetailBO> contractSupplierDetailBOList = new ArrayList<ContractSupCatListDetailBO>();
            for (ContractInfoPO contractInfoPO : contractIdList) {
                ContractSupCatListDetailBO contractSupplierDetailBO = new ContractSupCatListDetailBO();
                contractSupplierDetailBO.setCategoryId(contractInfoPO.getCategoryId());
                contractSupplierDetailBO.setContractId(contractInfoPO.getContractId().toString());
                contractSupplierDetailBO.setEnterPurchaserId(contractInfoPO.getEnterPurchaserId());
                contractSupplierDetailBOList.add(contractSupplierDetailBO);
            }
            rspBO.setContractInfoList(contractSupplierDetailBOList);
        }
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }
}

