/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.order.busi.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.order.bo.QryContractOrderInfoReqBO;
import com.tydic.contract.api.order.bo.QryContractOrderInfoRspBO;
import com.tydic.contract.api.order.service.QryContractOrderInfoService;
import com.tydic.contract.api.supplier.bo.ContractPayTypeListBO;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractPayTypeMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractPayTypePO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.order.service.QryContractOrderInfoService"})
public class QryContractOrderInfoServiceImpl
implements QryContractOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(QryContractOrderInfoServiceImpl.class);
    @Resource
    private ContractInfoMapper contractInfoMapper;
    @Resource
    private ContractPayTypeMapper contractPayTypeMapper;

    @PostMapping(value={"selectListByCondition"})
    public RspPage<QryContractOrderInfoRspBO> selectListByCondition(@RequestBody QryContractOrderInfoReqBO reqBO) {
        RspPage rspPage = new RspPage();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        ArrayList<QryContractOrderInfoRspBO> contractOrderList = new ArrayList<QryContractOrderInfoRspBO>();
        try {
            Map<String, Object> condition = this.getCondition(reqBO);
            log.error("condition\u7684\u503c+++++++++++++:" + condition);
            List<ContractInfoPO> contractOrderInfos = this.contractInfoMapper.selectListByCondition(condition, (Page<ContractInfoPO>)page);
            if (CollectionUtils.isEmpty(contractOrderInfos)) {
                rspPage.setCode("0000");
                rspPage.setMessage("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return rspPage;
            }
            for (ContractInfoPO contractInfoPO : contractOrderInfos) {
                QryContractOrderInfoRspBO bo = new QryContractOrderInfoRspBO();
                BeanUtils.copyProperties((Object)contractInfoPO, (Object)bo);
                StringBuilder payTypeStr = new StringBuilder();
                List<ContractPayTypePO> contractPayTypePOList = this.contractPayTypeMapper.selectByContractId(bo.getContractId());
                if (!CollectionUtils.isEmpty(contractPayTypePOList)) {
                    ArrayList<ContractPayTypeListBO> contractPayTypeListBOList = new ArrayList<ContractPayTypeListBO>();
                    for (ContractPayTypePO contractPayTypePO : contractPayTypePOList) {
                        ContractPayTypeListBO contractPayTypeListBO = new ContractPayTypeListBO();
                        BeanUtils.copyProperties((Object)contractPayTypePO, (Object)contractPayTypeListBO);
                        contractPayTypeListBOList.add(contractPayTypeListBO);
                        payTypeStr.append(contractPayTypePO.getPayTypeStr()).append("\u3001");
                    }
                    payTypeStr.substring(0, payTypeStr.length() - 2);
                    bo.setPayTypeStr(payTypeStr.substring(0, payTypeStr.length() - 2));
                    bo.setPayTypeList(contractPayTypeListBOList);
                }
                if (bo.getContractStatus() != null) {
                    switch (bo.getContractStatus()) {
                        case 1: {
                            bo.setContractStatusStr("\u8349\u7a3f");
                            break;
                        }
                        case 2: {
                            bo.setContractStatusStr("\u5ba1\u6279\u4e2d");
                            break;
                        }
                        case 4: {
                            bo.setContractStatusStr("\u5ba1\u6279\u901a\u8fc7");
                            break;
                        }
                        case 5: {
                            bo.setContractStatusStr("\u9a73\u56de");
                            break;
                        }
                        case 6: {
                            bo.setContractStatusStr("\u53d8\u66f4\u7533\u8bf7\u4e2d");
                            break;
                        }
                        case 8: {
                            bo.setContractStatusStr("\u751f\u6210\u65b9\u5f85\u7b7e\u7ae0");
                            break;
                        }
                        case 9: {
                            bo.setContractStatusStr("\u7b7e\u8ba2\u65b9\u5f85\u7b7e\u7ae0");
                            break;
                        }
                        case 10: {
                            bo.setContractStatusStr("\u5df2\u751f\u6548");
                            break;
                        }
                        case 11: {
                            bo.setContractStatusStr("\u5df2\u5931\u6548");
                            break;
                        }
                        case 12: {
                            bo.setContractStatusStr("\u5f85\u751f\u6548");
                            break;
                        }
                        default: {
                            bo.setContractStatusStr("\u5176\u4ed6");
                        }
                    }
                }
                if (bo.getContractType() != null) {
                    switch (bo.getContractType()) {
                        case 1: {
                            bo.setContractTypeStr("\u91c7\u8d2d\u8ba2\u5355\u5408\u540c");
                            break;
                        }
                        case 2: {
                            bo.setContractTypeStr("\u6846\u67b6\u534f\u8bae\u5408\u540c");
                            break;
                        }
                        case 3: {
                            bo.setContractTypeStr("\u5165\u9a7b\u670d\u52a1\u5408\u540c");
                            break;
                        }
                        default: {
                            bo.setContractStatusStr("\u5176\u4ed6");
                        }
                    }
                }
                if (bo.getSupplierType() != null) {
                    switch (bo.getSupplierType()) {
                        case 1: {
                            bo.setSupplierTypeStr("\u4f9b\u5e94\u5546");
                            break;
                        }
                        case 2: {
                            bo.setSupplierTypeStr("\u91c7\u8d2d\u5546");
                            break;
                        }
                        default: {
                            bo.setSupplierTypeStr("\u4f9b\u5e94\u5546+\u91c7\u8d2d\u5546");
                        }
                    }
                }
                if (bo.getServiceFeeType() != null) {
                    switch (bo.getServiceFeeType()) {
                        case 0: {
                            bo.setServiceFeeTypeStr("\u6708\u7ed3");
                            break;
                        }
                        default: {
                            bo.setServiceFeeTypeStr("\u5b9e\u65f6\u6263\u9664");
                        }
                    }
                }
                contractOrderList.add(bo);
            }
            rspPage.setRows(contractOrderList);
            rspPage.setPageNo(page.getPageNo());
            rspPage.setRecordsTotal(page.getTotalCount());
            rspPage.setTotal(page.getTotalPages());
            rspPage.setCode("0000");
            rspPage.setMessage("\u5408\u540c\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspPage;
    }

    private Map<String, Object> getCondition(QryContractOrderInfoReqBO reqBO) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("contractCode", StringUtils.trimToNull((String)reqBO.getContractCode()));
        condition.put("contractName", StringUtils.trimToNull((String)reqBO.getContractName()));
        condition.put("createUserName", StringUtils.trimToNull((String)reqBO.getCreateUserName()));
        condition.put("purchaseOrderCode", StringUtils.trimToNull((String)reqBO.getPurchaseOrderCode()));
        condition.put("saleOrderCode", StringUtils.trimToNull((String)reqBO.getSaleOrderCode()));
        condition.put("beginTime", reqBO.getBeginTime());
        condition.put("endTime", reqBO.getEndTime());
        condition.put("contractAmountMaxLong", reqBO.getContractAmountMaxLong());
        condition.put("contractAmountMinLong", reqBO.getContractAmountMinLong());
        condition.put("supplierId", reqBO.getSupplierId());
        condition.put("contractStatusList", reqBO.getContractStatusList());
        condition.put("validStatus", reqBO.getValidStatus());
        condition.put("contractType", reqBO.getContractType());
        condition.put("orgIdList", reqBO.getOrgIdList());
        condition.put("plaAgreementCode", reqBO.getPlaAgreementCode());
        condition.put("ecpAgreementCode", reqBO.getEcpAgreementCode());
        condition.put("contractStatus", reqBO.getContractStatus());
        condition.put("enterPurchaserName", reqBO.getEnterPurchaserName());
        condition.put("enterPurchaserId", reqBO.getEnterPurchaserId());
        condition.put("signApplicationCode", reqBO.getSignApplicationCode());
        condition.put("supplierType", reqBO.getSupplierType());
        condition.put("validStatus", 1);
        condition.put("contractIds", reqBO.getContractIds());
        condition.put("status", reqBO.getStatus());
        condition.put("busiMode", reqBO.getBusiMode());
        condition.put("agreementMode", reqBO.getAgreementMode());
        condition.put("supplierId", reqBO.getSupplierId());
        condition.put("ecpProjectId", reqBO.getEcpProjectId());
        return condition;
    }
}

