/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.mq;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.EcpContractPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncContractEcpMesConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(SyncContractEcpMesConsumer.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        EcpContractPO ecpContractPO = (EcpContractPO)JSON.parseObject((String)message.getContent(), EcpContractPO.class);
        log.info("ECP\u5408\u540c\u540c\u6b65\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)ecpContractPO));
        try {
            if (ecpContractPO != null) {
                ContractInfoPO contractInfoPO = new ContractInfoPO();
                contractInfoPO.setEcpContractId(ecpContractPO.getEcpContractId());
                contractInfoPO.setContractName(ecpContractPO.getContractName());
                contractInfoPO.setEcpAgreementCode(ecpContractPO.getContractCode());
                contractInfoPO.setEntAgreementCode(ecpContractPO.getCustomContractCode());
                contractInfoPO.setEnterPurchaserId(Long.valueOf(ecpContractPO.getVendorId()));
                contractInfoPO.setEnterPurchaserName(ecpContractPO.getVendorName());
                contractInfoPO.setSignDate(ecpContractPO.getEffDate() == null ? new Date() : ecpContractPO.getEffDate());
                contractInfoPO.setEffTime(ecpContractPO.getExpDate() == null ? new Date() : ecpContractPO.getExpDate());
                this.contractInfoMapper.updateByEcpContractId(contractInfoPO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("ECP\u5408\u540c\u6d88\u606f\u540c\u6b65\u4fee\u6539\u5931\u8d25:" + e.toString());
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

