/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.ecp.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.api.ecp.EcpContractOperateService;
import com.tydic.contract.api.ecp.bo.EcpContractBO;
import com.tydic.contract.api.ecp.bo.EcpContractOperateReqBO;
import com.tydic.contract.api.ecp.bo.EcpContractOperateRspBO;
import com.tydic.contract.api.ecp.bo.QryEcpContractReqBO;
import com.tydic.contract.api.ecp.bo.QryEcpContractRspBO;
import com.tydic.contract.dao.EcpContractMapper;
import com.tydic.contract.dao.EcpContractScopeMapper;
import com.tydic.contract.po.EcpContractPO;
import com.tydic.contract.po.EcpContractScopePO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.ecp.EcpContractOperateService"})
public class EcpContractOperateServiceImpl
implements EcpContractOperateService {
    private static final Logger log = LoggerFactory.getLogger(EcpContractOperateServiceImpl.class);
    @Autowired
    private EcpContractMapper ecpContractMapper;
    @Autowired
    private EcpContractScopeMapper ecpContractScopeMapper;
    @Value(value="${CONTRACT_SYNC_ECP_TOPIC:CONTRACT_SYNC_ECP_TOPIC}")
    private String CONTRACT_SYNC_ECP_TOPIC;
    @Value(value="${CONTRACT_SYNC_ECP_TAG:CONTRACT_SYNC_ECP_TAG}")
    private String CONTRACT_SYNC_ECP_TAG;
    @Resource(name="syncContractEcpMesProvider")
    private ProxyMessageProducer syncContractEcpMesProvider;

    @PostMapping(value={"syncEcpContract"})
    public EcpContractOperateRspBO syncEcpContract(@RequestBody EcpContractOperateReqBO reqBO) {
        log.info("ECP\u540c\u6b65\u5408\u540c\u5165\u53c2\u8be6\u60c5:{}", (Object)JSON.toJSONString((Object)reqBO));
        EcpContractOperateRspBO rspBO = new EcpContractOperateRspBO();
        try {
            EcpContractPO checkEcpContractPO;
            EcpContractPO ecpContractPO = (EcpContractPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), EcpContractPO.class);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(ecpContractPO.getEffDate());
            calendar.add(10, 0);
            calendar.add(12, 0);
            calendar.add(13, 0);
            ecpContractPO.setEffDate(calendar.getTime());
            calendar.setTime(ecpContractPO.getExpDate());
            calendar.add(10, 23);
            calendar.add(12, 59);
            calendar.add(13, 59);
            ecpContractPO.setExpDate(calendar.getTime());
            List ecpContractScopePOList = null;
            if (!CollectionUtils.isEmpty((Collection)reqBO.getScopeCodeBoList())) {
                ecpContractScopePOList = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getScopeCodeBoList()), EcpContractScopePO.class);
                for (EcpContractScopePO ecpContractScopePO : ecpContractScopePOList) {
                    ecpContractScopePO.setEcpContractId(reqBO.getEcpContractId());
                }
            }
            if ((checkEcpContractPO = this.ecpContractMapper.selectByContractId(reqBO.getEcpContractId())) != null) {
                int result;
                if (!CollectionUtils.isEmpty((Collection)ecpContractScopePOList)) {
                    this.ecpContractScopeMapper.deleteByContractId(reqBO.getEcpContractId());
                    this.ecpContractScopeMapper.insertBatch(ecpContractScopePOList);
                }
                if ((result = this.ecpContractMapper.updateByPrimaryKeySelective(ecpContractPO)) < 0) {
                    throw new Exception("\u65b0\u589eECP\u5408\u540c\u5931\u8d25!");
                }
            } else {
                int result = this.ecpContractMapper.insert(ecpContractPO);
                if (result < 0) {
                    throw new Exception("\u66f4\u65b0ECP\u5408\u540c\u5931\u8d25!");
                }
                if (!CollectionUtils.isEmpty((Collection)ecpContractScopePOList)) {
                    this.ecpContractScopeMapper.insertBatch(ecpContractScopePOList);
                }
            }
            this.syncContractEcpMesProvider.send(new ProxyMessage(this.CONTRACT_SYNC_ECP_TOPIC, this.CONTRACT_SYNC_ECP_TAG, JSON.toJSONString((Object)reqBO)));
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setCode("1");
            rspBO.setMessage("\u5931\u8d25");
            rspBO.setSuccess(Boolean.valueOf(false));
            rspBO.setMeta("ECP\u5408\u540c\u540c\u6b65\u5931\u8d25:" + e.toString());
            return rspBO;
        }
        rspBO.setCode("0");
        rspBO.setMessage("\u6210\u529f");
        rspBO.setSuccess(Boolean.valueOf(true));
        rspBO.setMeta("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"qryEcpContractList"})
    public QryEcpContractRspBO qryEcpContractList(@RequestBody QryEcpContractReqBO reqBO) {
        QryEcpContractRspBO rspBO = new QryEcpContractRspBO();
        EcpContractPO ecpContractPO = new EcpContractPO();
        ecpContractPO.setOrgId(reqBO.getOrgId().toString());
        List ecpContractBOS = new ArrayList();
        List<EcpContractPO> ecpContractPOS = this.ecpContractMapper.selectListPageByCondition(ecpContractPO, (Page<EcpContractPO>)new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue()));
        if (!CollectionUtils.isEmpty(ecpContractPOS)) {
            ecpContractBOS = JSON.parseArray((String)JSON.toJSONString(ecpContractPOS), EcpContractBO.class);
        }
        rspBO.setRows(ecpContractBOS);
        return rspBO;
    }
}

