/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.ecp.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.contract.api.ecp.EcpSyncContractService;
import com.tydic.contract.api.ecp.bo.EcpSyncContractReqBO;
import com.tydic.contract.api.ecp.bo.EcpSyncContractRspBO;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.EcpContractPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.ecp.EcpSyncContractService"})
public class EcpSyncContractServiceImpl
implements EcpSyncContractService {
    private static final Logger log = LoggerFactory.getLogger(EcpSyncContractServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @PostMapping(value={"syncContract"})
    public EcpSyncContractRspBO syncContract(@RequestBody EcpSyncContractReqBO reqBO) {
        EcpSyncContractRspBO rspBO = new EcpSyncContractRspBO();
        EcpContractPO ecpContractPO = (EcpContractPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), EcpContractPO.class);
        log.info("ECP\u5408\u540c\u540c\u6b65\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)ecpContractPO));
        try {
            if (ecpContractPO != null) {
                ContractInfoPO contractInfoPO = new ContractInfoPO();
                contractInfoPO.setEcpContractId(ecpContractPO.getEcpContractId());
                contractInfoPO.setContractName(ecpContractPO.getContractName());
                contractInfoPO.setEcpAgreementCode(ecpContractPO.getContractCode());
                contractInfoPO.setEntAgreementCode(ecpContractPO.getCustomContractCode());
                contractInfoPO.setEnterPurchaserId(Long.valueOf(ecpContractPO.getVendorId()));
                contractInfoPO.setEnterPurchaserName(ecpContractPO.getVendorName());
                contractInfoPO.setEcpPurType(ecpContractPO.getCenterPurchaseType().toString());
                contractInfoPO.setSignDate(ecpContractPO.getEffDate() == null ? new Date() : ecpContractPO.getEffDate());
                contractInfoPO.setEffTime(ecpContractPO.getExpDate() == null ? new Date() : ecpContractPO.getExpDate());
                this.contractInfoMapper.updateByEcpContractId(contractInfoPO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("ECP\u5408\u540c\u6d88\u606f\u540c\u6b65\u4fee\u6539\u5931\u8d25:" + e.toString());
        }
        return rspBO;
    }
}

