/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.supplier.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleRspBO;
import com.tydic.contract.api.supplier.bo.QueryCategoryBySupplierReqBO;
import com.tydic.contract.api.supplier.bo.QueryCategoryBySupplierRspBO;
import com.tydic.contract.api.supplier.service.QueryCategoryBySupplierService;
import com.tydic.contract.dao.ContractSupplierSaleMapper;
import com.tydic.contract.po.ContractSupplierSalePO;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.supplier.service.QueryCategoryBySupplierService"})
public class QueryCategoryBySupplierServiceImpl
implements QueryCategoryBySupplierService {
    private static final Logger log = LoggerFactory.getLogger(QueryCategoryBySupplierServiceImpl.class);
    @Autowired
    private ContractSupplierSaleMapper contractSupplierSaleMapper;

    @PostMapping(value={"queryCategoryBySupplier"})
    public QueryCategoryBySupplierRspBO queryCategoryBySupplier(@RequestBody QueryCategoryBySupplierReqBO reqBO) {
        QueryCategoryBySupplierRspBO rspBO = new QueryCategoryBySupplierRspBO();
        if (null == reqBO.getSupplierId()) {
            throw new BusinessException("8888", "\u67e5\u8be2\u4f9b\u5e94\u5546\u9500\u552e\u8303\u56f4API\u5165\u53c2\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ContractSupplierSalePO salePO = new ContractSupplierSalePO();
        salePO.setEnterPurchaserId(reqBO.getSupplierId());
        salePO.setCategoryName(reqBO.getCategoryName());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ContractSupplierSalePO> resultPO = this.contractSupplierSaleMapper.queryCategoryBySupplier(salePO, (Page<ContractSupplierSalePO>)page);
        if (!CollectionUtils.isEmpty(resultPO)) {
            ArrayList categoryIds = new ArrayList();
            ArrayList rows = new ArrayList();
            resultPO.forEach(po -> {
                categoryIds.add(po.getCategoryId());
                ContractSupplierSaleRspBO saleRspBO = new ContractSupplierSaleRspBO();
                saleRspBO.setCategoryId(po.getCategoryId());
                saleRspBO.setCategoryName(po.getCategoryName());
                rows.add(saleRspBO);
            });
            rspBO.setRows(rows);
            rspBO.setCategoryIds(categoryIds);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }
}

