/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.maintenance.busi.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleReqBO;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleRspBO;
import com.tydic.contract.api.maintenance.service.QryContractSupplierListSaleService;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractSupplierSaleChangeMapper;
import com.tydic.contract.dao.ContractSupplierSaleMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractSupplierSalePO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.maintenance.service.QryContractSupplierListSaleService"})
public class QryContractSupplierListSaleServiceImpl
implements QryContractSupplierListSaleService {
    private static final Logger log = LoggerFactory.getLogger(QryContractSupplierListSaleServiceImpl.class);
    @Autowired
    private ContractSupplierSaleMapper contractSupplierSaleMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractSupplierSaleChangeMapper contractSupplierSaleChangeMapper;
    private static final Integer none = 0;
    private static final Integer modify = 1;
    private static final Integer add = 2;
    private static final Integer delete = 3;

    @PostMapping(value={"selecContractSupplierList"})
    public RspPage<ContractSupplierSaleRspBO> selecContractSupplierList(@RequestBody ContractSupplierSaleReqBO contractSupplierSaleReqBO) {
        RspPage rspPage = new RspPage();
        try {
            Page page = new Page(contractSupplierSaleReqBO.getPageNo(), contractSupplierSaleReqBO.getPageSize());
            ContractSupplierSalePO contractSupplierSalePO = new ContractSupplierSalePO();
            BeanUtils.copyProperties((Object)contractSupplierSaleReqBO, (Object)contractSupplierSalePO);
            if (contractSupplierSalePO.getUpdateApplyId() != null) {
                contractSupplierSalePO.setContractId(contractSupplierSalePO.getContractId());
                contractSupplierSalePO.setUpdateApplyId(contractSupplierSalePO.getUpdateApplyId());
                contractSupplierSalePO.setChangeType(contractSupplierSaleReqBO.getChangeType());
                contractSupplierSalePO.setOnlyChanged(contractSupplierSaleReqBO.getOnlyChanged());
                List<ContractSupplierSalePO> contractSupplierSalePOs = this.contractSupplierSaleChangeMapper.selectPageListSelective(contractSupplierSalePO, (Page<ContractSupplierSalePO>)page);
                if (!CollectionUtils.isEmpty(contractSupplierSalePOs)) {
                    List contractSupplierSaleRspBOs = contractSupplierSalePOs.stream().map(contractSupplierSale -> {
                        String discountS;
                        Integer discount;
                        String rateFeeS;
                        Integer rateFee;
                        ContractSupplierSaleRspBO contractSupplierSaleRspBO = new ContractSupplierSaleRspBO();
                        BeanUtils.copyProperties((Object)contractSupplierSale, (Object)contractSupplierSaleRspBO);
                        DecimalFormat df = new DecimalFormat("0.00");
                        if (contractSupplierSale.getRateFee() != null) {
                            rateFee = contractSupplierSale.getRateFee();
                            rateFeeS = df.format((float)rateFee.intValue() / 100.0f);
                            contractSupplierSaleRspBO.setRateFee(new BigDecimal(rateFeeS));
                        }
                        if (contractSupplierSale.getDiscount() != null) {
                            discount = contractSupplierSale.getDiscount();
                            discountS = df.format((float)discount.intValue() / 100.0f);
                            contractSupplierSaleRspBO.setDiscount(new BigDecimal(discountS));
                        }
                        if (contractSupplierSale.getPreDiscount() != null) {
                            rateFee = Integer.valueOf(contractSupplierSale.getPreDiscount());
                            rateFeeS = df.format((float)rateFee.intValue() / 100.0f);
                            contractSupplierSaleRspBO.setPreDiscount(new BigDecimal(rateFeeS));
                        }
                        if (contractSupplierSale.getPreOrderLimit() != null) {
                            contractSupplierSaleRspBO.setPreOrderLimit(contractSupplierSale.getPreOrderLimit());
                        }
                        if (contractSupplierSale.getPreRateFee() != null) {
                            discount = Integer.valueOf(contractSupplierSale.getPreRateFee());
                            discountS = df.format((float)discount.intValue() / 100.0f);
                            contractSupplierSaleRspBO.setPreRateFee(new BigDecimal(discountS));
                        }
                        return contractSupplierSaleRspBO;
                    }).collect(Collectors.toList());
                    rspPage.setPageNo(page.getPageNo());
                    rspPage.setRows(contractSupplierSaleRspBOs);
                    rspPage.setTotal(page.getTotalPages());
                    rspPage.setRecordsTotal(page.getTotalCount());
                    rspPage.setCode("0000");
                    rspPage.setMessage("\u6210\u529f");
                }
            } else {
                List<ContractSupplierSalePO> contractSupplierSalePOs = this.contractSupplierSaleMapper.selectPageListSelective(contractSupplierSalePO, (Page<ContractSupplierSalePO>)page);
                List contractSupplierSaleRspBOs = contractSupplierSalePOs.stream().map(contractSupplierSale -> {
                    ContractSupplierSaleRspBO contractSupplierSaleRspBO = new ContractSupplierSaleRspBO();
                    BeanUtils.copyProperties((Object)contractSupplierSale, (Object)contractSupplierSaleRspBO);
                    DecimalFormat df = new DecimalFormat("0.00");
                    if (contractSupplierSale.getRateFee() != null) {
                        Integer rateFee = contractSupplierSale.getRateFee();
                        String rateFeeS = df.format((float)rateFee.intValue() / 100.0f);
                        contractSupplierSaleRspBO.setRateFee(new BigDecimal(rateFeeS));
                    }
                    if (contractSupplierSale.getDiscount() != null) {
                        Integer discount = contractSupplierSale.getDiscount();
                        String discountS = df.format((float)discount.intValue() / 100.0f);
                        contractSupplierSaleRspBO.setDiscount(new BigDecimal(discountS));
                    }
                    return contractSupplierSaleRspBO;
                }).collect(Collectors.toList());
                rspPage.setPageNo(page.getPageNo());
                rspPage.setRows(contractSupplierSaleRspBOs);
                rspPage.setTotal(page.getTotalPages());
                rspPage.setRecordsTotal(page.getTotalCount());
                rspPage.setCode("0000");
                rspPage.setMessage("\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4f9b\u8d27\u55461\u9500\u552e\u54c1\u7c7b\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u4f9b\u8d27\u55461\u9500\u552e\u54c1\u7c7b\u5217\u8868\u5931\u8d25");
        }
        return rspPage;
    }

    @PostMapping(value={"selectContractSupplierListByMap"})
    public ContractSupplierSaleRspBO selectContractSupplierListByMap(@RequestBody ContractSupplierSaleReqBO contractSupplierSaleReqBO) {
        ContractSupplierSaleRspBO contractSupplierSaleRspBO = new ContractSupplierSaleRspBO();
        ArrayList<Map<String, String>> queryMap = new ArrayList<Map<String, String>>();
        HashMap feeMap = new HashMap();
        HashMap keyMap = new HashMap();
        contractSupplierSaleRspBO.setSkuFeeMap(feeMap);
        for (Map.Entry entry : contractSupplierSaleReqBO.getSkuSaleMap().entrySet()) {
            String[] mapValue = ((String)entry.getValue()).split("_");
            if (mapValue.length < 2) continue;
            HashMap<String, String> tempMap = new HashMap<String, String>();
            tempMap.put("enterPurchaserId", mapValue[0]);
            tempMap.put("categoryId", mapValue[1]);
            keyMap.put(mapValue[0] + "_" + mapValue[1], entry.getKey());
            queryMap.add(tempMap);
        }
        ContractSupplierSalePO contractSupplierSalePO = new ContractSupplierSalePO();
        contractSupplierSalePO.setQueryMap(queryMap);
        List<ContractSupplierSalePO> contractSupplierSalePOs = this.contractSupplierSaleMapper.selectListByMap(contractSupplierSalePO);
        if (!CollectionUtils.isEmpty(contractSupplierSalePOs)) {
            HashMap<String, String> tempMap = new HashMap<String, String>();
            DecimalFormat df = new DecimalFormat("0.00");
            for (ContractSupplierSalePO contractSupplierSalePO2 : contractSupplierSalePOs) {
                if (contractSupplierSalePO2.getEnterPurchaserId() == null || contractSupplierSalePO2.getCategoryId() == null || contractSupplierSalePO2.getDiscount() == null) continue;
                String discountS = df.format((float)contractSupplierSalePO2.getDiscount().intValue() / 10000.0f);
                tempMap.put(contractSupplierSalePO2.getEnterPurchaserId() + "_" + contractSupplierSalePO2.getCategoryId(), discountS);
            }
            for (Map.Entry entry : contractSupplierSaleReqBO.getSkuSaleMap().entrySet()) {
                String discount = (String)tempMap.get(entry.getValue());
                if (discount == null) continue;
                feeMap.put(entry.getKey(), discount);
            }
        }
        return contractSupplierSaleRspBO;
    }

    @PostMapping(value={"selecContractSupplierListByEnterPurchaserId"})
    public List<ContractSupplierSaleRspBO> selecContractSupplierListByEnterPurchaserId(@RequestBody ContractSupplierSaleReqBO contractSupplierSaleReqBO) {
        ArrayList<ContractSupplierSaleRspBO> contractSupplierSaleRspBOs = new ArrayList<ContractSupplierSaleRspBO>();
        try {
            ContractInfoPO po = new ContractInfoPO();
            BeanUtils.copyProperties((Object)contractSupplierSaleReqBO, (Object)po);
            po.setValidStatus(1);
            ContractInfoPO poo = this.contractInfoMapper.selectByPrimaryKey(contractSupplierSaleReqBO.getContractId());
            Long contratcId = null;
            if (poo == null) {
                return contractSupplierSaleRspBOs;
            }
            contratcId = poo.getContractId();
            contractSupplierSaleReqBO.setContractId(contratcId);
            ContractSupplierSalePO contractSupplierSalePO = new ContractSupplierSalePO();
            BeanUtils.copyProperties((Object)contractSupplierSaleReqBO, (Object)contractSupplierSalePO);
            List<ContractSupplierSalePO> contractSupplierSalePOs = this.contractSupplierSaleMapper.selectPageListSelectiveNoPage(contractSupplierSalePO);
            if (contractSupplierSalePOs != null && contractSupplierSalePOs.size() > 0) {
                for (ContractSupplierSalePO contractSupplierSale : contractSupplierSalePOs) {
                    ContractSupplierSaleRspBO contractSupplierSaleRspBO = new ContractSupplierSaleRspBO();
                    BeanUtils.copyProperties((Object)contractSupplierSale, (Object)contractSupplierSaleRspBO);
                    DecimalFormat df = new DecimalFormat("0.00");
                    if (contractSupplierSale.getRateFee() != null) {
                        Integer rateFee = contractSupplierSale.getRateFee();
                        String rateFeeS = df.format((float)rateFee.intValue() / 100.0f);
                        contractSupplierSaleRspBO.setRateFee(new BigDecimal(rateFeeS));
                    }
                    if (contractSupplierSale.getDiscount() != null) {
                        Integer discount = contractSupplierSale.getDiscount();
                        String discountS = df.format((float)discount.intValue() / 100.0f);
                        contractSupplierSaleRspBO.setDiscount(new BigDecimal(discountS));
                    }
                    contractSupplierSaleRspBOs.add(contractSupplierSaleRspBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4f9b\u8d27\u55461\u9500\u552e\u54c1\u7c7b\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u4f9b\u8d27\u55461\u9500\u552e\u54c1\u7c7b\u5217\u8868\u5931\u8d25");
        }
        return contractSupplierSaleRspBOs;
    }

    private void initUpdateBO(ContractSupplierSaleRspBO before, ContractSupplierSaleRspBO after) {
        if (before != null && after != null) {
            if (before.getDiscount() != null && after.getDiscount() != null && before.getDiscount().compareTo(after.getDiscount()) != 0) {
                after.setPreDiscount(before.getPreDiscount());
                after.setChangeType(modify);
            }
            if (before.getRateFee() != null && after.getRateFee() != null && before.getRateFee().compareTo(after.getRateFee()) != 0) {
                after.setPreRateFee(before.getPreRateFee());
                after.setChangeType(modify);
            }
            if (before.getOrderLimit() != null && after.getOrderLimit() != null && !before.getOrderLimit().equals(after.getOrderLimit())) {
                after.setOrderLimit(before.getOrderLimit());
                after.setChangeType(modify);
            }
        }
    }
}

