/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.supplier.busi.impl;

import com.tydic.contract.api.maintenance.bo.ContractSupplierLadderRspBO;
import com.tydic.contract.api.supplier.bo.QrySupplierHisLadderListReqBO;
import com.tydic.contract.api.supplier.bo.QrySupplierHisLadderListRspBO;
import com.tydic.contract.api.supplier.service.QrySupplierHisLadderListService;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractModifyApplyMapper;
import com.tydic.contract.dao.ContractSupplierLadderLogMapper;
import com.tydic.contract.dao.ContractSupplierLadderMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractModifyApplyPO;
import com.tydic.contract.po.ContractSupplierLadderPO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.supplier.service.QrySupplierHisLadderListService"})
public class QrySupplierHisLadderListServiceImpl
implements QrySupplierHisLadderListService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractModifyApplyMapper contractModifyApplyMapper;
    @Autowired
    private ContractSupplierLadderMapper contractSupplierLadderMapper;
    @Autowired
    private ContractSupplierLadderLogMapper contractSupplierLadderLogMapper;

    @PostMapping(value={"qryLadderList"})
    public QrySupplierHisLadderListRspBO qryLadderList(@RequestBody QrySupplierHisLadderListReqBO reqBO) {
        QrySupplierHisLadderListRspBO qrySupplierHisLadderListRspBO = new QrySupplierHisLadderListRspBO();
        ArrayList contractSupplierLadderRspBOList = new ArrayList();
        qrySupplierHisLadderListRspBO.setContractSupplierLadderRspBOList(contractSupplierLadderRspBOList);
        if (reqBO.getContractId() == null) {
            return qrySupplierHisLadderListRspBO;
        }
        ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
        if (contractInfoPO == null) {
            return qrySupplierHisLadderListRspBO;
        }
        List<ContractSupplierLadderPO> contractSupplierLadderPOS = this.contractSupplierLadderMapper.selectByContractId(reqBO.getContractId());
        if (!CollectionUtils.isEmpty(contractSupplierLadderPOS)) {
            if (contractSupplierLadderPOS.get(0).getIsServiceFee() == null || contractSupplierLadderPOS.get(0).getIsServiceFee().equals(0)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("contractId", reqBO.getContractId());
                map.put("applyStatus", 4);
                List<ContractModifyApplyPO> contractModifyApplyPOS = this.contractModifyApplyMapper.searchModifyApplyList(map);
                if (!CollectionUtils.isEmpty(contractModifyApplyPOS)) {
                    for (ContractModifyApplyPO contractModifyApplyPO : contractModifyApplyPOS) {
                        List<ContractSupplierLadderPO> contractSupplierLadderPOS1 = this.contractSupplierLadderLogMapper.selectByUpdateApplyId(contractModifyApplyPO.getUpdateApplyId());
                        if (CollectionUtils.isEmpty(contractSupplierLadderPOS1) || contractSupplierLadderPOS1.get(0).getIsServiceFee() == null || contractSupplierLadderPOS1.get(0).getIsServiceFee().equals(0)) continue;
                        List contractSupplierLadderRspBOs = contractSupplierLadderPOS1.stream().map(contractSupplierLadder -> {
                            ContractSupplierLadderRspBO contractSupplierLadderRspBO = new ContractSupplierLadderRspBO();
                            BeanUtils.copyProperties((Object)contractSupplierLadder, (Object)contractSupplierLadderRspBO);
                            DecimalFormat df = new DecimalFormat("0.00");
                            DecimalFormat dfMax = new DecimalFormat("0.00");
                            DecimalFormat dfMin = new DecimalFormat("0.00");
                            if (contractSupplierLadder.getRateFee() != null) {
                                Integer rateFee = contractSupplierLadder.getRateFee();
                                String rateFeeS = df.format((float)rateFee.intValue() / 100.0f);
                                contractSupplierLadderRspBO.setRateFee(new BigDecimal(rateFeeS));
                            }
                            if (contractSupplierLadder.getMaxFee() != null) {
                                Long maxFee = contractSupplierLadder.getMaxFee();
                                String MaxFeeS = dfMax.format((float)maxFee.longValue() / 100.0f);
                                contractSupplierLadderRspBO.setMaxFee(new BigDecimal(MaxFeeS));
                            }
                            if (contractSupplierLadder.getMinFee() != null) {
                                Long minFee = contractSupplierLadder.getMinFee();
                                String MinFeeS = dfMin.format((float)minFee.longValue() / 100.0f);
                                contractSupplierLadderRspBO.setMinFee(new BigDecimal(MinFeeS));
                            }
                            return contractSupplierLadderRspBO;
                        }).collect(Collectors.toList());
                        qrySupplierHisLadderListRspBO.setContractSupplierLadderRspBOList(contractSupplierLadderRspBOs);
                    }
                }
            } else {
                List contractSupplierLadderRspBOs = contractSupplierLadderPOS.stream().map(contractSupplierLadder -> {
                    ContractSupplierLadderRspBO contractSupplierLadderRspBO = new ContractSupplierLadderRspBO();
                    BeanUtils.copyProperties((Object)contractSupplierLadder, (Object)contractSupplierLadderRspBO);
                    DecimalFormat df = new DecimalFormat("0.00");
                    DecimalFormat dfMax = new DecimalFormat("0.00");
                    DecimalFormat dfMin = new DecimalFormat("0.00");
                    if (contractSupplierLadder.getRateFee() != null) {
                        Integer rateFee = contractSupplierLadder.getRateFee();
                        String rateFeeS = df.format((float)rateFee.intValue() / 100.0f);
                        contractSupplierLadderRspBO.setRateFee(new BigDecimal(rateFeeS));
                    }
                    if (contractSupplierLadder.getMaxFee() != null) {
                        Long maxFee = contractSupplierLadder.getMaxFee();
                        String MaxFeeS = dfMax.format((float)maxFee.longValue() / 100.0f);
                        contractSupplierLadderRspBO.setMaxFee(new BigDecimal(MaxFeeS));
                    }
                    if (contractSupplierLadder.getMinFee() != null) {
                        Long minFee = contractSupplierLadder.getMinFee();
                        String MinFeeS = dfMin.format((float)minFee.longValue() / 100.0f);
                        contractSupplierLadderRspBO.setMinFee(new BigDecimal(MinFeeS));
                    }
                    return contractSupplierLadderRspBO;
                }).collect(Collectors.toList());
                qrySupplierHisLadderListRspBO.setContractSupplierLadderRspBOList(contractSupplierLadderRspBOs);
            }
        }
        return qrySupplierHisLadderListRspBO;
    }
}

