/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.supplier.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.api.order.bo.ContractAccessoryReqBO;
import com.tydic.contract.api.supplier.bo.BreachRateBO;
import com.tydic.contract.api.supplier.bo.ContractSupplierLadderListReqBO;
import com.tydic.contract.api.supplier.bo.ContractSupplierSaleListReqBO;
import com.tydic.contract.api.supplier.bo.CreateContractSupplierModifyApplyReqBO;
import com.tydic.contract.api.supplier.bo.CreateContractSupplierModifyApplyRspBO;
import com.tydic.contract.api.supplier.service.CreateContractSupplierModifyApplyService;
import com.tydic.contract.constant.Constant;
import com.tydic.contract.dao.BreachRateChangeMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractModifyApplyMapper;
import com.tydic.contract.dao.ContractPayTypeMapper;
import com.tydic.contract.dao.ContractSupplierLadderLogMapper;
import com.tydic.contract.dao.ContractSupplierLadderMapper;
import com.tydic.contract.dao.ContractSupplierSaleChangeMapper;
import com.tydic.contract.dao.ContractSupplierSaleLogMapper;
import com.tydic.contract.dao.ContractSupplierSaleMapper;
import com.tydic.contract.dao.ContractTaskHisMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.BreachRatePO;
import com.tydic.contract.po.ContractAccessoryPO;
import com.tydic.contract.po.ContractModifyApplyPO;
import com.tydic.contract.po.ContractPayTypePO;
import com.tydic.contract.po.ContractSupplierLadderPO;
import com.tydic.contract.po.ContractSupplierSalePO;
import com.tydic.contract.po.ContractTaskHisPO;
import com.tydic.contract.po.ContractTermsPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.supplier.service.CreateContractSupplierModifyApplyService"})
public class CreateContractSupplierModifyApplyServiceImpl
implements CreateContractSupplierModifyApplyService {
    private static final Logger log = LoggerFactory.getLogger(CreateContractSupplierModifyApplyServiceImpl.class);
    @Autowired
    private ContractModifyApplyMapper contractModifyApplyMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractTaskHisMapper contractTaskHisMapper;
    @Autowired
    private ContractSupplierSaleMapper contractSupplierSaleMapper;
    @Autowired
    private ContractSupplierLadderMapper contractSupplierLadderMapper;
    @Autowired
    private ContractSupplierLadderLogMapper contractSupplierLadderLogMapper;
    @Autowired
    private ContractTermsMapper contractTermsMapper;
    @Autowired
    private ContractPayTypeMapper contractPayTypeMapper;
    @Autowired
    private BreachRateChangeMapper breachRateChangeMapper;
    @Autowired
    private ContractSupplierSaleLogMapper contractSupplierSaleLogMapper;
    @Autowired
    private ContractSupplierSaleChangeMapper contractSupplierSaleChangeMapper;
    private static final Integer none = 0;
    private static final Integer modify = 1;
    private static final Integer add = 2;
    private static final Integer delete = 3;

    @PostMapping(value={"createSupplierModifyApply"})
    public CreateContractSupplierModifyApplyRspBO createSupplierModifyApply(@RequestBody CreateContractSupplierModifyApplyReqBO createContractSupplierModifyApplyReqBO) {
        CreateContractSupplierModifyApplyRspBO createContractSupplierModifyApplyRspBO = new CreateContractSupplierModifyApplyRspBO();
        Long updateApplyId = Sequence.getInstance().nextId();
        if (Objects.equals(createContractSupplierModifyApplyReqBO.getSaveOrSubmit(), Constant.CONTRACT_SAVE)) {
            Object contractAccessoryPO;
            ContractModifyApplyPO contractModifyApplyPO = new ContractModifyApplyPO();
            BeanUtils.copyProperties((Object)createContractSupplierModifyApplyReqBO, (Object)contractModifyApplyPO);
            contractModifyApplyPO.setContractStatus(Constant.CONTRACT_DRAFT_STATUS);
            contractModifyApplyPO.setValidStatus(Constant.VALID_STATUS_YES);
            contractModifyApplyPO.setCreateTime(new Date());
            contractModifyApplyPO.setApplyTime(new Date());
            log.error("\u53d8\u66f4\u5408\u540cId" + updateApplyId);
            contractModifyApplyPO.setUpdateApplyId(updateApplyId);
            contractModifyApplyPO.setSignDate(createContractSupplierModifyApplyReqBO.getSignDate());
            contractModifyApplyPO.setEffTime(createContractSupplierModifyApplyReqBO.getEffTime());
            contractModifyApplyPO.setApplyStatus(Constant.CONTRACT_DRAFT_STATUS);
            ContractTermsPO contractTermsPO = this.contractTermsMapper.selectByPrimaryKey(createContractSupplierModifyApplyReqBO.getContractTermId());
            if (contractTermsPO != null) {
                contractModifyApplyPO.setContractTermText(contractTermsPO.getTermText());
            }
            this.contractModifyApplyMapper.insertSelective(contractModifyApplyPO);
            ArrayList<ContractPayTypePO> contractPayTypePOList = new ArrayList<ContractPayTypePO>();
            for (Object contractPayTypeReqBO : createContractSupplierModifyApplyReqBO.getContractPayTypeList()) {
                ContractPayTypePO contractPayTypePO = new ContractPayTypePO();
                BeanUtils.copyProperties((Object)contractPayTypeReqBO, (Object)contractPayTypePO);
                contractPayTypePO.setValidStatus(Constant.VALID_STATUS_YES);
                contractPayTypePO.setUpdateApplyId(updateApplyId);
                contractPayTypePO.setContractId(null);
                contractPayTypePOList.add(contractPayTypePO);
            }
            if (!CollectionUtils.isEmpty(contractPayTypePOList)) {
                this.contractPayTypeMapper.insertBatch(contractPayTypePOList);
            }
            ArrayList<ContractAccessoryPO> contractAccessoryPOList = new ArrayList<ContractAccessoryPO>();
            for (Object contractAccessoryReqBO : createContractSupplierModifyApplyReqBO.getContractAccessoryList()) {
                ContractAccessoryPO contractAccessoryPO2 = new ContractAccessoryPO();
                contractAccessoryPO2.setAcceessoryName(contractAccessoryReqBO.getAcceessoryName());
                contractAccessoryPO2.setAcceessoryUrl(contractAccessoryReqBO.getAcceessoryUrl());
                contractAccessoryPO2.setContractId(createContractSupplierModifyApplyReqBO.getContractId());
                contractAccessoryPO2.setUpdateApplyId(updateApplyId);
                contractAccessoryPO2.setContractType(createContractSupplierModifyApplyReqBO.getContractType());
                contractAccessoryPO2.setCreateTime(new Date());
                contractAccessoryPO2.setValidStatus(Constant.VALID_STATUS_YES);
                contractAccessoryPO2.setAcceessoryType(Constant.ACCEESSORY_TYPE_1);
                contractAccessoryPOList.add(contractAccessoryPO2);
            }
            if (!CollectionUtils.isEmpty(contractAccessoryPOList)) {
                this.contractAccessoryMapper.insertBatch(contractAccessoryPOList);
            }
            ArrayList<ContractAccessoryPO> contractAccessoryUpdatePOList = new ArrayList<ContractAccessoryPO>();
            for (ContractAccessoryReqBO contractAccessoryReqBO : createContractSupplierModifyApplyReqBO.getContractUpdateAccessoryList()) {
                contractAccessoryPO = new ContractAccessoryPO();
                ((ContractAccessoryPO)contractAccessoryPO).setAcceessoryName(contractAccessoryReqBO.getAcceessoryName());
                ((ContractAccessoryPO)contractAccessoryPO).setAcceessoryUrl(contractAccessoryReqBO.getAcceessoryUrl());
                ((ContractAccessoryPO)contractAccessoryPO).setUpdateApplyId(updateApplyId);
                ((ContractAccessoryPO)contractAccessoryPO).setContractType(createContractSupplierModifyApplyReqBO.getContractType());
                ((ContractAccessoryPO)contractAccessoryPO).setCreateTime(new Date());
                ((ContractAccessoryPO)contractAccessoryPO).setValidStatus(Constant.VALID_STATUS_YES);
                ((ContractAccessoryPO)contractAccessoryPO).setAcceessoryType(Constant.ACCEESSORY_TYPE_1);
                contractAccessoryUpdatePOList.add((ContractAccessoryPO)contractAccessoryPO);
            }
            if (!CollectionUtils.isEmpty(contractAccessoryUpdatePOList)) {
                this.contractAccessoryMapper.insertBatch(contractAccessoryUpdatePOList);
            }
            if (createContractSupplierModifyApplyReqBO.getContractSupplierSaleReqBO() != null && createContractSupplierModifyApplyReqBO.getContractSupplierSaleReqBO().getContractSupplierSaleListReqBOList() != null && createContractSupplierModifyApplyReqBO.getContractSupplierSaleReqBO().getContractSupplierSaleListReqBOList().size() > 0) {
                Map contractSupplierSalePOMap;
                ContractSupplierSalePO selectPO = new ContractSupplierSalePO();
                selectPO.setContractId(createContractSupplierModifyApplyReqBO.getContractId());
                List<ContractSupplierSalePO> supplierSalePOS = this.contractSupplierSaleMapper.selectPageListSelectiveNoPage(selectPO);
                if (!CollectionUtils.isEmpty(supplierSalePOS)) {
                    contractAccessoryPO = supplierSalePOS.iterator();
                    while (contractAccessoryPO.hasNext()) {
                        ContractSupplierSalePO supplierSalePO = (ContractSupplierSalePO)contractAccessoryPO.next();
                        supplierSalePO.setUpdateApplyId(updateApplyId);
                        supplierSalePO.setId(null);
                    }
                    this.contractSupplierSaleLogMapper.insertBatch(supplierSalePOS);
                }
                ArrayList<ContractSupplierSalePO> contractSupplierSalePOArrayList = new ArrayList<ContractSupplierSalePO>();
                Map originSupplierSaleMap = supplierSalePOS.stream().collect(Collectors.toMap(ContractSupplierSalePO::getCategoryId, Function.identity(), (key1, key2) -> key2));
                ArrayList<ContractSupplierSalePO> contractSupplierSalePOList = new ArrayList<ContractSupplierSalePO>();
                for (ContractSupplierSaleListReqBO contractSupplierSaleListReqBO : createContractSupplierModifyApplyReqBO.getContractSupplierSaleReqBO().getContractSupplierSaleListReqBOList()) {
                    ContractSupplierSalePO contractSupplierSalePO = new ContractSupplierSalePO();
                    BeanUtils.copyProperties((Object)contractSupplierSaleListReqBO, (Object)contractSupplierSalePO);
                    if (contractSupplierSaleListReqBO.getRateFee() != null) {
                        contractSupplierSalePO.setRateFee(contractSupplierSaleListReqBO.getRateFee().multiply(new BigDecimal("100")).intValue());
                    }
                    if (contractSupplierSaleListReqBO.getDiscount() != null) {
                        contractSupplierSalePO.setDiscount(contractSupplierSaleListReqBO.getDiscount().multiply(new BigDecimal("100")).intValue());
                    }
                    contractSupplierSalePO.setIsServiceFee(createContractSupplierModifyApplyReqBO.getContractSupplierSaleReqBO().getIsServiceFee());
                    contractSupplierSalePO.setServiceFeeNode(createContractSupplierModifyApplyReqBO.getContractSupplierSaleReqBO().getServiceFeeNode());
                    contractSupplierSalePO.setValidStatus(Constant.VALID_STATUS_YES);
                    contractSupplierSalePO.setUpdateApplyId(updateApplyId);
                    contractSupplierSalePO.setContractId(null);
                    contractSupplierSalePO.setCreateTime(new Date());
                    contractSupplierSalePO.setChangeType(none);
                    contractSupplierSalePOList.add(contractSupplierSalePO);
                    contractSupplierSalePOArrayList.add(contractSupplierSalePO);
                }
                if (!CollectionUtils.isEmpty(contractSupplierSalePOList)) {
                    this.contractSupplierSaleMapper.insertBatch(contractSupplierSalePOList);
                }
                if (!CollectionUtils.isEmpty(contractSupplierSalePOMap = contractSupplierSalePOArrayList.stream().collect(Collectors.toMap(ContractSupplierSalePO::getCategoryId, Function.identity(), (key1, key2) -> key2))) && !CollectionUtils.isEmpty(originSupplierSaleMap)) {
                    for (Long key : contractSupplierSalePOMap.keySet()) {
                        if (originSupplierSaleMap.get(key) != null) {
                            this.initUpdateBO((ContractSupplierSalePO)originSupplierSaleMap.get(key), (ContractSupplierSalePO)contractSupplierSalePOMap.get(key));
                            continue;
                        }
                        this.initUpdateBO(null, (ContractSupplierSalePO)contractSupplierSalePOMap.get(key));
                    }
                    for (Long key : originSupplierSaleMap.keySet()) {
                        if (contractSupplierSalePOMap.get(key) != null) continue;
                        ContractSupplierSalePO contractSupplierSalePO = (ContractSupplierSalePO)originSupplierSaleMap.get(key);
                        contractSupplierSalePO.setChangeType(delete);
                        contractSupplierSalePOArrayList.add(contractSupplierSalePO);
                    }
                    if (!CollectionUtils.isEmpty(contractSupplierSalePOArrayList)) {
                        for (ContractSupplierSalePO contractSupplierSalePO : contractSupplierSalePOArrayList) {
                            contractSupplierSalePO.setContractId(createContractSupplierModifyApplyReqBO.getContractId());
                            contractSupplierSalePO.setUpdateApplyId(updateApplyId);
                            contractSupplierSalePO.setId(null);
                        }
                        this.contractSupplierSaleChangeMapper.insertBatch(contractSupplierSalePOArrayList);
                    }
                }
            }
            if (createContractSupplierModifyApplyReqBO.getContractSupplierLadderReqBO() != null && createContractSupplierModifyApplyReqBO.getContractSupplierLadderReqBO().getContractSupplierLadderListReqBOList() != null && createContractSupplierModifyApplyReqBO.getContractSupplierLadderReqBO().getContractSupplierLadderListReqBOList().size() > 0) {
                List<ContractSupplierLadderPO> contractSupplierLadderPOS = this.contractSupplierLadderMapper.selectByContractId(createContractSupplierModifyApplyReqBO.getContractId());
                if (!CollectionUtils.isEmpty(contractSupplierLadderPOS)) {
                    for (ContractSupplierLadderPO contractSupplierLadderPO : contractSupplierLadderPOS) {
                        contractSupplierLadderPO.setUpdateApplyId(updateApplyId);
                        contractSupplierLadderPO.setId(null);
                    }
                    this.contractSupplierLadderLogMapper.insertBatch(contractSupplierLadderPOS);
                }
                ArrayList<ContractSupplierLadderPO> contractSupplierLadderPOList = new ArrayList<ContractSupplierLadderPO>();
                for (ContractSupplierLadderListReqBO contractSupplierLadderListReqBO : createContractSupplierModifyApplyReqBO.getContractSupplierLadderReqBO().getContractSupplierLadderListReqBOList()) {
                    ContractSupplierLadderPO contractSupplierLadderPO = new ContractSupplierLadderPO();
                    BeanUtils.copyProperties((Object)contractSupplierLadderListReqBO, (Object)contractSupplierLadderPO);
                    if (contractSupplierLadderListReqBO.getRateFee() != null) {
                        contractSupplierLadderPO.setRateFee(contractSupplierLadderListReqBO.getRateFee().multiply(new BigDecimal("100")).intValue());
                    }
                    if (contractSupplierLadderListReqBO.getMaxFee() != null) {
                        contractSupplierLadderPO.setMaxFee(contractSupplierLadderListReqBO.getMaxFee().multiply(new BigDecimal("100")).longValue());
                    }
                    if (contractSupplierLadderListReqBO.getMinFee() != null) {
                        contractSupplierLadderPO.setMinFee(contractSupplierLadderListReqBO.getMinFee().multiply(new BigDecimal("100")).longValue());
                    }
                    contractSupplierLadderPO.setIsServiceFee(createContractSupplierModifyApplyReqBO.getContractSupplierLadderReqBO().getIsServiceFee());
                    contractSupplierLadderPO.setValidStatus(Constant.VALID_STATUS_YES);
                    contractSupplierLadderPO.setUpdateApplyId(updateApplyId);
                    contractSupplierLadderPO.setContractId(null);
                    contractSupplierLadderPOList.add(contractSupplierLadderPO);
                }
                if (!CollectionUtils.isEmpty(contractSupplierLadderPOList)) {
                    this.contractSupplierLadderMapper.insertBatch(contractSupplierLadderPOList);
                }
            }
            ContractTaskHisPO contractTaskHisPO = new ContractTaskHisPO();
            contractTaskHisPO.setContractId(createContractSupplierModifyApplyReqBO.getContractId());
            contractTaskHisPO.setUpdateApplyId(contractModifyApplyPO.getUpdateApplyId());
            contractTaskHisPO.setOperName(createContractSupplierModifyApplyReqBO.getUsername());
            contractTaskHisPO.setOperId(createContractSupplierModifyApplyReqBO.getUserId());
            contractTaskHisPO.setArrivalTime(new Date());
            contractTaskHisPO.setOperateTime(new Date());
            contractTaskHisPO.setBusiStep(Constant.CONTRACT_STEP_CREATE);
            contractTaskHisPO.setBusiStepName("\u521b\u5efa\u8349\u7a3f");
            contractTaskHisPO.setOperateBehavior("\u521b\u5efa\u8349\u7a3f");
            contractTaskHisPO.setRoleName(createContractSupplierModifyApplyReqBO.getName());
            contractTaskHisPO.setOperOrgName(createContractSupplierModifyApplyReqBO.getOrgName());
            this.contractTaskHisMapper.insertSelective(contractTaskHisPO);
            if (!CollectionUtils.isEmpty((Collection)createContractSupplierModifyApplyReqBO.getBreachRateList())) {
                this.breachRateChangeMapper.deleteByRelateId(updateApplyId, null);
                ArrayList<BreachRatePO> breachRateList = new ArrayList<BreachRatePO>();
                for (BreachRateBO breachRateBO : createContractSupplierModifyApplyReqBO.getBreachRateList()) {
                    BreachRatePO breachRatePO = new BreachRatePO();
                    breachRatePO.setExtField1(breachRateBO.getExtField1());
                    breachRatePO.setExtField2(breachRateBO.getExtField2());
                    breachRatePO.setExtField3(breachRateBO.getExtField3());
                    breachRatePO.setRate(breachRateBO.getRate());
                    breachRatePO.setEnd(breachRateBO.getEnd());
                    breachRatePO.setStart(breachRateBO.getStart());
                    breachRatePO.setRelateId(updateApplyId);
                    breachRatePO.setRateId(Sequence.getInstance().nextId());
                    breachRateList.add(breachRatePO);
                }
                this.breachRateChangeMapper.insertBatch(breachRateList);
            }
        } else if (createContractSupplierModifyApplyReqBO.getSaveOrSubmit() == Constant.CONTRACT_SUBMIT) {
            // empty if block
        }
        createContractSupplierModifyApplyRspBO.setUpdateApplyId(updateApplyId);
        createContractSupplierModifyApplyRspBO.setContractCode(createContractSupplierModifyApplyReqBO.getContractCode());
        createContractSupplierModifyApplyRspBO.setCode("0000");
        createContractSupplierModifyApplyRspBO.setMessage("0000");
        return createContractSupplierModifyApplyRspBO;
    }

    private void initUpdateBO(ContractSupplierSalePO before, ContractSupplierSalePO after) {
        if (before != null && after != null) {
            if (before.getDiscount() != null && after.getDiscount() != null) {
                after.setPreDiscount(before.getDiscount().toString());
                if (before.getDiscount().compareTo(after.getDiscount()) != 0) {
                    after.setChangeType(modify);
                    after.setPreDiscount(before.getDiscount().toString());
                }
            } else if (before.getDiscount() == null && after.getDiscount() != null && after.getDiscount() != 0) {
                after.setChangeType(modify);
                after.setPreDiscount("0");
            }
            if (before.getRateFee() != null && after.getRateFee() != null) {
                after.setPreRateFee(before.getRateFee().toString());
                if (before.getRateFee().compareTo(after.getRateFee()) != 0) {
                    after.setChangeType(modify);
                    after.setPreRateFee(before.getRateFee().toString());
                }
            } else if (before.getRateFee() == null && after.getRateFee() != null && after.getRateFee() != 0) {
                after.setChangeType(modify);
                after.setPreRateFee("0");
            }
            if (before.getOrderLimit() != null && after.getOrderLimit() != null) {
                after.setPreOrderLimit(before.getOrderLimit());
                if (!before.getOrderLimit().equals(after.getOrderLimit())) {
                    after.setChangeType(modify);
                    after.setPreOrderLimit(before.getOrderLimit());
                }
            } else if (before.getOrderLimit() == null && after.getOrderLimit() != null && !after.getOrderLimit().equals("")) {
                after.setChangeType(modify);
                after.setPreOrderLimit("0");
            }
        } else if (before == null && after != null) {
            after.setChangeType(add);
            after.setPreOrderLimit("0");
            after.setPreRateFee("0");
            after.setPreDiscount("0");
        }
    }
}

