/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.ecp.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.ecp.EcpSyncContractService;
import com.tydic.contract.api.ecp.bo.EcpSyncContractReqBO;
import com.tydic.contract.api.ecp.bo.EcpSyncContractRspBO;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.EcpContractPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.ecp.EcpSyncContractService"})
public class EcpSyncContractServiceImpl
implements EcpSyncContractService {
    private static final Logger log = LoggerFactory.getLogger(EcpSyncContractServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @PostMapping(value={"syncContract"})
    public EcpSyncContractRspBO syncContract(@RequestBody EcpSyncContractReqBO reqBO) {
        EcpSyncContractRspBO rspBO = new EcpSyncContractRspBO();
        ArrayList<Long> contractIds = new ArrayList<Long>();
        rspBO.setContractIds(contractIds);
        EcpContractPO ecpContractPO = (EcpContractPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), EcpContractPO.class);
        log.info("ECP\u5408\u540c\u540c\u6b65\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)ecpContractPO));
        try {
            if (ecpContractPO != null) {
                ContractInfoPO contractInfoPO = new ContractInfoPO();
                contractInfoPO.setEcpContractId(ecpContractPO.getEcpContractId());
                HashMap<String, Object> map = new HashMap<String, Object>(10);
                Page page = new Page(-1, -1);
                map.put("ecpContractId", reqBO.getEcpContractId());
                List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.selectListByCondition(map, (Page<ContractInfoPO>)page);
                if (!CollectionUtils.isEmpty(contractInfoPOS)) {
                    contractInfoPO.setEcpContractId(ecpContractPO.getEcpContractId());
                    contractInfoPO.setContractName(ecpContractPO.getContractName());
                    contractInfoPO.setEcpAgreementCode(ecpContractPO.getContractCode());
                    contractInfoPO.setEntAgreementCode(ecpContractPO.getCustomContractCode());
                    contractInfoPO.setEnterPurchaserId(Long.valueOf(ecpContractPO.getVendorId()));
                    contractInfoPO.setEnterPurchaserName(ecpContractPO.getVendorName());
                    contractInfoPO.setEcpPurType(ecpContractPO.getCenterPurchaseType().toString());
                    contractInfoPO.setEcpVendorSource(ecpContractPO.getVendorSource().toString());
                    contractInfoPO.setIntroduceType(ecpContractPO.getPurchaseWay());
                    contractInfoPO.setSignDate(ecpContractPO.getEffDate() == null ? new Date() : ecpContractPO.getEffDate());
                    contractInfoPO.setEffTime(ecpContractPO.getExpDate() == null ? new Date() : ecpContractPO.getExpDate());
                    for (ContractInfoPO contractInfoPO1 : contractInfoPOS) {
                        contractInfoPO.setContractId(contractInfoPO1.getContractId());
                        this.contractInfoMapper.updateByEcpContractId(contractInfoPO);
                        contractIds.add(contractInfoPO1.getContractId());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("ECP\u5408\u540c\u6d88\u606f\u540c\u6b65\u4fee\u6539\u5931\u8d25:" + e.toString());
        }
        return rspBO;
    }
}

