/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.order.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.api.order.bo.ContractAccessoryReqBO;
import com.tydic.contract.api.order.bo.ContractOrderCreateReqBO;
import com.tydic.contract.api.order.bo.ContractOrderCreateRspBO;
import com.tydic.contract.api.order.service.ContractOrderCreateService;
import com.tydic.contract.constant.Constant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractOrderInfoMapper;
import com.tydic.contract.dao.ContractTaskHisMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.ContractAccessoryPO;
import com.tydic.contract.po.ContractOrderInfoPO;
import com.tydic.contract.po.ContractTaskHisPO;
import com.tydic.contract.po.ContractTermsPO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.order.service.ContractOrderCreateService"})
public class ContractOrderCreateServiceImpl
implements ContractOrderCreateService {
    private static final Logger log = LoggerFactory.getLogger(ContractOrderCreateServiceImpl.class);
    @Autowired
    private ContractOrderInfoMapper contractOrderInfoMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractTermsMapper contractTermsMapper;
    @Autowired
    private ContractTaskHisMapper contractTaskHisMapper;

    @PostMapping(value={"contractOrderCreate"})
    public ContractOrderCreateRspBO contractOrderCreate(@RequestBody ContractOrderCreateReqBO contractOrderCreateReqBO) {
        ContractOrderCreateRspBO contractOrderCreateRspBO = new ContractOrderCreateRspBO();
        if (contractOrderCreateReqBO.getContractId() == null && contractOrderCreateReqBO.getSaveOrSubmit() == Constant.CONTRACT_SAVE) {
            ContractOrderInfoPO contractOrderInfoPO = new ContractOrderInfoPO();
            contractOrderInfoPO.setSaleOrderId(contractOrderCreateReqBO.getSaleOrderId());
            contractOrderInfoPO.setValidStatus(Constant.VALID_STATUS_YES);
            contractOrderInfoPO.setContractType(contractOrderCreateReqBO.getContractType());
            int check = this.contractOrderInfoMapper.getCheckBy(contractOrderInfoPO);
            if (check > 1) {
                contractOrderCreateRspBO.setCode("8888");
                contractOrderCreateRspBO.setMessage("\u9500\u552e\u5408\u540c\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u521b\u5efa");
                return contractOrderCreateRspBO;
            }
        }
        String contractCode = contractOrderCreateReqBO.getContractCodeRule() + "-" + contractOrderCreateReqBO.getContractCodeVar();
        Long contrantId = Sequence.getInstance().nextId();
        if (contractOrderCreateReqBO.getSaveOrSubmit() == Constant.CONTRACT_SAVE) {
            ContractOrderInfoPO contractOrderInfoPO = new ContractOrderInfoPO();
            BeanUtils.copyProperties((Object)contractOrderCreateReqBO, (Object)contractOrderInfoPO);
            contractOrderInfoPO.setContractCode(contractCode);
            contractOrderInfoPO.setContractStatus(Constant.CONTRACT_DRAFT_STATUS);
            contractOrderInfoPO.setValidStatus(Constant.VALID_STATUS_YES);
            contractOrderInfoPO.setCreateTime(new Date());
            log.error("\u5408\u540cId" + contrantId);
            contractOrderInfoPO.setContractId(contrantId);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (!StringUtils.isBlank((String)contractOrderCreateReqBO.getSignDate())) {
                Date parse = null;
                try {
                    parse = sdf.parse(contractOrderCreateReqBO.getSignDate());
                }
                catch (ParseException e) {
                    log.error("\u7b7e\u8ba2\u65f6\u95f4\u683c\u5f0f\u9519\u8bef", (Throwable)e);
                }
                contractOrderInfoPO.setSignDate(parse);
            }
            ContractTermsPO contractTermsPO = this.contractTermsMapper.selectByPrimaryKey(contractOrderCreateReqBO.getContractTermId());
            contractOrderInfoPO.setContractTermText(contractTermsPO.getTermText());
            this.contractOrderInfoMapper.insertSelective(contractOrderInfoPO);
            for (ContractAccessoryReqBO contractAccessoryReqBO : contractOrderCreateReqBO.getContractAccessoryList()) {
                ContractAccessoryPO contractAccessoryPO = new ContractAccessoryPO();
                contractAccessoryPO.setAcceessoryName(contractAccessoryReqBO.getAcceessoryName());
                contractAccessoryPO.setContractId(contrantId);
                contractAccessoryPO.setContractType(contractOrderCreateReqBO.getContractType());
                contractAccessoryPO.setCreateTime(new Date());
                contractAccessoryPO.setValidStatus(Constant.VALID_STATUS_YES);
                this.contractAccessoryMapper.insertSelective(contractAccessoryPO);
            }
            ContractTaskHisPO contractTaskHisPO = new ContractTaskHisPO();
            contractTaskHisPO.setContractId(contractOrderCreateReqBO.getContractId());
            contractTaskHisPO.setOperName(contractOrderCreateReqBO.getCreateUserName());
            contractTaskHisPO.setOperId(contractOrderCreateReqBO.getCreateUserId());
            contractTaskHisPO.setArrivalTime(new Date());
            contractTaskHisPO.setOperateTime(new Date());
            contractTaskHisPO.setBusiStep(Constant.CONTRACT_STEP_CREATE);
            contractTaskHisPO.setBusiStepName("\u521b\u5efa\u8349\u7a3f");
            contractTaskHisPO.setRemark(contractOrderCreateReqBO.getRemark());
            contractTaskHisPO.setOperateBehavior("\u521b\u5efa\u8349\u7a3f");
            contractTaskHisPO.setRoleName("\u5408\u540c\u7ba1\u7406");
            this.contractTaskHisMapper.insertSelective(contractTaskHisPO);
        } else if (contractOrderCreateReqBO.getSaveOrSubmit() == Constant.CONTRACT_SUBMIT) {
            // empty if block
        }
        contractOrderCreateRspBO.setContractId(contrantId);
        contractOrderCreateRspBO.setContractCode(contractCode);
        contractOrderCreateRspBO.setCode("0000");
        contractOrderCreateRspBO.setMessage("0000");
        return contractOrderCreateRspBO;
    }
}

