/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.agreement.busi.impl;

import com.tydic.contract.api.agreement.bo.ContractAgreementUpdateReqBO;
import com.tydic.contract.api.agreement.bo.ContractAgreementUpdateRspBO;
import com.tydic.contract.api.agreement.service.ContractAgreementUpdateService;
import com.tydic.contract.api.order.bo.ContractAccessoryReqBO;
import com.tydic.contract.constant.Constant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.ContractAccessoryPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractTaskHisPO;
import com.tydic.contract.po.ContractTermsPO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.agreement.service.ContractAgreementUpdateService"})
public class ContractAgreementUpdateServiceImpl
implements ContractAgreementUpdateService {
    private static final Logger log = LoggerFactory.getLogger(ContractAgreementUpdateServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractTermsMapper contractTermsMapper;

    @PostMapping(value={"contractAgreementUpdate"})
    public ContractAgreementUpdateRspBO contractAgreementUpdate(@RequestBody ContractAgreementUpdateReqBO contractAgreementUpdateReqBO) {
        ContractAgreementUpdateRspBO contractAgreementUpdateRspBO = new ContractAgreementUpdateRspBO();
        if (contractAgreementUpdateReqBO.getContractId() == null) {
            contractAgreementUpdateRspBO.setCode("8888");
            contractAgreementUpdateRspBO.setMessage("\u5408\u540c\u4fee\u6539\uff0ccontractId\u4e0d\u80fd\u4e3a\u7a7a");
            return contractAgreementUpdateRspBO;
        }
        ContractInfoPO contractInfoPO = new ContractInfoPO();
        if (contractAgreementUpdateReqBO.getSaveOrSubmit() == 2 && (contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(contractAgreementUpdateReqBO.getContractId())).getContractDocUrl() == null) {
            contractAgreementUpdateRspBO.setCode("8888");
            contractAgreementUpdateRspBO.setMessage("\u8bf7\u5148\u751f\u6210\u5408\u540c\u6587\u672c\uff0c\u5426\u5219\u65e0\u6cd5\u63d0\u4ea4\u5408\u540c");
            return contractAgreementUpdateRspBO;
        }
        ContractInfoPO contractInfoPO1 = null;
        if (contractAgreementUpdateReqBO.getSaveOrSubmit() == 1) {
            contractInfoPO1 = this.updateContract(contractAgreementUpdateReqBO);
        } else if (contractAgreementUpdateReqBO.getSaveOrSubmit() == 2) {
            contractInfoPO1 = this.updateContract(contractAgreementUpdateReqBO);
            ContractTaskHisPO contractTaskHisPO = new ContractTaskHisPO();
            contractTaskHisPO.setContractId(contractAgreementUpdateReqBO.getContractId());
            contractTaskHisPO.setOperName(contractAgreementUpdateReqBO.getCreateUserName());
            contractTaskHisPO.setOperId(contractAgreementUpdateReqBO.getCreateUserId());
            contractTaskHisPO.setArrivalTime(new Date());
            contractTaskHisPO.setOperateTime(new Date());
            contractTaskHisPO.setBusiStep(Constant.CONTRACT_STEP_SUBMIT);
            contractTaskHisPO.setBusiStepName("\u521b\u5efa\u5408\u540c");
            contractTaskHisPO.setRemark(contractAgreementUpdateReqBO.getRemark());
            contractTaskHisPO.setOperateBehavior("\u63d0\u4ea4\u5408\u540c");
            contractTaskHisPO.setRoleName("\u5408\u540c\u7ba1\u7406");
        }
        contractAgreementUpdateRspBO.setContractId(contractAgreementUpdateReqBO.getContractId());
        contractAgreementUpdateRspBO.setContractCode(contractInfoPO.getContractCode());
        contractAgreementUpdateRspBO.setCode("0000");
        contractAgreementUpdateRspBO.setMessage("\u6210\u529f");
        return contractAgreementUpdateRspBO;
    }

    public ContractInfoPO updateContract(ContractAgreementUpdateReqBO contractAgreementUpdateReqBO) {
        ContractInfoPO contractInfoPO = new ContractInfoPO();
        ContractInfoPO contractInfoPO1 = new ContractInfoPO();
        contractInfoPO1.setContactName(contractAgreementUpdateReqBO.getContactName());
        contractInfoPO1.setContractTemplateId(contractAgreementUpdateReqBO.getContractTemplateId());
        contractInfoPO1.setContractTermId(contractAgreementUpdateReqBO.getContractTermId());
        contractInfoPO1.setPayType(contractAgreementUpdateReqBO.getPayType());
        contractInfoPO1.setRate(contractAgreementUpdateReqBO.getRate());
        contractInfoPO1.setContractName(contractAgreementUpdateReqBO.getContractName());
        contractInfoPO1.setContactPhone(contractAgreementUpdateReqBO.getContactPhone());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (!StringUtils.isBlank((String)contractAgreementUpdateReqBO.getSignDate())) {
            Date parse = null;
            try {
                parse = sdf.parse(contractAgreementUpdateReqBO.getSignDate());
            }
            catch (ParseException e) {
                log.error("\u7b7e\u8ba2\u65f6\u95f4\u683c\u5f0f\u9519\u8bef", (Throwable)e);
            }
            contractInfoPO1.setSignDate(parse);
        }
        contractInfoPO1.setSignAddr(contractAgreementUpdateReqBO.getSignAddr());
        contractInfoPO1.setGuaranteePeriod(contractAgreementUpdateReqBO.getGuaranteePeriod());
        contractInfoPO1.setQualityReq(contractAgreementUpdateReqBO.getQualityReq());
        contractInfoPO1.setContractId(contractAgreementUpdateReqBO.getContractId());
        contractInfoPO1.setUpdateTime(new Date());
        contractInfoPO1.setRemark(contractAgreementUpdateReqBO.getRemark());
        ContractTermsPO contractTermsPO = this.contractTermsMapper.selectByPrimaryKey(contractAgreementUpdateReqBO.getContractTermId());
        contractInfoPO.setContractTermText(contractTermsPO.getTermText());
        this.contractInfoMapper.updateByPrimaryKeySelective(contractInfoPO1);
        this.contractAccessoryMapper.deleteByPrimaryKey(contractAgreementUpdateReqBO.getContractId());
        for (ContractAccessoryReqBO contractAccessoryReqBO : contractAgreementUpdateReqBO.getContractAccessoryList()) {
            ContractAccessoryPO contractAccessoryPO = new ContractAccessoryPO();
            contractAccessoryPO.setAcceessoryName(contractAccessoryReqBO.getAcceessoryName());
            contractAccessoryPO.setContractId(contractAgreementUpdateReqBO.getContractId());
            contractAccessoryPO.setContractType(contractAgreementUpdateReqBO.getContractType());
            contractAccessoryPO.setCreateTime(new Date());
            contractAccessoryPO.setValidStatus(Constant.VALID_STATUS_YES);
            this.contractAccessoryMapper.insertSelective(contractAccessoryPO);
        }
        return contractInfoPO;
    }
}

