/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.order.busi.impl;

import com.tydic.contract.api.order.bo.ContractAccessoryReqBO;
import com.tydic.contract.api.order.bo.ContractOrderUpdateReqBO;
import com.tydic.contract.api.order.bo.ContractOrderUpdateRspBO;
import com.tydic.contract.api.order.service.ContractOrderUpdateService;
import com.tydic.contract.constant.Constant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.ContractAccessoryPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractTaskHisPO;
import com.tydic.contract.po.ContractTermsPO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.order.service.ContractOrderUpdateService"})
public class ContractOrderUpdateServiceImpl
implements ContractOrderUpdateService {
    private static final Logger log = LoggerFactory.getLogger(ContractOrderUpdateServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractTermsMapper contractTermsMapper;

    @PostMapping(value={"contractOrderUpdate"})
    public ContractOrderUpdateRspBO contractOrderUpdate(@RequestBody ContractOrderUpdateReqBO contractOrderUpdateReqBO) {
        ContractOrderUpdateRspBO contractOrderUpdateRspBO = new ContractOrderUpdateRspBO();
        if (contractOrderUpdateReqBO.getContractId() == null) {
            contractOrderUpdateRspBO.setCode("8888");
            contractOrderUpdateRspBO.setMessage("\u5408\u540c\u4fee\u6539\uff0ccontractId\u4e0d\u80fd\u4e3a\u7a7a");
            return contractOrderUpdateRspBO;
        }
        ContractInfoPO contractInfoPO = new ContractInfoPO();
        if (contractOrderUpdateReqBO.getSaveOrSubmit() == 2 && (contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(contractOrderUpdateReqBO.getContractId())).getContractDocUrl() == null) {
            contractOrderUpdateRspBO.setCode("8888");
            contractOrderUpdateRspBO.setMessage("\u8bf7\u5148\u751f\u6210\u5408\u540c\u6587\u672c\uff0c\u5426\u5219\u65e0\u6cd5\u63d0\u4ea4\u5408\u540c");
            return contractOrderUpdateRspBO;
        }
        ContractInfoPO contractInfoPO1 = null;
        if (contractOrderUpdateReqBO.getSaveOrSubmit() == 1) {
            contractInfoPO1 = this.updateContract(contractOrderUpdateReqBO);
        } else if (contractOrderUpdateReqBO.getSaveOrSubmit() == 2) {
            contractInfoPO1 = this.updateContract(contractOrderUpdateReqBO);
            ContractTaskHisPO contractTaskHisPO = new ContractTaskHisPO();
            contractTaskHisPO.setContractId(contractOrderUpdateReqBO.getContractId());
            contractTaskHisPO.setOperName(contractOrderUpdateReqBO.getCreateUserName());
            contractTaskHisPO.setOperId(contractOrderUpdateReqBO.getCreateUserId());
            contractTaskHisPO.setArrivalTime(new Date());
            contractTaskHisPO.setOperateTime(new Date());
            contractTaskHisPO.setBusiStep(Constant.CONTRACT_STEP_SUBMIT);
            contractTaskHisPO.setBusiStepName("\u521b\u5efa\u5408\u540c");
            contractTaskHisPO.setRemark(contractOrderUpdateReqBO.getRemark());
            contractTaskHisPO.setOperateBehavior("\u63d0\u4ea4\u5408\u540c");
            contractTaskHisPO.setRoleName("\u5408\u540c\u7ba1\u7406");
        }
        contractOrderUpdateRspBO.setContractId(contractOrderUpdateReqBO.getContractId());
        contractOrderUpdateRspBO.setContractCode(contractInfoPO.getContractCode());
        contractOrderUpdateRspBO.setCode("0000");
        contractOrderUpdateRspBO.setMessage("\u6210\u529f");
        return contractOrderUpdateRspBO;
    }

    public ContractInfoPO updateContract(ContractOrderUpdateReqBO contractOrderUpdateReqBO) {
        Date parse;
        ContractInfoPO contractInfoPO = new ContractInfoPO();
        ContractInfoPO contractInfoPO1 = new ContractInfoPO();
        contractInfoPO1.setContactName(contractOrderUpdateReqBO.getContactName());
        contractInfoPO1.setContractTemplateId(contractOrderUpdateReqBO.getContractTemplateId());
        contractInfoPO1.setContractTermId(contractOrderUpdateReqBO.getContractTermId());
        contractInfoPO1.setPayType(contractOrderUpdateReqBO.getPayType());
        contractInfoPO1.setRate(contractOrderUpdateReqBO.getRate());
        contractInfoPO1.setContractName(contractOrderUpdateReqBO.getContractName());
        contractInfoPO1.setContactPhone(contractOrderUpdateReqBO.getContactPhone());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (!StringUtils.isBlank((String)contractOrderUpdateReqBO.getSignDate())) {
            parse = null;
            try {
                parse = sdf.parse(contractOrderUpdateReqBO.getSignDate());
            }
            catch (ParseException e) {
                log.error("\u7b7e\u8ba2\u65f6\u95f4\u683c\u5f0f\u9519\u8bef", (Throwable)e);
            }
            contractInfoPO1.setSignDate(parse);
        }
        contractInfoPO1.setSignAddr(contractOrderUpdateReqBO.getSignAddr());
        contractInfoPO1.setGuaranteePeriod(contractOrderUpdateReqBO.getGuaranteePeriod());
        contractInfoPO1.setQualityReq(contractOrderUpdateReqBO.getQualityReq());
        if (contractOrderUpdateReqBO.getSaveOrSubmit() == 2) {
            contractInfoPO1.setSubmitTime(new Date());
        }
        if (!StringUtils.isBlank((String)contractOrderUpdateReqBO.getNeedArriveTime())) {
            parse = null;
            try {
                parse = sdf.parse(contractOrderUpdateReqBO.getNeedArriveTime());
            }
            catch (ParseException e) {
                log.error("\u7b7e\u8ba2\u65f6\u95f4\u683c\u5f0f\u9519\u8bef", (Throwable)e);
            }
            contractInfoPO1.setNeedArriveTime(parse);
        }
        contractInfoPO1.setContractId(contractOrderUpdateReqBO.getContractId());
        contractInfoPO1.setUpdateTime(new Date());
        contractInfoPO1.setRemark(contractOrderUpdateReqBO.getRemark());
        ContractTermsPO contractTermsPO = this.contractTermsMapper.selectByPrimaryKey(contractOrderUpdateReqBO.getContractTermId());
        contractInfoPO.setContractTermText(contractTermsPO.getTermText());
        this.contractInfoMapper.updateByPrimaryKeySelective(contractInfoPO1);
        this.contractAccessoryMapper.deleteByPrimaryKey(contractOrderUpdateReqBO.getContractId());
        for (ContractAccessoryReqBO contractAccessoryReqBO : contractOrderUpdateReqBO.getContractAccessoryList()) {
            ContractAccessoryPO contractAccessoryPO = new ContractAccessoryPO();
            contractAccessoryPO.setAcceessoryName(contractAccessoryReqBO.getAcceessoryName());
            contractAccessoryPO.setContractId(contractOrderUpdateReqBO.getContractId());
            contractAccessoryPO.setContractType(contractOrderUpdateReqBO.getContractType());
            contractAccessoryPO.setCreateTime(new Date());
            contractAccessoryPO.setValidStatus(Constant.VALID_STATUS_YES);
            this.contractAccessoryMapper.insertSelective(contractAccessoryPO);
        }
        return contractInfoPO;
    }
}

