/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.order.busi.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.order.bo.QryContractOrderInfoReqBO;
import com.tydic.contract.api.order.bo.QryContractOrderInfoRspBO;
import com.tydic.contract.api.order.service.QryContractOrderInfoService;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.order.service.QryContractOrderInfoService"})
public class QryContractOrderInfoServiceImpl
implements QryContractOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(QryContractOrderInfoServiceImpl.class);
    @Resource
    private ContractInfoMapper contractInfoMapper;

    @PostMapping(value={"selectListByCondition"})
    public RspPage<QryContractOrderInfoRspBO> selectListByCondition(@RequestBody QryContractOrderInfoReqBO reqBO) {
        RspPage rspPage = new RspPage();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        ArrayList<QryContractOrderInfoRspBO> contractOrderList = new ArrayList<QryContractOrderInfoRspBO>();
        try {
            List<ContractInfoPO> contractOrderInfos;
            Map<String, Object> condition = this.getCondition(reqBO);
            if (reqBO.getContractType().equals(3)) {
                condition.put("purchaserId", null);
            }
            if (CollectionUtils.isEmpty(contractOrderInfos = this.contractInfoMapper.selectListByCondition(condition, (Page<ContractInfoPO>)page))) {
                rspPage.setCode("0000");
                rspPage.setMessage("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return rspPage;
            }
            block23: for (ContractInfoPO contractInfoPO : contractOrderInfos) {
                QryContractOrderInfoRspBO bo = new QryContractOrderInfoRspBO();
                BeanUtils.copyProperties((Object)contractInfoPO, (Object)bo);
                contractOrderList.add(bo);
                if (bo.getPayType() != null) {
                    switch (bo.getPayType()) {
                        case 1: {
                            bo.setPayTypeStr("\u9884\u4ed8\u6b3e");
                            break;
                        }
                        case 2: {
                            bo.setPayTypeStr("\u8d27\u5230\u4ed8\u6b3e");
                        }
                    }
                }
                if (bo.getPayRatio() != null) {
                    switch (bo.getPayRatio()) {
                        case 1: {
                            bo.setPayRatioStr("\u7535\u6c47\u6216\u627f\u5151\u6c47\u7968");
                            break;
                        }
                        case 2: {
                            bo.setPayRatioStr("\u9884\u4ed8\u6b3e10%,\u6295\u6599\u6b3e10%,\u8fdb\u5ea6\u6b3e10%,\u5230\u8d27\u9a8c\u6536\u5408\u683c\u540e\u4ed8\u6b3e70%");
                        }
                    }
                }
                if (bo.getContractStatus() != null) {
                    switch (bo.getContractStatus()) {
                        case 1: {
                            bo.setContractStatusStr("\u8349\u7a3f");
                            break;
                        }
                        case 2: {
                            bo.setContractStatusStr("\u5ba1\u6279\u4e2d");
                            break;
                        }
                        case 4: {
                            bo.setContractStatusStr("\u5ba1\u6279\u901a\u8fc7");
                            break;
                        }
                        case 5: {
                            bo.setContractStatusStr("\u9a73\u56de");
                            break;
                        }
                        case 6: {
                            bo.setContractStatusStr("\u53d8\u66f4\u7533\u8bf7\u4e2d");
                            break;
                        }
                        default: {
                            bo.setContractStatusStr("\u5176\u4ed6");
                        }
                    }
                }
                if (bo.getContractType() == null) continue;
                switch (bo.getContractType()) {
                    case 1: {
                        bo.setContractTypeStr("\u91c7\u8d2d\u8ba2\u5355\u5408\u540c");
                        continue block23;
                    }
                    case 2: {
                        bo.setContractTypeStr("\u9500\u552e\u8ba2\u5355\u5408\u540c");
                        continue block23;
                    }
                    case 3: {
                        bo.setContractTypeStr("\u6846\u67b6\u534f\u8bae\u5408\u540c");
                        continue block23;
                    }
                    case 4: {
                        bo.setContractTypeStr("\u5165\u9a7b\u5408\u540c");
                        continue block23;
                    }
                }
                bo.setContractStatusStr("\u5176\u4ed6");
            }
            rspPage.setRows(contractOrderList);
            rspPage.setPageNo(page.getPageNo());
            rspPage.setRecordsTotal(page.getTotalCount());
            rspPage.setTotal(page.getTotalPages());
            rspPage.setCode("0000");
            rspPage.setMessage("\u5408\u540c\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspPage;
    }

    private Map<String, Object> getCondition(QryContractOrderInfoReqBO reqBO) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("contractCode", StringUtils.trimToNull((String)reqBO.getContractCode()));
        condition.put("contractName", StringUtils.trimToNull((String)reqBO.getContractName()));
        condition.put("createUserName", StringUtils.trimToNull((String)reqBO.getCreateUserName()));
        condition.put("purchaseOrderCode", StringUtils.trimToNull((String)reqBO.getPurchaseOrderCode()));
        condition.put("beginTime", reqBO.getBeginTime());
        condition.put("endTime", reqBO.getEndTime());
        condition.put("contractAmountMaxLong", reqBO.getContractAmountMaxLong());
        condition.put("contractAmountMinLong", reqBO.getContractAmountMinLong());
        condition.put("supplierId", reqBO.getSupplierId());
        condition.put("contractStatusList", reqBO.getContractStatusList());
        condition.put("validStatus", reqBO.getValidStatus());
        condition.put("contractType", reqBO.getContractType());
        condition.put("orgIdList", reqBO.getOrgIdList());
        condition.put("plaAgreementCode", reqBO.getPlaAgreementCode());
        condition.put("contractStatus", reqBO.getContractStatus());
        condition.put("enterPurchaserName", reqBO.getEnterPurchaserName());
        condition.put("signApplicationCode", reqBO.getSignApplicationCode());
        condition.put("supplierType", reqBO.getSupplierType());
        return condition;
    }
}

