/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.order.busi.impl;

import com.tydic.contract.api.order.bo.SequenceContractReq;
import com.tydic.contract.api.order.service.SequenceContractService;
import com.tydic.contract.dao.SequenceMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.order.service.SequenceContractService"})
public class SequenceContractServiceImpl
implements SequenceContractService {
    private static final String STR_FORMAT_SIX = "000000";
    private static final String STR_FORMAT_THREE = "000";
    @Autowired
    private SequenceMapper sequenceMapper;

    @PostMapping(value={"getSequenceId"})
    public String getSequenceId(@RequestBody SequenceContractReq sequenceContractReq) {
        Long seqId = this.sequenceMapper.selectValue(sequenceContractReq.getSeqName());
        this.sequenceMapper.updateValue(sequenceContractReq.getSeqName());
        String seqNum = null;
        if (1 == sequenceContractReq.getType()) {
            seqNum = SequenceContractServiceImpl.leftFormatSix(seqId);
        } else if (2 == sequenceContractReq.getType()) {
            seqNum = SequenceContractServiceImpl.leftFormatThree(seqId);
        }
        return seqNum;
    }

    public static String leftFormatSix(Long num) {
        String zeroStr = STR_FORMAT_SIX;
        String numStr = String.valueOf(num);
        zeroStr = zeroStr.substring(0, zeroStr.length() - numStr.length());
        return zeroStr + numStr;
    }

    public static String leftFormatThree(Long num) {
        String zeroStr = STR_FORMAT_THREE;
        String numStr = String.valueOf(num);
        zeroStr = zeroStr.substring(0, zeroStr.length() - numStr.length());
        return zeroStr + numStr;
    }
}

