/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.contract.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.contract.ability.ContractQryListAbilityService;
import com.tydic.contract.ability.bo.ContractQryListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryListAbilityRspBO;
import com.tydic.dyc.contract.api.DycContractQueryOrderContractApprovalListService;
import com.tydic.dyc.contract.bo.DycContractQueryOrderContractApprovalListReqBO;
import com.tydic.dyc.contract.bo.DycContractQueryOrderContractApprovalListRspBO;
import com.tydic.dyc.contract.constant.ContractConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycContractQueryOrderContractApprovalListServiceImpl
implements DycContractQueryOrderContractApprovalListService {
    @Autowired
    private ContractQryListAbilityService contractQryListAbilityService;

    public DycContractQueryOrderContractApprovalListRspBO queryOrderContractApprovalList(DycContractQueryOrderContractApprovalListReqBO reqBO) {
        this.validate(reqBO);
        ContractQryListAbilityReqBO centerReqBO = (ContractQryListAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ContractQryListAbilityReqBO.class);
        if (reqBO.getContractAmountMoneyMax() != null) {
            try {
                centerReqBO.setContractAmountMax(MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getContractAmountMoneyMax()));
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u5408\u540c\u91d1\u989d\u8f6c\u6362\u5931\u8d25\uff01\u91d1\u989d\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01");
            }
        }
        if (reqBO.getContractAmountMoneyMin() != null) {
            try {
                centerReqBO.setContractAmountMin(MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getContractAmountMoneyMin()));
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u5408\u540c\u91d1\u989d\u8f6c\u6362\u5931\u8d25\uff01\u91d1\u989d\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01");
            }
        }
        centerReqBO.setContractType(ContractConstant.ContractType.ORDER_CONTRACT);
        if (reqBO.getPageNo() != null && reqBO.getPageNo() > 0) {
            centerReqBO.setPageNo(reqBO.getPageNo());
        }
        if (reqBO.getPageSize() != null && reqBO.getPageSize() > 0) {
            centerReqBO.setPageSize(reqBO.getPageSize());
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getContractApprovalStatus())) {
            centerReqBO.setContractApprovalStatus(this.transTabIdToContractApprovalStatus(reqBO.getTabId()));
        }
        if ("0".equals(reqBO.getIsprofess())) {
            centerReqBO.setSupplierType(Integer.valueOf(2));
        } else {
            centerReqBO.setSupplierId(reqBO.getCompanyId());
        }
        ContractQryListAbilityRspBO centerRspBO = this.contractQryListAbilityService.qryContractList(centerReqBO);
        if ("0000".equals(centerRspBO.getRespCode())) {
            return (DycContractQueryOrderContractApprovalListRspBO)JSON.parseObject((String)JSON.toJSONString((Object)centerRspBO), DycContractQueryOrderContractApprovalListRspBO.class);
        }
        throw new ZTBusinessException(centerRspBO.getRespDesc());
    }

    private List<Integer> transTabIdToContractApprovalStatus(Integer tabId) {
        ArrayList<Integer> contractApprovalStatusList = new ArrayList<Integer>();
        if (tabId.equals(ContractConstant.ContractApprovalTabId.TAB_ID_NO_APPROVAL)) {
            contractApprovalStatusList.add(ContractConstant.ContractApprovalStatus.WAIT_APPROVAL);
        } else if (tabId.equals(ContractConstant.ContractApprovalTabId.TAB_ID_APPROVED)) {
            contractApprovalStatusList.add(ContractConstant.ContractApprovalStatus.PASS_APPROVAL);
            contractApprovalStatusList.add(ContractConstant.ContractApprovalStatus.REJECT_APPROVAL);
        } else if (tabId.equals(ContractConstant.ContractApprovalTabId.TAB_ID_ALL)) {
            contractApprovalStatusList.add(ContractConstant.ContractApprovalStatus.WAIT_APPROVAL);
            contractApprovalStatusList.add(ContractConstant.ContractApprovalStatus.PASS_APPROVAL);
            contractApprovalStatusList.add(ContractConstant.ContractApprovalStatus.REJECT_APPROVAL);
        } else {
            throw new ZTBusinessException("\u8f93\u5165\u7684\u9875\u7b7eid\u9519\u8bef");
        }
        return contractApprovalStatusList;
    }

    private void validate(DycContractQueryOrderContractApprovalListReqBO reqBO) {
        if (reqBO.getTabId() == null) {
            throw new ZTBusinessException("\u5165\u9a7b\u5408\u540c\u5217\u8868\u67e5\u8be2-tabId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

