/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.cfc.ability.api.CfcUniteParamQryListDetailAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListDetailAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListDetailAbilityRspBO;
import com.tydic.dyc.fsc.api.DaYaoFscCheckTimeLimitAbilityService;
import com.tydic.dyc.fsc.bo.DaYaoFscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.dyc.fsc.bo.DaYaoFscCheckTimeLimitAbilityReqBo;
import com.tydic.dyc.fsc.bo.DaYaoFscCheckTimeLimitAbilityRspBo;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DaYaoFscCheckTimeLimitAbilityServiceImpl
implements DaYaoFscCheckTimeLimitAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DaYaoFscCheckTimeLimitAbilityServiceImpl.class);
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;
    @Autowired
    private CfcUniteParamQryListDetailAbilityService cfcUniteParamQryListDetailAbilityService;

    public DaYaoFscCheckTimeLimitAbilityRspBo dealCheckTimeLimit(DaYaoFscCheckTimeLimitAbilityReqBo abilityReqBo) {
        UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
        uocInspectionDetailsListPageQueryReqBO.setInspectionVoucherIdList(abilityReqBo.getInspectionVoucherIdList());
        uocInspectionDetailsListPageQueryReqBO.setTabId(Integer.valueOf(80013));
        uocInspectionDetailsListPageQueryReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        uocInspectionDetailsListPageQueryReqBO.setPageSize(100000);
        uocInspectionDetailsListPageQueryReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
        uocInspectionDetailsListPageQueryReqBO.setPurchaseType(abilityReqBo.getPurchaseType());
        uocInspectionDetailsListPageQueryReqBO.setIsAfterSales(Boolean.valueOf(false));
        UocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBO);
        if (!"0000".equals(inspectionDetailsList.getRespCode())) {
            throw new ZTBusinessException(inspectionDetailsList.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)inspectionDetailsList.getRows())) {
            HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap<Long, FscOrderInfoBO>();
            for (UocInspectionDetailsListBO row : inspectionDetailsList.getRows()) {
                FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)row), FscOrderInfoBO.class);
                fscOrderInfoBO.setOrderNo(row.getSaleVoucherNo());
                fscOrderInfoBO.setAcceptOrderId(Long.valueOf(row.getInspectionVoucherId()));
                fscOrderInfoBoMap.put(fscOrderInfoBO.getAcceptOrderId(), fscOrderInfoBO);
            }
            this.verifyIsExtPersonal(fscOrderInfoBoMap);
        }
        DaYaoFscCheckTimeLimitAbilityRspBo daYaoFscCheckTimeLimitAbilityRspBo = new DaYaoFscCheckTimeLimitAbilityRspBo();
        daYaoFscCheckTimeLimitAbilityRspBo.setCode("0000");
        daYaoFscCheckTimeLimitAbilityRspBo.setMessage("\u6210\u529f");
        return daYaoFscCheckTimeLimitAbilityRspBo;
    }

    private void verifyIsExtPersonal(Map<Long, FscOrderInfoBO> fscOrderInfoBoMap) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DaYaoFscCfcUniteParamQryListDetailExternalRspBO configuration = this.getConfiguration("ext_person_billing_time");
        String billingTime = configuration.getBillingTime();
        FscOrderInfoBO fscOrderInfoBO = fscOrderInfoBoMap.values().stream().min(Comparator.comparing(FscOrderInfoBO::getInspectionTime)).get();
        GregorianCalendar cal = new GregorianCalendar();
        if (fscOrderInfoBO.getInspectionTime() != null) {
            cal.setTime(fscOrderInfoBO.getInspectionTime());
        }
        ((Calendar)cal).add(5, Integer.parseInt(billingTime));
        Date latestBillDate = cal.getTime();
        String latestBillDateStr = simpleDateFormat.format(latestBillDate);
        if (log.isDebugEnabled()) {
            log.debug("\u5916\u90e8\u4e2a\u4eba\u53ef\u5f00\u5177\u53d1\u7968\u65f6\u9650\uff0c\u4ece\u9a8c\u6536\u65e5\u8d77\uff1a{} \u5929\u5185", (Object)billingTime);
            log.debug("\u8ba2\u5355\u6700\u65e9\u9a8c\u6536\u65f6\u95f4\uff1a{} ", (Object)fscOrderInfoBO.getInspectionTime());
            log.debug("\u8ba2\u5355\u5f00\u5177\u53d1\u7968\u65f6\u9650\uff1a{} ", (Object)latestBillDateStr);
        }
        if (latestBillDate.getTime() < System.currentTimeMillis()) {
            throw new ZTBusinessException(StrUtil.format((CharSequence)"\u60a8\u9009\u62e9\u7684\u6570\u636e[{}]\u5df2\u8d85\u8fc7\u53d1\u8d77\u7ed3\u7b97\u5355\u65f6\u9650{}\u5929\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406", (Object[])new Object[]{fscOrderInfoBO.getOrderNo(), billingTime}));
        }
    }

    private DaYaoFscCfcUniteParamQryListDetailExternalRspBO getConfiguration(String cfcParamCodes) {
        CfcUniteParamQryListDetailAbilityReqBO fscCfcUniteParamQryListDetailExternalReqBO = new CfcUniteParamQryListDetailAbilityReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode(cfcParamCodes);
        CfcUniteParamQryListDetailAbilityRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.cfcUniteParamQryListDetailAbilityService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        if (null == fscCfcUniteParamQryListDetailExternalRspBO.getJsonObject() || fscCfcUniteParamQryListDetailExternalRspBO.getJsonObject().isEmpty()) {
            throw new FscBusinessException("194314", "\u914d\u7f6e\u4e2d\u5fc3\u8fd4\u56de\u4e3a\u7a7a");
        }
        return (DaYaoFscCfcUniteParamQryListDetailExternalRspBO)JSON.parseObject((String)fscCfcUniteParamQryListDetailExternalRspBO.getJsonObject().toJSONString(), DaYaoFscCfcUniteParamQryListDetailExternalRspBO.class);
    }
}

