/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.fsc.api.DycFscBillOrderBundlCheckService;
import com.tydic.dyc.fsc.bo.DycFscBillOrderBundlCheckReqBO;
import com.tydic.dyc.fsc.bo.DycFscBillOrderBundlCheckRspBO;
import com.tydic.dyc.fsc.bo.DycrelOrderBO;
import com.tydic.dyc.fsc.bo.PayAccountDayRuleBO;
import com.tydic.dyc.fsc.bo.PayNodeRuleBO;
import com.tydic.dyc.fsc.bo.PayRuleBO;
import com.tydic.dyc.fsc.bo.PayTypeBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycFscBillOrderBundlCheckServiceImpl
implements DycFscBillOrderBundlCheckService {
    private static final Logger log = LoggerFactory.getLogger(DycFscBillOrderBundlCheckServiceImpl.class);
    private static final Integer BUND = 1;
    private static final Integer NOT_BUND = 0;
    private static final Integer TAB_ID = 80013;
    private static final Map<Integer, String> PAY_RULE = new HashMap<Integer, String>(4);
    private static final Map<Integer, String> PAY_ACCOUNT_RULE = new HashMap<Integer, String>(4);
    private static final Map<Integer, String> PAY_NODE_RULE = new HashMap<Integer, String>(4);
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;

    public DycFscBillOrderBundlCheckRspBO dealBundlCheck(DycFscBillOrderBundlCheckReqBO reqBO) {
        if (reqBO.getRelOrderList().size() == 1) {
            DycFscBillOrderBundlCheckRspBO dycFscBillOrderBundlCheckRspBO = new DycFscBillOrderBundlCheckRspBO();
            dycFscBillOrderBundlCheckRspBO.setBundlFlag(BUND);
            return dycFscBillOrderBundlCheckRspBO;
        }
        this.val(reqBO);
        List relOrderList = reqBO.getRelOrderList();
        List acceptIdList = relOrderList.stream().map(DycrelOrderBO::getAcceptOrderId).collect(Collectors.toList());
        UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBo = new UocInspectionDetailsListPageQueryReqBO();
        uocInspectionDetailsListPageQueryReqBo.setInspectionVoucherIdList(acceptIdList);
        uocInspectionDetailsListPageQueryReqBo.setIsAfterSales(Boolean.valueOf(false));
        uocInspectionDetailsListPageQueryReqBo.setTabId(TAB_ID);
        uocInspectionDetailsListPageQueryReqBo.setPageSize(-1);
        uocInspectionDetailsListPageQueryReqBo.setPurchaseType(reqBO.getPurchaseType());
        log.info("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocInspectionDetailsListPageQueryReqBo));
        UocInspectionDetailsListPageQueryRspBO inspectionDetailsList = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBo);
        log.info("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)inspectionDetailsList));
        if (!"0000".equals(inspectionDetailsList.getRespCode())) {
            throw new ZTBusinessException(inspectionDetailsList.getRespDesc());
        }
        List uocInspectionDetailsListBos = inspectionDetailsList.getRows();
        if (CollectionUtils.isEmpty((Collection)uocInspectionDetailsListBos)) {
            throw new ZTBusinessException("\u67e5\u8be2\u8ba2\u5355\u4e2d\u5fc3\u8fd4\u56de\u5355\u636e\u5217\u8868\u4e3a\u7a7a");
        }
        Map<Long, DycrelOrderBO> longDycRelOrderBoMap = this.assembleMap(uocInspectionDetailsListBos, reqBO);
        Map<Long, String> longStringMap = this.checkOrderParam(longDycRelOrderBoMap, reqBO);
        return this.assembleRsp(longStringMap, longDycRelOrderBoMap);
    }

    private DycFscBillOrderBundlCheckRspBO assembleRsp(Map<Long, String> longStringMap, Map<Long, DycrelOrderBO> longDycRelOrderBoMap) {
        DycFscBillOrderBundlCheckRspBO dycFscBillOrderBundlCheckRspBO = new DycFscBillOrderBundlCheckRspBO();
        if (CollectionUtils.isEmpty(longStringMap)) {
            dycFscBillOrderBundlCheckRspBO.setBundlFlag(BUND);
        } else {
            dycFscBillOrderBundlCheckRspBO.setBundlFlag(NOT_BUND);
        }
        HashSet payAccountDaySet = new HashSet();
        HashSet payNodeAccountDaysSet = new HashSet();
        HashSet payTypeBoSet = new HashSet();
        HashSet payRuleBoSet = new HashSet();
        HashSet payAccountDayRuleBoSet = new HashSet();
        HashSet payNodeRuleBoSet = new HashSet();
        longDycRelOrderBoMap.values().forEach(dycrelOrderBO -> {
            if (dycrelOrderBO.getPayAccountDay() != null) {
                payAccountDaySet.add(dycrelOrderBO.getPayAccountDay());
            }
            if (dycrelOrderBO.getPayNodeAccountDays() != null) {
                payNodeAccountDaysSet.add(dycrelOrderBO.getPayNodeAccountDays());
            }
            if (dycrelOrderBO.getPayType() != null) {
                PayTypeBO payTypeBO = new PayTypeBO();
                payTypeBO.setPayType(dycrelOrderBO.getPayType());
                payTypeBO.setPayTypeStr(dycrelOrderBO.getPayTypeStr());
                payTypeBoSet.add(payTypeBO);
            }
            if (dycrelOrderBO.getPayRule() != null) {
                PayRuleBO payRuleBO = new PayRuleBO();
                payRuleBO.setPayRule(dycrelOrderBO.getPayRule());
                payRuleBO.setPayRuleStr(dycrelOrderBO.getPayRuleStr());
                payRuleBoSet.add(payRuleBO);
            }
            if (dycrelOrderBO.getPayAccountDayRule() != null) {
                PayAccountDayRuleBO payAccountDayRuleBo = new PayAccountDayRuleBO();
                payAccountDayRuleBo.setPayAccountDayRule(dycrelOrderBO.getPayAccountDayRule());
                payAccountDayRuleBo.setPayAccountDayRuleStr(dycrelOrderBO.getPayAccountDayRuleStr());
                payAccountDayRuleBoSet.add(payAccountDayRuleBo);
            }
            if (dycrelOrderBO.getPayNodeRule() != null) {
                PayNodeRuleBO payNodeRuleBo = new PayNodeRuleBO();
                payNodeRuleBo.setPayNodeRule(dycrelOrderBO.getPayNodeRule());
                payNodeRuleBo.setPayNodeRuleStr(dycrelOrderBO.getPayNodeRuleStr());
                payNodeRuleBoSet.add(payNodeRuleBo);
            }
        });
        dycFscBillOrderBundlCheckRspBO.setPayTypes(new ArrayList(payTypeBoSet));
        dycFscBillOrderBundlCheckRspBO.setPayAccountDayRules(new ArrayList(payAccountDayRuleBoSet));
        dycFscBillOrderBundlCheckRspBO.setPayAccountDays(new ArrayList(payAccountDaySet));
        dycFscBillOrderBundlCheckRspBO.setPayNodeAccountDayList(new ArrayList(payNodeAccountDaysSet));
        dycFscBillOrderBundlCheckRspBO.setPayRules(new ArrayList(payRuleBoSet));
        dycFscBillOrderBundlCheckRspBO.setPayNodeRules(new ArrayList(payNodeRuleBoSet));
        return dycFscBillOrderBundlCheckRspBO;
    }

    private Map<Long, String> checkOrderParam(Map<Long, DycrelOrderBO> longDycRelOrderBOMap, DycFscBillOrderBundlCheckReqBO reqBO) {
        DycrelOrderBO dycrelOrderBO = longDycRelOrderBOMap.get(((DycrelOrderBO)reqBO.getRelOrderList().get(0)).getAcceptOrderId());
        if (null == dycrelOrderBO) {
            throw new ZTBusinessException("\u67e5\u8be2\u8ba2\u5355\u6216\u53d1\u8d27\u5355[" + ((DycrelOrderBO)reqBO.getRelOrderList().get(0)).getAcceptOrderId() + "]\u4fe1\u606f\u4e3a\u7a7a");
        }
        HashMap<Long, String> acceptIdMap = new HashMap<Long, String>(16);
        for (Map.Entry<Long, DycrelOrderBO> longDycRelOrderBoEntry : longDycRelOrderBOMap.entrySet()) {
            if (!dycrelOrderBO.getPayType().equals(longDycRelOrderBoEntry.getValue().getPayType())) {
                throw new ZTBusinessException("\u8ba2\u5355\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
            }
            if (dycrelOrderBO.getSupplierCode().equals(longDycRelOrderBoEntry.getValue().getSupplierCode())) continue;
            throw new ZTBusinessException("\u8ba2\u5355\u5546\u6237\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
        }
        return acceptIdMap;
    }

    private Map<Long, DycrelOrderBO> assembleMap(List<UocInspectionDetailsListBO> uocInspectionDetailsListBos, DycFscBillOrderBundlCheckReqBO reqBO) {
        HashMap<Long, DycrelOrderBO> dycRelOrderBoHashMap = new HashMap<Long, DycrelOrderBO>(16);
        for (UocInspectionDetailsListBO row : uocInspectionDetailsListBos) {
            DycrelOrderBO dycrelOrderBo = new DycrelOrderBO();
            dycrelOrderBo.setAcceptOrderId(Long.valueOf(Long.parseLong(row.getInspectionVoucherId())));
            dycrelOrderBo.setOrderId(Long.valueOf(Long.parseLong(row.getOrderId())));
            dycrelOrderBo.setPayAccountDay(row.getPayAccountDay());
            dycrelOrderBo.setPayType(row.getPayType());
            dycrelOrderBo.setPayTypeStr(row.getPayTypeStr());
            dycrelOrderBo.setPayRule(row.getPayRule());
            dycrelOrderBo.setPayRuleStr(PAY_RULE.get(row.getPayRule()));
            dycrelOrderBo.setPayAccountDayRule(row.getPayAccountDayRule());
            dycrelOrderBo.setPayAccountDayRuleStr(PAY_ACCOUNT_RULE.get(row.getPayAccountDayRule()));
            dycrelOrderBo.setPayNodeRule(row.getPayNodeRule());
            dycrelOrderBo.setPayNodeRuleStr(PAY_NODE_RULE.get(row.getPayNodeRule()));
            dycrelOrderBo.setSupplierCode(row.getSupNo());
            dycrelOrderBo.setPurchaserCode(row.getPurNo());
            dycrelOrderBo.setPurchaseOrderNo(row.getPurchaseVoucherNo());
            dycrelOrderBo.setSaleOrderNo(row.getSaleVoucherNo());
            dycrelOrderBo.setTradeMode(row.getTradeMode());
            dycrelOrderBo.setPayNodeAccountDays(row.getPaymentDays());
            dycrelOrderBo.setPayAccountDay(row.getPayAccountDay());
            dycrelOrderBo.setSupplierCode(row.getSupNo());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                dycrelOrderBo.setOrderNo(row.getSaleVoucherNo());
            }
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                dycrelOrderBo.setOrderNo(row.getPurchaseVoucherNo());
            }
            dycRelOrderBoHashMap.put(dycrelOrderBo.getAcceptOrderId(), dycrelOrderBo);
        }
        return dycRelOrderBoHashMap;
    }

    private void val(DycFscBillOrderBundlCheckReqBO reqBO) {
        if (null == reqBO.getMakeType()) {
            throw new ZTBusinessException("\u5165\u53c2[makeType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getReceiveType()) {
            throw new ZTBusinessException("\u5165\u53c2[receiveType]\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getRelOrderList())) {
            throw new ZTBusinessException("\u5165\u53c2[relOrderList]\u4e3a\u7a7a");
        }
    }

    static {
        PAY_RULE.put(1, "\u6307\u5b9a\u8d26\u671f\u65e5");
        PAY_RULE.put(2, "\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9+\u8d26\u671f\u5929\u6570");
        PAY_ACCOUNT_RULE.put(1, "\u7b7e\u6536\u53d1\u7968");
        PAY_ACCOUNT_RULE.put(2, "\u8ba2\u5355\u9a8c\u6536");
        PAY_ACCOUNT_RULE.put(3, "\u8ba2\u5355\u5230\u8d27");
        PAY_NODE_RULE.put(1, "\u7b7e\u6536\u53d1\u7968\u5f00\u59cb\u8ba1\u7b97");
        PAY_NODE_RULE.put(2, "\u8ba2\u5355\u9a8c\u6536\u5f00\u59cb\u8ba1\u7b97");
        PAY_NODE_RULE.put(3, "\u8ba2\u5355\u5230\u8d27\u5f00\u59cb\u8ba1\u7b97");
    }
}

