/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.supplier.impl;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.dyc.supplier.api.DycCommonGenerateSbrNoticePdfService;
import com.tydic.dyc.supplier.bo.DycCommonGenerateSbrNoticePdfReqBO;
import com.tydic.dyc.supplier.bo.DycCommonGenerateSbrNoticePdfRspBO;
import com.tydic.dyc.supplier.util.PdfUtil;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.general.ability.api.DictionaryAbilityService;
import com.tydic.umc.general.ability.bo.DicDictionaryBO;
import com.tydic.umc.general.ability.bo.QueryDictionaryAbilityReqBO;
import com.tydic.umc.supplier.ability.api.UmcQrySupMisNoticeDetailAbilityService;
import com.tydic.umc.supplier.ability.api.UmcQrySupMisconductDetailAbilityService;
import com.tydic.umc.supplier.ability.bo.UmcQrySupMisNoticeDetailAbilityReqBO;
import com.tydic.umc.supplier.ability.bo.UmcQrySupMisNoticeDetailAbilityRspBO;
import com.tydic.umc.supplier.ability.bo.UmcQrySupMisconductDetailAbilityReqBO;
import com.tydic.umc.supplier.ability.bo.UmcQrySupMisconductDetailAbilityRspBO;
import com.tydic.umc.supplier.ability.bo.UmcSupMisconductNoticeBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycCommonGenerateSbrNoticePdfServiceImpl
implements DycCommonGenerateSbrNoticePdfService {
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final String PATH = "umc";
    @Autowired
    private UmcQrySupMisNoticeDetailAbilityService umcQrySupMisNoticeDetailAbilityService;
    @Autowired
    private UmcQrySupMisconductDetailAbilityService umcQrySupMisconductDetailAbilityService;
    @Autowired
    private DictionaryAbilityService dictionaryAbilityService;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Autowired
    private FileClient fileClient;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    public DycCommonGenerateSbrNoticePdfRspBO generateSbrNoticePdf(DycCommonGenerateSbrNoticePdfReqBO reqBO) {
        BaseFont baseFont;
        DycCommonGenerateSbrNoticePdfRspBO rspBO = new DycCommonGenerateSbrNoticePdfRspBO();
        if (reqBO == null || reqBO.getNoticeId() == null && reqBO.getMisconductId() == null) {
            rspBO.setCode("8888");
            throw new ZTBusinessException("\u4e0d\u826f\u8bb0\u5f55\u901a\u77e5\u4e66\u5bfc\u51fa\u53c2\u6570\u9519\u8bef");
        }
        UmcSupMisconductNoticeBO noticePdfBO = null;
        if (reqBO.getNoticeId() != null) {
            UmcQrySupMisNoticeDetailAbilityReqBO abilityReqBO = new UmcQrySupMisNoticeDetailAbilityReqBO();
            abilityReqBO.setNoticeId(reqBO.getNoticeId());
            UmcQrySupMisNoticeDetailAbilityRspBO abilityRspBO = this.umcQrySupMisNoticeDetailAbilityService.qrySupMisNoticeDetail(abilityReqBO);
            noticePdfBO = abilityRspBO.getUmcSupMisconductNoticeBO();
        } else if (reqBO.getMisconductId() != null) {
            List noticeIdList;
            UmcQrySupMisconductDetailAbilityReqBO umcQrySupMisconductDetailAbilityReqBO = new UmcQrySupMisconductDetailAbilityReqBO();
            umcQrySupMisconductDetailAbilityReqBO.setMisconductId(reqBO.getMisconductId());
            UmcQrySupMisconductDetailAbilityRspBO umcQrySupMisconductDetailAbilityRspBO = this.umcQrySupMisconductDetailAbilityService.qrySupMisconductList(umcQrySupMisconductDetailAbilityReqBO);
            if (umcQrySupMisconductDetailAbilityRspBO != null && umcQrySupMisconductDetailAbilityRspBO.getUmcSupMisconductBO() != null && (noticeIdList = umcQrySupMisconductDetailAbilityRspBO.getUmcSupMisconductBO().getNoticeIdList()) != null && noticeIdList.size() > 0) {
                UmcQrySupMisNoticeDetailAbilityReqBO abilityReqBO = new UmcQrySupMisNoticeDetailAbilityReqBO();
                abilityReqBO.setNoticeId((Long)noticeIdList.get(0));
                UmcQrySupMisNoticeDetailAbilityRspBO abilityRspBO = this.umcQrySupMisNoticeDetailAbilityService.qrySupMisNoticeDetail(abilityReqBO);
                noticePdfBO = abilityRspBO.getUmcSupMisconductNoticeBO();
            }
        }
        if (noticePdfBO == null || noticePdfBO.getUmcSupMisconductNoticeTemplateBO() == null) {
            rspBO.setCode("8888");
            rspBO.setMessage("\u672a\u627e\u5230\u5bf9\u5e94\u4e0d\u826f\u8bb0\u5f55\u5904\u7f5a\u4fe1\u606f");
            return rspBO;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), 100.0f, 100.0f, 75.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519");
        }
        Font titleFont = new Font(baseFont, 16.0f, 1);
        Font contentFont = new Font(baseFont, 12.0f, 0);
        int COLUMNS = 20;
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        float fixedHeight = 0.0f;
        PdfPTable titleTable = new PdfPTable(20);
        tableList.add(titleTable);
        PdfUtil.addCellToTable(titleTable, "\u4e0d \u826f \u8bb0 \u5f55 \u901a \u77e5 \u4e66", titleFont, 1, 5, Float.valueOf(50.0f), 20, 0);
        fixedHeight += 75.0f;
        PdfPTable pdfPTable2 = new PdfPTable(20);
        tableList.add(pdfPTable2);
        PdfUtil.addCellToTable(pdfPTable2, "\u901a\u77e5\u4e66\u7c7b\u578b\uff1a", contentFont, 0, 4, Float.valueOf(30.0f), 3, 0);
        PdfUtil.addCellToTable(pdfPTable2, this.convertNullToString(noticePdfBO.getUmcSupMisconductNoticeTemplateBO().getTemplateTypeStr()), contentFont, 0, 1, Float.valueOf(30.0f), 17, 0);
        fixedHeight += 55.0f;
        String templateDesc = this.replaceTemplateDescKey(noticePdfBO);
        PdfPTable pdfPTable3 = new PdfPTable(20);
        tableList.add(pdfPTable3);
        PdfUtil.addCellToTable(pdfPTable3, "\u901a\u77e5\u4e66\u5185\u5bb9\uff1a", contentFont, 0, 4, Float.valueOf(0.0f), 3, 0);
        PdfUtil.addCellToTable(pdfPTable3, this.convertNullToString(templateDesc), contentFont, 0, 4, Float.valueOf(0.0f), 17, 0);
        fixedHeight += (float)(templateDesc.length() / 100 + 1) * 25.0f;
        Image image = null;
        String imgFile = "classpath:image/lALPDgtYvKm1Bn3NAfHNAfE_497_497.png";
        try {
            image = Image.getInstance((String)imgFile);
            image.setAlignment(8);
            image.setAbsolutePosition(595.0f, 717.0f - fixedHeight - 200.0f);
            image.scaleAbsolute(125.0f, 125.0f);
            document.add((Element)image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PdfUtil.addTableListToDoc(document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = noticePdfBO.getSupplierName() + "\u4e0d\u826f\u8bb0\u5f55\u901a\u77e5\u4e66" + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        String exportUrl = null;
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        rspBO.setGenerateSbrNoticePdfUrl(exportUrl);
        return rspBO;
    }

    private String replaceTemplateDescKey(UmcSupMisconductNoticeBO noticePdfBO) {
        Map<String, String> keyMap = this.replaceTemplateDescMap(noticePdfBO);
        String templateDesc = noticePdfBO.getUmcSupMisconductNoticeTemplateBO().getTemplateDesc();
        if (!StringUtils.isEmpty((CharSequence)templateDesc)) {
            QueryDictionaryAbilityReqBO queryDictionaryAbilityReqBO = new QueryDictionaryAbilityReqBO();
            queryDictionaryAbilityReqBO.setPcode("SBR_NOTICE_VARIABLE");
            UmcRspListBO dicDictionaryBOUmcRspListBO = this.dictionaryAbilityService.queryBypCodeBackPo(queryDictionaryAbilityReqBO);
            if (!"0000".equals(dicDictionaryBOUmcRspListBO.getRespCode())) {
                throw new ZTBusinessException(dicDictionaryBOUmcRspListBO.getRespDesc());
            }
            List dicDictionaryBOS = dicDictionaryBOUmcRspListBO.getRows();
            templateDesc = templateDesc.replaceAll("<div>", "").replaceAll("</div>", "").replaceAll("&nbsp;", " ");
            String regex = "<span.*?</span>";
            Pattern patten = Pattern.compile(regex);
            Matcher matcher = patten.matcher(templateDesc);
            ArrayList<String> spanList = new ArrayList<String>();
            while (matcher.find()) {
                spanList.add(matcher.group());
            }
            for (String spanItme : spanList) {
                boolean replaceFlag = false;
                for (Map.Entry<String, String> itemMap : keyMap.entrySet()) {
                    String key = "keyval=\"" + itemMap.getKey() + "\"";
                    if (!spanItme.contains(key)) continue;
                    templateDesc = templateDesc.replaceAll(spanItme, itemMap.getValue());
                    replaceFlag = true;
                    break;
                }
                if (replaceFlag) continue;
                if (dicDictionaryBOS != null && dicDictionaryBOS.size() > 0) {
                    for (DicDictionaryBO itemBO : dicDictionaryBOS) {
                        if (!spanItme.contains(itemBO.getCode())) continue;
                        templateDesc = templateDesc.replaceAll(spanItme, itemBO.getTitle());
                        replaceFlag = true;
                        break;
                    }
                }
                if (replaceFlag) continue;
                templateDesc = templateDesc.replaceAll(spanItme, "");
            }
        }
        return templateDesc;
    }

    private Map<String, String> replaceTemplateDescMap(UmcSupMisconductNoticeBO noticePdfBO) {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        keyMap.put("supplierName", noticePdfBO.getSupplierName());
        keyMap.put("misconductTypeStr", noticePdfBO.getUmcSupMisconductNoticeTemplateBO().getTemplateTypeStr());
        keyMap.put("misconductRuleDocUrl", "\u300a\u4e0d\u826f\u8bb0\u5f55\u89c4\u5219\u6587\u6863 \u300b");
        if (noticePdfBO.getDeductPoints() != null) {
            keyMap.put("deductPoints", noticePdfBO.getDeductPoints().toString());
            keyMap.put("deductPointsTime", df.format(LocalDateTime.ofInstant(noticePdfBO.getCreateTime().toInstant(), ZoneId.systemDefault())));
        }
        if (!StringUtils.isEmpty((CharSequence)noticePdfBO.getPenaltyAmount())) {
            keyMap.put("penaltyAmount", noticePdfBO.getPenaltyAmount() + "(\u4e07\u5143)");
        }
        if (noticePdfBO.getBlacklistEffTime() != null) {
            keyMap.put("blackListEffTime", df.format(LocalDateTime.ofInstant(noticePdfBO.getBlacklistEffTime().toInstant(), ZoneId.systemDefault())));
        }
        if (noticePdfBO.getBlacklistExpTime() != null) {
            keyMap.put("blackListExpTime", df.format(LocalDateTime.ofInstant(noticePdfBO.getBlacklistExpTime().toInstant(), ZoneId.systemDefault())));
        }
        if (noticePdfBO.getDisqualifyEffTime() != null) {
            keyMap.put("disqualifyEffTime", df.format(LocalDateTime.ofInstant(noticePdfBO.getDisqualifyEffTime().toInstant(), ZoneId.systemDefault())));
        }
        if (noticePdfBO.getDisqualifyExpTime() != null) {
            keyMap.put("disqualifyExpTime", df.format(LocalDateTime.ofInstant(noticePdfBO.getDisqualifyExpTime().toInstant(), ZoneId.systemDefault())));
        }
        keyMap.put("systemTime", df.format(LocalDateTime.ofInstant(noticePdfBO.getCreateTime().toInstant(), ZoneId.systemDefault())));
        return keyMap;
    }

    private String convertNullToString(Object obj) {
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }
}

