/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.ref.ability.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.yqsmartcity.data.ref.ability.RfCollectDataTaskService;
import com.yqsmartcity.data.ref.ability.RfCollectFieldService;
import com.yqsmartcity.data.ref.ability.RfDataSourceService;
import com.yqsmartcity.data.ref.ability.RfSystemService;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskListRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectFieldBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectFieldListRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectFieldReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfCreateTableReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceBO;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceListRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfSystemListRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfSystemReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfTableColumnRspBO;
import com.yqsmartcity.data.ref.datax.job.DataxColumn;
import com.yqsmartcity.data.ref.datax.job.DataxJobWriterBuilder;
import com.yqsmartcity.data.ref.datax.job.Hdfs2MysqlBO;
import com.yqsmartcity.data.ref.datax.job.Hdfs2OracleBO;
import com.yqsmartcity.data.ref.datax.job.HdfsReader;
import com.yqsmartcity.data.ref.datax.job.HdfsWriter;
import com.yqsmartcity.data.ref.datax.job.IndexColumn;
import com.yqsmartcity.data.ref.datax.job.Mysql2HdfsBO;
import com.yqsmartcity.data.ref.datax.job.Mysql2MysqlBO;
import com.yqsmartcity.data.ref.datax.job.MysqlReader;
import com.yqsmartcity.data.ref.datax.job.MysqlWriter;
import com.yqsmartcity.data.ref.datax.job.OracleWriter;
import com.yqsmartcity.data.ref.db.CommDruidTemplate;
import com.yqsmartcity.data.ref.db.RefSequence;
import com.yqsmartcity.data.ref.db.dao.RfCollectDataTaskMapper;
import com.yqsmartcity.data.ref.db.po.RfCollectDataTaskPO;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RfCollectDataTaskServiceImpl
implements RfCollectDataTaskService {
    private static final Logger log = LoggerFactory.getLogger(RfCollectDataTaskServiceImpl.class);
    @Value(value="${rf.custom.division.table:}")
    private String custom_division_table;
    @Value(value="${rf.custom.division.char:}")
    private String custom_division_char;
    @Value(value="${haveKerberos:false}")
    private Boolean haveKerberos;
    @Value(value="${kerberosKeytabFilePath:defaultPath}")
    private String kerberosKeytabFilePath;
    @Value(value="${kerberosPrincipal:defaultPrincipal}")
    private String kerberosPrincipal;
    @Autowired
    DataxJobWriterBuilder dataxJobWriterBuilder;
    @Autowired
    RfSystemService rfSystemService;
    @Autowired
    RfDataSourceService rfDataSourceService;
    @Autowired
    RfCollectFieldService rfCollectFieldService;
    @Autowired
    RfCollectDataTaskMapper rfCollectDataTaskMapper;
    @Autowired
    CommDruidTemplate commDruidTemplate;

    public RfCollectDataTaskRspBO queryRfCollectDataTaskSingle(RfCollectDataTaskReqBO rfCollectDataTaskReqBO) {
        RfCollectDataTaskRspBO rspBO = new RfCollectDataTaskRspBO();
        RfCollectDataTaskPO selectRfCollectDataTaskPO = new RfCollectDataTaskPO();
        BeanUtils.copyProperties((Object)rfCollectDataTaskReqBO, (Object)selectRfCollectDataTaskPO);
        List<RfCollectDataTaskPO> rfCollectDataTaskList = this.rfCollectDataTaskMapper.selectByCondition(selectRfCollectDataTaskPO);
        if (rfCollectDataTaskList.size() != 1) {
            if (rfCollectDataTaskList.size() > 1) {
                throw new ZTBusinessException("\u67e5\u8be2\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f");
            }
            throw new ZTBusinessException("\u67e5\u8be2\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f");
        }
        RfCollectDataTaskBO rfCollectDataTaskBO = new RfCollectDataTaskBO();
        BeanUtils.copyProperties((Object)rfCollectDataTaskList.get(0), (Object)rfCollectDataTaskBO);
        RfCollectFieldReqBO selectRfCollectFieldReqBO = new RfCollectFieldReqBO();
        selectRfCollectFieldReqBO.setCollectTaskCode(rfCollectDataTaskBO.getCollectTaskCode());
        selectRfCollectFieldReqBO.setSysCode(rfCollectDataTaskBO.getSysCode());
        RfCollectFieldListRspBO rfCollectFieldListRspBO = this.rfCollectFieldService.queryRfCollectFieldList(selectRfCollectFieldReqBO);
        rfCollectDataTaskBO.setRfCollectFieldList(rfCollectFieldListRspBO.getData());
        rspBO.setData(rfCollectDataTaskBO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RfCollectDataTaskRspBO executeRfCollectDataTask(String collectTaskCode) {
        RfCollectDataTaskReqBO selectRfCollectDataTaskReqBO = new RfCollectDataTaskReqBO();
        selectRfCollectDataTaskReqBO.setCollectTaskCode(collectTaskCode);
        return this.executeRfCollectDataTask(selectRfCollectDataTaskReqBO);
    }

    public RfCollectDataTaskRspBO executeRfCollectDataTask(RfCollectDataTaskReqBO rfCollectDataTaskReqBO) {
        RfCollectDataTaskRspBO rspBO = new RfCollectDataTaskRspBO();
        RfCollectDataTaskRspBO rfCollectDataTaskRspBO = this.queryRfCollectDataTaskSingle(rfCollectDataTaskReqBO);
        RfDataSourceReqBO selectCollectRfDataSourceReqBO = new RfDataSourceReqBO();
        selectCollectRfDataSourceReqBO.setDataSourceCode(rfCollectDataTaskRspBO.getData().getCollectDataSourceCode());
        RfDataSourceRspBO collectRfDataSourceRspBO = this.rfDataSourceService.queryRfDataSourceSingle(selectCollectRfDataSourceReqBO);
        RfDataSourceReqBO selectTargetRfDataSourceReqBO = new RfDataSourceReqBO();
        selectTargetRfDataSourceReqBO.setDataSourceCode(rfCollectDataTaskRspBO.getData().getTargetDataSourceCode());
        RfDataSourceRspBO targetRfDataSourceRspBO = this.rfDataSourceService.queryRfDataSourceSingle(selectTargetRfDataSourceReqBO);
        String[] tatbelNames = this.custom_division_table.split(",");
        List<String> tatbelNameList = Arrays.asList(tatbelNames);
        String jobId = "" + RefSequence.getInstance().nextId();
        if ("MYSQL".equals(collectRfDataSourceRspBO.getData().getDataSourceType()) && "MYSQL".equals(targetRfDataSourceRspBO.getData().getDataSourceType())) {
            String path = this.dataxJobWriterBuilder.getJobPath();
            try {
                String fileName = "J" + jobId + ".json";
                log.info("path=" + path);
                log.info("fileName=" + fileName);
                ArrayList<String> columnName = new ArrayList<String>();
                if (rfCollectDataTaskRspBO.getData().getRfCollectFieldList() != null || rfCollectDataTaskRspBO.getData().getRfCollectFieldList().size() > 0) {
                    for (RfCollectFieldBO rfCollectFieldBO : rfCollectDataTaskRspBO.getData().getRfCollectFieldList()) {
                        columnName.add(rfCollectFieldBO.getCollectFieldName());
                    }
                }
                Mysql2MysqlBO mysql2MysqlBO = new Mysql2MysqlBO();
                MysqlReader mysqlReader = new MysqlReader();
                mysqlReader.setReaderJdbcUrl(collectRfDataSourceRspBO.getData().getDataSourceUrl());
                if (!mysqlReader.getReaderJdbcUrl().contains("?")) {
                    mysqlReader.setReaderJdbcUrl(mysqlReader.getReaderJdbcUrl() + "?useSSL=false");
                }
                mysqlReader.setReaderUsername(collectRfDataSourceRspBO.getData().getUserName());
                mysqlReader.setReaderPassword(collectRfDataSourceRspBO.getData().getPassword());
                mysqlReader.setReaderTable(rfCollectDataTaskRspBO.getData().getCollectTable());
                if (StringUtils.isNotBlank((CharSequence)rfCollectDataTaskRspBO.getData().getCollectCondition())) {
                    mysqlReader.setReaderWhere(rfCollectDataTaskRspBO.getData().getCollectCondition());
                }
                mysqlReader.setReaderColumn(columnName);
                MysqlWriter mysqlWriter = new MysqlWriter();
                mysqlWriter.setWriterJdbcUrl(targetRfDataSourceRspBO.getData().getDataSourceUrl());
                if (!mysqlWriter.getWriterJdbcUrl().contains("?")) {
                    mysqlWriter.setWriterJdbcUrl(mysqlWriter.getWriterJdbcUrl() + "?useSSL=false");
                }
                mysqlWriter.setWriterUsername(targetRfDataSourceRspBO.getData().getUserName());
                mysqlWriter.setWriterPassword(targetRfDataSourceRspBO.getData().getPassword());
                mysqlWriter.setWriterTable(rfCollectDataTaskRspBO.getData().getTargetTable());
                mysqlWriter.setWriterPreSql("truncate " + rfCollectDataTaskRspBO.getData().getTargetTable());
                mysqlWriter.setWriterColumnStr(columnName);
                mysql2MysqlBO.init(mysqlReader, mysqlWriter);
                String content = this.dataxJobWriterBuilder.parseContent(mysql2MysqlBO);
                log.info(content);
                this.dataxJobWriterBuilder.createJobFile(path, fileName, content);
                this.dataxJobWriterBuilder.executeJob(path + File.separator + fileName, jobId);
                rspBO.setJobContent(content);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u6267\u884c\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u6267\u884c\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            }
        } else if ("MYSQL".equals(collectRfDataSourceRspBO.getData().getDataSourceType()) && "HDFS".equals(targetRfDataSourceRspBO.getData().getDataSourceType())) {
            String path = this.dataxJobWriterBuilder.getJobPath();
            try {
                String fileName = "J" + jobId + ".json";
                log.info("path=" + path);
                log.info("fileName=" + fileName);
                Mysql2HdfsBO mysql2HdfsBO = new Mysql2HdfsBO();
                MysqlReader mysqlReader = new MysqlReader();
                mysqlReader.setReaderJdbcUrl(collectRfDataSourceRspBO.getData().getDataSourceUrl());
                mysqlReader.setReaderUsername(collectRfDataSourceRspBO.getData().getUserName());
                mysqlReader.setReaderPassword(collectRfDataSourceRspBO.getData().getPassword());
                mysqlReader.setReaderTable(rfCollectDataTaskRspBO.getData().getCollectTable());
                if (StringUtils.isNotBlank((CharSequence)rfCollectDataTaskRspBO.getData().getCollectCondition())) {
                    mysqlReader.setReaderWhere(rfCollectDataTaskRspBO.getData().getCollectCondition());
                }
                HdfsWriter hdfsWriter = new HdfsWriter();
                String targetUrl = targetRfDataSourceRspBO.getData().getDataSourceUrl();
                Integer index = targetUrl.indexOf("/", 8);
                hdfsWriter.setDefaultFS(targetUrl.substring(0, index));
                hdfsWriter.setPath(targetUrl.substring(index) + rfCollectDataTaskRspBO.getData().getTargetTable());
                hdfsWriter.setFileName(rfCollectDataTaskRspBO.getData().getTargetTable());
                if (rfCollectDataTaskRspBO.getData().getRfCollectFieldList() != null || rfCollectDataTaskRspBO.getData().getRfCollectFieldList().size() > 0) {
                    ArrayList<String> readerColumn = new ArrayList<String>();
                    ArrayList<DataxColumn> writerColumn = new ArrayList<DataxColumn>();
                    for (RfCollectFieldBO rfCollectFieldBO : rfCollectDataTaskRspBO.getData().getRfCollectFieldList()) {
                        DataxColumn dataxColumn = new DataxColumn();
                        dataxColumn.setName(rfCollectFieldBO.getCollectFieldName());
                        dataxColumn.setType(rfCollectFieldBO.getCollectFieldType());
                        writerColumn.add(dataxColumn);
                        readerColumn.add(rfCollectFieldBO.getCollectFieldName());
                    }
                    hdfsWriter.setWriterColumn(writerColumn);
                    mysqlReader.setReaderColumn(readerColumn);
                }
                if (tatbelNameList.contains(hdfsWriter.getFileName())) {
                    hdfsWriter.setFieldDelimiter(this.custom_division_char);
                }
                if (this.haveKerberos.booleanValue()) {
                    hdfsWriter.setHaveKerberos(this.haveKerberos);
                    hdfsWriter.setKerberosKeytabFilePath(this.kerberosKeytabFilePath);
                    hdfsWriter.setKerberosPrincipal(this.kerberosPrincipal);
                }
                mysql2HdfsBO.init(mysqlReader, hdfsWriter);
                String content = this.dataxJobWriterBuilder.parseContent(mysql2HdfsBO);
                log.info(content);
                this.dataxJobWriterBuilder.createJobFile(path, fileName, content);
                this.dataxJobWriterBuilder.executeJob(path + File.separator + fileName, jobId);
                rspBO.setJobContent(content);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u6267\u884c\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u6267\u884c\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            }
        } else if ("HDFS".equals(collectRfDataSourceRspBO.getData().getDataSourceType()) && "MYSQL".equals(targetRfDataSourceRspBO.getData().getDataSourceType())) {
            String path = this.dataxJobWriterBuilder.getJobPath();
            try {
                String fileName = "J" + jobId + ".json";
                log.info("path=" + path);
                log.info("fileName=" + fileName);
                Hdfs2MysqlBO hdfs2MysqlBO = new Hdfs2MysqlBO();
                HdfsReader hdfsReader = new HdfsReader();
                String targetUrl = collectRfDataSourceRspBO.getData().getDataSourceUrl();
                Integer index = targetUrl.indexOf("/", 8);
                hdfsReader.setDefaultFS(targetUrl.substring(0, index));
                hdfsReader.setPath(targetUrl.substring(index) + rfCollectDataTaskRspBO.getData().getCollectTable());
                hdfsReader.setFileName(rfCollectDataTaskRspBO.getData().getCollectTable());
                if (tatbelNameList.contains(hdfsReader.getFileName())) {
                    hdfsReader.setFieldDelimiter(this.custom_division_char);
                }
                if (this.haveKerberos.booleanValue()) {
                    hdfsReader.setHaveKerberos(this.haveKerberos);
                    hdfsReader.setKerberosKeytabFilePath(this.kerberosKeytabFilePath);
                    hdfsReader.setKerberosPrincipal(this.kerberosPrincipal);
                }
                MysqlWriter mysqlWriter = new MysqlWriter();
                mysqlWriter.setWriterJdbcUrl(targetRfDataSourceRspBO.getData().getDataSourceUrl());
                mysqlWriter.setWriterUsername(targetRfDataSourceRspBO.getData().getUserName());
                mysqlWriter.setWriterPassword(targetRfDataSourceRspBO.getData().getPassword());
                mysqlWriter.setWriterTable(rfCollectDataTaskRspBO.getData().getTargetTable());
                mysqlWriter.setWriterPreSql("truncate " + rfCollectDataTaskRspBO.getData().getTargetTable());
                if (rfCollectDataTaskRspBO.getData().getRfCollectFieldList() != null || rfCollectDataTaskRspBO.getData().getRfCollectFieldList().size() > 0) {
                    ArrayList<String> writerColumnStr = new ArrayList<String>();
                    for (RfCollectFieldBO rfCollectFieldBO : rfCollectDataTaskRspBO.getData().getRfCollectFieldList()) {
                        writerColumnStr.add(rfCollectFieldBO.getCollectFieldName());
                    }
                    mysqlWriter.setWriterColumnStr(writerColumnStr);
                }
                hdfs2MysqlBO.init(hdfsReader, mysqlWriter);
                String content = this.dataxJobWriterBuilder.parseContent(hdfs2MysqlBO);
                log.info(content);
                this.dataxJobWriterBuilder.createJobFile(path, fileName, content);
                this.dataxJobWriterBuilder.executeJob(path + File.separator + fileName, jobId);
                rspBO.setJobContent(content);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u6267\u884c\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u6267\u884c\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            }
        } else if ("HDFS".equals(collectRfDataSourceRspBO.getData().getDataSourceType()) && "ORACLE".equals(targetRfDataSourceRspBO.getData().getDataSourceType())) {
            String path = this.dataxJobWriterBuilder.getJobPath();
            try {
                String fileName = "J" + jobId + ".json";
                log.info("path=" + path);
                log.info("fileName=" + fileName);
                Hdfs2OracleBO hdfs2OracleBO = new Hdfs2OracleBO();
                HdfsReader hdfsReader = new HdfsReader();
                String targetUrl = collectRfDataSourceRspBO.getData().getDataSourceUrl();
                Integer index = targetUrl.indexOf("/", 8);
                hdfsReader.setDefaultFS(targetUrl.substring(0, index));
                hdfsReader.setPath(targetUrl.substring(index) + rfCollectDataTaskRspBO.getData().getCollectTable());
                hdfsReader.setFileName(rfCollectDataTaskRspBO.getData().getCollectTable());
                if (tatbelNameList.contains(hdfsReader.getFileName())) {
                    hdfsReader.setFieldDelimiter(this.custom_division_char);
                }
                if (this.haveKerberos.booleanValue()) {
                    hdfsReader.setHaveKerberos(this.haveKerberos);
                    hdfsReader.setKerberosKeytabFilePath(this.kerberosKeytabFilePath);
                    hdfsReader.setKerberosPrincipal(this.kerberosPrincipal);
                }
                OracleWriter oracleWriter = new OracleWriter();
                oracleWriter.setWriterJdbcUrl(targetRfDataSourceRspBO.getData().getDataSourceUrl());
                oracleWriter.setWriterUsername(targetRfDataSourceRspBO.getData().getUserName());
                oracleWriter.setWriterPassword(targetRfDataSourceRspBO.getData().getPassword());
                oracleWriter.setWriterTable(rfCollectDataTaskRspBO.getData().getTargetTable());
                oracleWriter.setWriterPreSql("truncate table " + rfCollectDataTaskRspBO.getData().getTargetTable());
                if (rfCollectDataTaskRspBO.getData().getRfCollectFieldList() != null || rfCollectDataTaskRspBO.getData().getRfCollectFieldList().size() > 0) {
                    ArrayList<String> writerColumnStr = new ArrayList<String>();
                    ArrayList<IndexColumn> readerColumn = new ArrayList<IndexColumn>();
                    Integer i = 0;
                    for (RfCollectFieldBO rfCollectFieldBO : rfCollectDataTaskRspBO.getData().getRfCollectFieldList()) {
                        IndexColumn indexColumn = new IndexColumn();
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                        indexColumn.setIndex(n);
                        indexColumn.setType("string");
                        readerColumn.add(indexColumn);
                        writerColumnStr.add(rfCollectFieldBO.getCollectFieldName());
                    }
                    oracleWriter.setWriterColumnStr(writerColumnStr);
                    hdfsReader.setReaderColumn(readerColumn);
                }
                hdfs2OracleBO.init(hdfsReader, oracleWriter);
                String content = this.dataxJobWriterBuilder.parseContent(hdfs2OracleBO);
                log.info(content);
                this.dataxJobWriterBuilder.createJobFile(path, fileName, content);
                this.dataxJobWriterBuilder.executeJob(path + File.separator + fileName, jobId);
                rspBO.setJobContent(content);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u6267\u884c\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u6267\u884c\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff1a" + e.getMessage());
            }
        } else {
            throw new ZTBusinessException("\u6267\u884c\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff1a\u4ece" + collectRfDataSourceRspBO.getData().getDataSourceType() + "\u62bd\u53d6\u5230" + targetRfDataSourceRspBO.getData().getDataSourceType() + "\u6682\u4e0d\u652f\u6301");
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RfCollectDataTaskListRspBO queryRfCollectDataTaskList(RfCollectDataTaskReqBO rfCollectDataTaskReqBO) {
        RfCollectDataTaskListRspBO rspBO = new RfCollectDataTaskListRspBO();
        RfCollectDataTaskPO selectRfCollectDataTaskPO = new RfCollectDataTaskPO();
        BeanUtils.copyProperties((Object)rfCollectDataTaskReqBO, (Object)selectRfCollectDataTaskPO);
        List<RfCollectDataTaskPO> rfCollectDataTaskPOList = this.rfCollectDataTaskMapper.selectByCondition(selectRfCollectDataTaskPO);
        ArrayList<RfCollectDataTaskBO> rfCollectDataTaskBOList = new ArrayList<RfCollectDataTaskBO>();
        for (RfCollectDataTaskPO rfCollectDataTaskPO : rfCollectDataTaskPOList) {
            RfCollectDataTaskBO rfCollectDataTaskBO = new RfCollectDataTaskBO();
            BeanUtils.copyProperties((Object)rfCollectDataTaskPO, (Object)rfCollectDataTaskBO);
            rfCollectDataTaskBOList.add(rfCollectDataTaskBO);
        }
        rspBO.setData(rfCollectDataTaskBOList);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RspPage<RfCollectDataTaskBO> queryRfCollectDataTaskListPage(RfCollectDataTaskReqBO rfCollectDataTaskReqBO) {
        return null;
    }

    @Transactional
    public RfCollectDataTaskRspBO addRfCollectDataTask(RfCollectDataTaskReqBO rfCollectDataTaskReqBO) {
        if (StringUtils.isBlank((CharSequence)rfCollectDataTaskReqBO.getSysCode())) {
            rfCollectDataTaskReqBO.setStatus("data-center");
        }
        if (StringUtils.isBlank((CharSequence)rfCollectDataTaskReqBO.getCollectTaskCode())) {
            throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u62bd\u53d6\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)rfCollectDataTaskReqBO.getCollectDataSourceCode())) {
            throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u62bd\u53d6\u6570\u636e\u6e90\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)rfCollectDataTaskReqBO.getTargetDataSourceCode())) {
            throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u76ee\u6807\u6570\u636e\u6e90\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)rfCollectDataTaskReqBO.getCollectTable())) {
            throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u62bd\u53d6\u6570\u636e\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)rfCollectDataTaskReqBO.getTargetTable())) {
            throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u76ee\u6807\u6570\u636e\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RfSystemReqBO selectRfSystemReqBO = new RfSystemReqBO();
        selectRfSystemReqBO.setSysCode(rfCollectDataTaskReqBO.getSysCode());
        RfSystemListRspBO rfSystemListRspBO = this.rfSystemService.queryRfSystemList(selectRfSystemReqBO);
        if (rfSystemListRspBO.getData() == null || rfSystemListRspBO.getData().size() == 0) {
            throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u8be5\u7cfb\u7edf\u7f16\u7801\u7684\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        RfDataSourceReqBO selectCollectRfDataSourceReqBO = new RfDataSourceReqBO();
        selectCollectRfDataSourceReqBO.setDataSourceCode(rfCollectDataTaskReqBO.getCollectDataSourceCode());
        RfDataSourceListRspBO rfCollectDataSourceListRspBO = this.rfDataSourceService.queryRfDataSourceList(selectCollectRfDataSourceReqBO);
        if (rfCollectDataSourceListRspBO.getData() == null || rfCollectDataSourceListRspBO.getData().size() == 0) {
            throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u8be5\uff08\u7cfb\u7edf\u7f16\u7801+\u62bd\u53d6\u6570\u636e\u6e90\u7f16\u7801\uff09\u7684\u62bd\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        RfDataSourceReqBO selectTargetRfDataSourceReqBO = new RfDataSourceReqBO();
        selectTargetRfDataSourceReqBO.setDataSourceCode(rfCollectDataTaskReqBO.getTargetDataSourceCode());
        RfDataSourceListRspBO rfTargetDataSourceListRspBO = this.rfDataSourceService.queryRfDataSourceList(selectTargetRfDataSourceReqBO);
        if (rfTargetDataSourceListRspBO.getData() == null || rfTargetDataSourceListRspBO.getData().size() == 0) {
            throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u8be5\uff08\u7cfb\u7edf\u7f16\u7801+\u76ee\u6807\u6570\u636e\u6e90\u7f16\u7801\uff09\u7684\u76ee\u6807\u6570\u636e\u6e90\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        RfCollectDataTaskReqBO selectRfCollectDataTaskReqBO = new RfCollectDataTaskReqBO();
        selectRfCollectDataTaskReqBO.setSysCode(rfCollectDataTaskReqBO.getSysCode());
        selectRfCollectDataTaskReqBO.setCollectTaskCode(rfCollectDataTaskReqBO.getCollectTaskCode());
        RfCollectDataTaskListRspBO rfCollectDataTaskListRspBO = this.queryRfCollectDataTaskList(selectRfCollectDataTaskReqBO);
        if (rfCollectDataTaskListRspBO.getData() != null && rfCollectDataTaskListRspBO.getData().size() > 0) {
            throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u8be5\uff08\u7cfb\u7edf\u7f16\u7801+\u62bd\u53d6\u4efb\u52a1\u7f16\u7801\uff09\u7684\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5df2\u5b58\u5728");
        }
        ArrayList rfCollectFieldList = rfCollectDataTaskReqBO.getRfCollectFieldList();
        ArrayList<String> fieldList = new ArrayList<String>();
        if (rfCollectFieldList != null && rfCollectFieldList.size() > 0) {
            for (RfCollectFieldReqBO rfCollectFieldReqBO : rfCollectFieldList) {
                if (StringUtils.isBlank((CharSequence)rfCollectFieldReqBO.getCollectFieldName())) {
                    throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u62bd\u53d6\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)rfCollectFieldReqBO.getCollectFieldType())) {
                    throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u62bd\u53d6\u5b57\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)rfCollectFieldReqBO.getCollectFieldDesc())) {
                    throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u62bd\u53d6\u5b57\u6bb5\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                fieldList.add(rfCollectFieldReqBO.getCollectFieldName());
            }
        } else if ("MYSQL".equals(((RfDataSourceBO)rfCollectDataSourceListRspBO.getData().get(0)).getDataSourceType())) {
            RfTableColumnRspBO rfTableColumnRspBO = this.commDruidTemplate.getTableColumns((RfDataSourceBO)rfCollectDataSourceListRspBO.getData().get(0), rfCollectDataTaskReqBO.getCollectTable());
            rfCollectFieldList = new ArrayList();
        }
        if (rfCollectDataTaskReqBO.getCreateTargetTable().booleanValue()) {
            RfCreateTableReqBO rfCreateTableReqBO = new RfCreateTableReqBO();
            rfCreateTableReqBO.setSysCode(((RfDataSourceBO)rfCollectDataSourceListRspBO.getData().get(0)).getSysCode());
            rfCreateTableReqBO.setDataSourceCode(((RfDataSourceBO)rfCollectDataSourceListRspBO.getData().get(0)).getDataSourceCode());
            rfCreateTableReqBO.setTableName(rfCollectDataTaskReqBO.getTargetTable());
            rfCreateTableReqBO.setFieldList(fieldList);
            this.commDruidTemplate.createTables((RfDataSourceBO)rfTargetDataSourceListRspBO.getData().get(0), rfCreateTableReqBO);
        }
        RfCollectDataTaskRspBO rspBO = new RfCollectDataTaskRspBO();
        RfCollectDataTaskPO insertRfCollectDataTaskPO = new RfCollectDataTaskPO();
        BeanUtils.copyProperties((Object)rfCollectDataTaskReqBO, (Object)insertRfCollectDataTaskPO);
        long id = Sequence.getInstance().nextId();
        insertRfCollectDataTaskPO.setId(id);
        insertRfCollectDataTaskPO.setCreateTime(new Date());
        int num = this.rfCollectDataTaskMapper.insert(insertRfCollectDataTaskPO);
        if (num == 1) {
            if (rfCollectFieldList != null && rfCollectFieldList.size() > 0) {
                for (RfCollectFieldReqBO rfCollectFieldReqBO : rfCollectFieldList) {
                    rfCollectFieldReqBO.setSysCode(rfCollectDataTaskReqBO.getSysCode());
                    rfCollectFieldReqBO.setCollectTaskCode(rfCollectDataTaskReqBO.getCollectTaskCode());
                    this.rfCollectFieldService.addRfCollectField(rfCollectFieldReqBO);
                }
            }
        } else {
            throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25");
        }
        RfCollectDataTaskBO rfCollectDataTaskBO = new RfCollectDataTaskBO();
        BeanUtils.copyProperties((Object)insertRfCollectDataTaskPO, (Object)rfCollectDataTaskBO);
        rspBO.setData(rfCollectDataTaskBO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional
    public RfCollectDataTaskRspBO updateRfCollectDataTask(RfCollectDataTaskReqBO rfCollectDataTaskReqBO) {
        RfCollectDataTaskPO updateRfCollectDataTaskPO;
        List rfCollectFieldList = rfCollectDataTaskReqBO.getRfCollectFieldList();
        if (rfCollectFieldList != null && rfCollectFieldList.size() > 0) {
            for (RfCollectFieldReqBO rfCollectFieldReqBO : rfCollectFieldList) {
                if (StringUtils.isBlank((CharSequence)rfCollectFieldReqBO.getCollectFieldName())) {
                    throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u62bd\u53d6\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)rfCollectFieldReqBO.getCollectFieldType())) {
                    throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u62bd\u53d6\u5b57\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.isBlank((CharSequence)rfCollectFieldReqBO.getCollectFieldDesc())) continue;
                throw new ZTBusinessException("\u65b0\u589e\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u62bd\u53d6\u5b57\u6bb5\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        RfCollectDataTaskRspBO rspBO = new RfCollectDataTaskRspBO();
        RfCollectDataTaskPO selectRfCollectDataTaskPO = new RfCollectDataTaskPO();
        selectRfCollectDataTaskPO.setId(rfCollectDataTaskReqBO.getId());
        List<RfCollectDataTaskPO> rfCollectDataTaskList = this.rfCollectDataTaskMapper.selectByCondition(selectRfCollectDataTaskPO);
        if (rfCollectDataTaskList.size() == 1) {
            updateRfCollectDataTaskPO = new RfCollectDataTaskPO();
            BeanUtils.copyProperties((Object)rfCollectDataTaskReqBO, (Object)updateRfCollectDataTaskPO);
            int num = this.rfCollectDataTaskMapper.update(updateRfCollectDataTaskPO);
            if (num != 1) throw new ZTBusinessException("\u4fee\u6539\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u4fee\u6539\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25");
            if (rfCollectFieldList != null && rfCollectFieldList.size() > 0) {
                RfCollectFieldReqBO selectRfCollectFieldReqBO = new RfCollectFieldReqBO();
                RfCollectFieldListRspBO rfCollectFieldListRspBO = this.rfCollectFieldService.queryRfCollectFieldList(selectRfCollectFieldReqBO);
                if (rfCollectFieldListRspBO.getData() != null && rfCollectFieldListRspBO.getData().size() > 0) {
                    for (RfCollectFieldBO rfCollectFieldBO : rfCollectFieldListRspBO.getData()) {
                        RfCollectFieldReqBO deleteRfCollectFieldReqBO = new RfCollectFieldReqBO();
                        deleteRfCollectFieldReqBO.setId(rfCollectFieldBO.getId());
                        this.rfCollectFieldService.deleteRfCollectField(deleteRfCollectFieldReqBO);
                    }
                }
                for (RfCollectFieldReqBO rfCollectFieldReqBO : rfCollectFieldList) {
                    rfCollectFieldReqBO.setSysCode(rfCollectDataTaskReqBO.getSysCode());
                    rfCollectFieldReqBO.setCollectTaskCode(rfCollectDataTaskReqBO.getCollectTaskCode());
                    this.rfCollectFieldService.addRfCollectField(rfCollectFieldReqBO);
                }
            }
        } else {
            if (rfCollectDataTaskList.size() <= 1) throw new ZTBusinessException("\u4fee\u6539\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f");
            throw new ZTBusinessException("\u4fee\u6539\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f");
        }
        RfCollectDataTaskBO rfCollectDataTaskBO = new RfCollectDataTaskBO();
        BeanUtils.copyProperties((Object)updateRfCollectDataTaskPO, (Object)rfCollectDataTaskBO);
        rspBO.setData(rfCollectDataTaskBO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @Transactional
    public RfCollectDataTaskRspBO saveRfCollectDataTask(RfCollectDataTaskReqBO rfCollectDataTaskReqBO) {
        if (rfCollectDataTaskReqBO.getId() == null) {
            return this.addRfCollectDataTask(rfCollectDataTaskReqBO);
        }
        return this.updateRfCollectDataTask(rfCollectDataTaskReqBO);
    }

    @Transactional
    public RfCollectDataTaskRspBO deleteRfCollectDataTask(RfCollectDataTaskReqBO rfCollectDataTaskReqBO) {
        RfCollectDataTaskRspBO rspBO = new RfCollectDataTaskRspBO();
        RfCollectDataTaskPO selectRfCollectDataTaskPO = new RfCollectDataTaskPO();
        selectRfCollectDataTaskPO.setId(rfCollectDataTaskReqBO.getId());
        List<RfCollectDataTaskPO> rfCollectDataTaskList = this.rfCollectDataTaskMapper.selectByCondition(selectRfCollectDataTaskPO);
        if (rfCollectDataTaskList.size() == 1) {
            RfCollectDataTaskPO deleteRfCollectDataTaskPO = new RfCollectDataTaskPO();
            BeanUtils.copyProperties((Object)rfCollectDataTaskReqBO, (Object)deleteRfCollectDataTaskPO);
            int num = this.rfCollectDataTaskMapper.delete(deleteRfCollectDataTaskPO);
            if (num != 1) {
                throw new ZTBusinessException("\u5220\u9664\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u5220\u9664\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (rfCollectDataTaskList.size() > 1) {
                throw new ZTBusinessException("\u5220\u9664\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f");
            }
            throw new ZTBusinessException("\u5220\u9664\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u62bd\u53d6\u4efb\u52a1\u4fe1\u606f");
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

