/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.ref.ability.impl;

import com.alibaba.druid.filter.config.ConfigTools;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.yqsmartcity.data.ref.ability.RfDataSourceService;
import com.yqsmartcity.data.ref.ability.RfSystemService;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceBO;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceListRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfSystemListRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfSystemReqBO;
import com.yqsmartcity.data.ref.db.dao.RfDataSourceMapper;
import com.yqsmartcity.data.ref.db.po.RfDataSourcePO;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rfDataSourceService")
public class RfDataSourceServiceImpl
implements RfDataSourceService {
    @Autowired
    RfSystemService rfSystemService;
    @Autowired
    RfDataSourceMapper rfDataSourceMapper;
    @Autowired
    DatabaseInfoDao databaseInfoDao;

    public RfDataSourceRspBO queryRfDataSourceSingle(RfDataSourceReqBO rfDataSourceReqBO) {
        RfDataSourceRspBO rspBO = new RfDataSourceRspBO();
        DatabaseInfoPO selectDatabaseInfoPO = new DatabaseInfoPO();
        selectDatabaseInfoPO.setDatabaseCode(rfDataSourceReqBO.getDataSourceCode());
        selectDatabaseInfoPO.setSysCode(rfDataSourceReqBO.getSysCode());
        this.databaseInfoDao.selectByCondition(selectDatabaseInfoPO);
        List<DatabaseInfoPO> rfDatabaseInfoList = this.databaseInfoDao.selectByCondition(selectDatabaseInfoPO);
        if (rfDatabaseInfoList.size() == 1) {
            RfDataSourceBO rfDataSourceBO = new RfDataSourceBO();
            DatabaseInfoPO databaseInfoPO = rfDatabaseInfoList.get(0);
            rfDataSourceBO.setCreateTime(databaseInfoPO.getCreateTime());
            rfDataSourceBO.setDataSourceCode(databaseInfoPO.getDatabaseCode());
            rfDataSourceBO.setDataSourceName(databaseInfoPO.getDatabaseName());
            String dataSourceType = null;
            String dataSourceUrl = null;
            if ("MS".equalsIgnoreCase(databaseInfoPO.getDatabaseType())) {
                dataSourceType = "MYSQL";
                dataSourceUrl = "jdbc:mysql://" + databaseInfoPO.getIpAddr() + ":" + databaseInfoPO.getPortNum() + "/" + databaseInfoPO.getServerName();
            } else if ("OR".equalsIgnoreCase(databaseInfoPO.getDatabaseType())) {
                dataSourceType = "ORACLE";
                dataSourceUrl = "jdbc:oracle:thin:@" + databaseInfoPO.getIpAddr() + ":" + databaseInfoPO.getPortNum() + "/" + databaseInfoPO.getServerName();
            }
            rfDataSourceBO.setDataSourceType(dataSourceType);
            rfDataSourceBO.setDataSourceUrl(dataSourceUrl);
            try {
                rfDataSourceBO.setPassword(ConfigTools.decrypt((String)databaseInfoPO.getUserPass()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rfDataSourceBO.setSysCode("data-center");
            rfDataSourceBO.setUserName(databaseInfoPO.getUserName());
            rfDataSourceBO.setDataSourceDesc(databaseInfoPO.getDatabaseName());
            rfDataSourceBO.setId(databaseInfoPO.getUnid());
            rspBO.setData(rfDataSourceBO);
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
        } else {
            if (rfDatabaseInfoList.size() > 1) {
                throw new ZTBusinessException("\u67e5\u8be2\u6570\u636e\u6e90\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4fe1\u606f");
            }
            RfDataSourcePO selectRfDataSourcePO = new RfDataSourcePO();
            BeanUtils.copyProperties((Object)rfDataSourceReqBO, (Object)selectRfDataSourcePO);
            List<RfDataSourcePO> rfDataSourceList = this.rfDataSourceMapper.selectByCondition(selectRfDataSourcePO);
            if (rfDataSourceList.size() == 1) {
                RfDataSourceBO rfDataSourceBO = new RfDataSourceBO();
                BeanUtils.copyProperties((Object)rfDataSourceList.get(0), (Object)rfDataSourceBO);
                rspBO.setData(rfDataSourceBO);
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setRespCode("0000");
            } else {
                if (rfDataSourceList.size() > 1) {
                    throw new ZTBusinessException("\u67e5\u8be2\u6570\u636e\u6e90\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4fe1\u606f");
                }
                throw new ZTBusinessException("\u67e5\u8be2\u6570\u636e\u6e90\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4fe1\u606f");
            }
        }
        return rspBO;
    }

    public RfDataSourceListRspBO queryRfDataSourceList(RfDataSourceReqBO rfDataSourceReqBO) {
        RfDataSourceListRspBO rspBO = new RfDataSourceListRspBO();
        DatabaseInfoPO selectDatabaseInfoPO = new DatabaseInfoPO();
        selectDatabaseInfoPO.setDatabaseCode(rfDataSourceReqBO.getDataSourceCode());
        selectDatabaseInfoPO.setSysCode(rfDataSourceReqBO.getSysCode());
        this.databaseInfoDao.selectByCondition(selectDatabaseInfoPO);
        List<DatabaseInfoPO> rfDatabaseInfoList = this.databaseInfoDao.selectByCondition(selectDatabaseInfoPO);
        ArrayList<RfDataSourceBO> rfDataSourceBOList = new ArrayList<RfDataSourceBO>();
        for (DatabaseInfoPO databaseInfoPO : rfDatabaseInfoList) {
            RfDataSourceBO rfDataSourceBO = new RfDataSourceBO();
            rfDataSourceBO.setCreateTime(databaseInfoPO.getCreateTime());
            rfDataSourceBO.setDataSourceCode(databaseInfoPO.getDatabaseCode());
            rfDataSourceBO.setDataSourceName(databaseInfoPO.getDatabaseName());
            String dataSourceType = null;
            String dataSourceUrl = null;
            if ("MS".equalsIgnoreCase(databaseInfoPO.getDatabaseType())) {
                dataSourceType = "MYSQL";
                dataSourceUrl = "jdbc:mysql://" + databaseInfoPO.getIpAddr() + ":" + databaseInfoPO.getPortNum() + "/" + databaseInfoPO.getServerName();
            } else if ("OR".equalsIgnoreCase(databaseInfoPO.getDatabaseType())) {
                dataSourceType = "ORACLE";
                dataSourceUrl = "jdbc:oracle:thin:@" + databaseInfoPO.getIpAddr() + ":" + databaseInfoPO.getPortNum() + "/" + databaseInfoPO.getServerName();
            }
            rfDataSourceBO.setDataSourceType(dataSourceType);
            rfDataSourceBO.setDataSourceUrl(dataSourceUrl);
            try {
                rfDataSourceBO.setPassword(ConfigTools.decrypt((String)databaseInfoPO.getUserPass()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rfDataSourceBO.setSysCode("data-center");
            rfDataSourceBO.setUserName(databaseInfoPO.getUserName());
            rfDataSourceBO.setDataSourceDesc(databaseInfoPO.getDatabaseName());
            rfDataSourceBO.setId(databaseInfoPO.getUnid());
            rfDataSourceBOList.add(rfDataSourceBO);
        }
        rspBO.setData(rfDataSourceBOList);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RspPage<RfDataSourceBO> queryRfDataSourceListPage(RfDataSourceReqBO rfDataSourceReqBO) {
        return null;
    }

    @Transactional
    public RfDataSourceRspBO addRfDataSource(RfDataSourceReqBO rfDataSourceReqBO) {
        if (StringUtils.isBlank((CharSequence)rfDataSourceReqBO.getSysCode())) {
            throw new ZTBusinessException("\u65b0\u589e\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)rfDataSourceReqBO.getDataSourceCode())) {
            throw new ZTBusinessException("\u65b0\u589e\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u6570\u636e\u6e90\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)rfDataSourceReqBO.getDataSourceName())) {
            throw new ZTBusinessException("\u65b0\u589e\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u6570\u636e\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)rfDataSourceReqBO.getDataSourceType())) {
            throw new ZTBusinessException("\u65b0\u589e\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u6570\u636e\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)rfDataSourceReqBO.getDataSourceUrl())) {
            throw new ZTBusinessException("\u65b0\u589e\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u6570\u636e\u6e90\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!("MYSQL".equals(rfDataSourceReqBO.getDataSourceType()) || "HDFS".equals(rfDataSourceReqBO.getDataSourceType()) || "ORACLE".equals(rfDataSourceReqBO.getDataSourceType()))) {
            throw new ZTBusinessException("\u65b0\u589e\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b");
        }
        RfSystemReqBO selectRfSystemReqBO = new RfSystemReqBO();
        selectRfSystemReqBO.setSysCode(rfDataSourceReqBO.getSysCode());
        RfSystemListRspBO rfSystemListRspBO = this.rfSystemService.queryRfSystemList(selectRfSystemReqBO);
        if (rfSystemListRspBO.getData() == null || rfSystemListRspBO.getData().size() == 0) {
            throw new ZTBusinessException("\u65b0\u589e\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u8be5\u7cfb\u7edf\u7f16\u7801\u7684\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        RfDataSourceReqBO selectRfDataSourceReqBO = new RfDataSourceReqBO();
        selectRfDataSourceReqBO.setSysCode(rfDataSourceReqBO.getSysCode());
        selectRfDataSourceReqBO.setDataSourceCode(rfDataSourceReqBO.getDataSourceCode());
        RfDataSourceListRspBO rfDataSourceListRspBO = this.queryRfDataSourceList(selectRfDataSourceReqBO);
        if (rfDataSourceListRspBO.getData() != null && rfDataSourceListRspBO.getData().size() > 0) {
            throw new ZTBusinessException("\u65b0\u589e\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u8be5\uff08\u7cfb\u7edf\u7f16\u7801+\u6570\u636e\u6e90\u7f16\u7801\uff09\u7684\u6570\u636e\u6e90\u4fe1\u606f\u5df2\u5b58\u5728");
        }
        RfDataSourceRspBO rspBO = new RfDataSourceRspBO();
        RfDataSourcePO insertRfDataSourcePO = new RfDataSourcePO();
        BeanUtils.copyProperties((Object)rfDataSourceReqBO, (Object)insertRfDataSourcePO);
        long id = Sequence.getInstance().nextId();
        insertRfDataSourcePO.setId(id);
        insertRfDataSourcePO.setCreateTime(new Date());
        int num = this.rfDataSourceMapper.insert(insertRfDataSourcePO);
        if (num != 1) {
            throw new ZTBusinessException("\u65b0\u589e\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u65b0\u589e\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25");
        }
        RfDataSourceBO RfDataSourceBO2 = new RfDataSourceBO();
        BeanUtils.copyProperties((Object)insertRfDataSourcePO, (Object)RfDataSourceBO2);
        rspBO.setData(RfDataSourceBO2);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @Transactional
    public RfDataSourceRspBO updateRfDataSource(RfDataSourceReqBO rfDataSourceReqBO) {
        RfDataSourcePO updateRfDataSourcePO;
        RfDataSourceRspBO rspBO = new RfDataSourceRspBO();
        RfDataSourcePO selectRfDataSourcePO = new RfDataSourcePO();
        selectRfDataSourcePO.setId(rfDataSourceReqBO.getId());
        List<RfDataSourcePO> rfDataSourceList = this.rfDataSourceMapper.selectByCondition(selectRfDataSourcePO);
        if (rfDataSourceList.size() == 1) {
            updateRfDataSourcePO = new RfDataSourcePO();
            BeanUtils.copyProperties((Object)rfDataSourceReqBO, (Object)updateRfDataSourcePO);
            int num = this.rfDataSourceMapper.update(updateRfDataSourcePO);
            if (num != 1) {
                throw new ZTBusinessException("\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (rfDataSourceList.size() > 1) {
                throw new ZTBusinessException("\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4fe1\u606f");
            }
            throw new ZTBusinessException("\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4fe1\u606f");
        }
        RfDataSourceBO rfDataSourceBO = new RfDataSourceBO();
        BeanUtils.copyProperties((Object)updateRfDataSourcePO, (Object)rfDataSourceBO);
        rspBO.setData(rfDataSourceBO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    @Transactional
    public RfDataSourceRspBO saveRfDataSource(RfDataSourceReqBO rfDataSourceReqBO) {
        if (rfDataSourceReqBO.getId() == null) {
            return this.addRfDataSource(rfDataSourceReqBO);
        }
        return this.updateRfDataSource(rfDataSourceReqBO);
    }

    @Transactional
    public RfDataSourceRspBO deleteRfDataSource(RfDataSourceReqBO rfDataSourceReqBO) {
        RfDataSourceRspBO rspBO = new RfDataSourceRspBO();
        RfDataSourcePO selectRfDataSourcePO = new RfDataSourcePO();
        selectRfDataSourcePO.setId(rfDataSourceReqBO.getId());
        List<RfDataSourcePO> rfDataSourceList = this.rfDataSourceMapper.selectByCondition(selectRfDataSourcePO);
        if (rfDataSourceList.size() == 1) {
            RfDataSourcePO deleteRfDataSourcePO = new RfDataSourcePO();
            BeanUtils.copyProperties((Object)rfDataSourceReqBO, (Object)deleteRfDataSourcePO);
            int num = this.rfDataSourceMapper.delete(deleteRfDataSourcePO);
            if (num != 1) {
                throw new ZTBusinessException("\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (rfDataSourceList.size() > 1) {
                throw new ZTBusinessException("\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4fe1\u606f");
            }
            throw new ZTBusinessException("\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4fe1\u606f");
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

