/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.ref.datax.job;

import com.alibaba.datax.core.Engine;
import com.alibaba.fastjson.JSON;
import com.yqsmartcity.data.ref.datax.job.DataxColumn;
import com.yqsmartcity.data.ref.datax.job.Hdfs2MysqlBO;
import com.yqsmartcity.data.ref.datax.job.Hdfs2OracleBO;
import com.yqsmartcity.data.ref.datax.job.Mysql2HdfsBO;
import com.yqsmartcity.data.ref.datax.job.Mysql2MysqlBO;
import com.yqsmartcity.data.ref.datax.job.MysqlReader;
import com.yqsmartcity.data.ref.datax.job.MysqlWriter;
import com.yqsmartcity.data.ref.db.RefSequence;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DataxJobWriterBuilder {
    @Value(value="${datax.bin.home:D:\\datax}")
    private String dataxPath;
    @Value(value="${job.File.Path:job}")
    private String jobFilePath;

    public String getJobPath() {
        StringBuilder pathSb = new StringBuilder();
        String nowDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
        pathSb = "#".equals(this.jobFilePath) ? pathSb.append("src").append(File.separator).append("main").append(File.separator).append("resources").append(File.separator).append("mappers/job").append(File.separator).append(nowDate) : pathSb.append(this.jobFilePath).append(File.separator).append(nowDate);
        return pathSb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJobFile(String path, String fileName, String content) throws IOException {
        File file;
        File fileDir = new File(path);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        if (!(file = new File(path + File.separator + fileName)).exists()) {
            file.createNewFile();
        }
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(file);
            bw = new BufferedWriter(fw);
            bw.write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            bw.close();
            fw.close();
        }
    }

    public String parseContent(Mysql2MysqlBO mysql2MysqlBO) {
        String content = JSON.toJSONString((Object)mysql2MysqlBO, (boolean)true);
        return content.replaceAll("\"column\":\\[\\]", "\"column\":\\[\"*\"\\]");
    }

    public String parseContent(Mysql2HdfsBO mysql2HdfsBO) {
        String content = JSON.toJSONString((Object)mysql2HdfsBO, (boolean)true);
        return content.replaceAll("\"column\":\\[\\]", "\"column\":\\[\"*\"\\]");
    }

    public String parseContent(Hdfs2MysqlBO hdfs2MysqlBO) {
        String content = JSON.toJSONString((Object)hdfs2MysqlBO, (boolean)true);
        return content.replaceAll("\"column\":\\[\\]", "\"column\":\\[\"*\"\\]");
    }

    public String parseContent(Hdfs2OracleBO hdfs2OracleBO) {
        String content = JSON.toJSONString((Object)hdfs2OracleBO, (boolean)true);
        return content.replaceAll("\"column\":\\[\\]", "\"column\":\\[\"*\"\\]");
    }

    public void executeJob(String jsonPath, String jobId) throws Throwable {
        System.setProperty("datax.home", this.dataxPath);
        String[] datxArgs = new String[]{"-job", jsonPath, "-mode", "standalone", "-jobid", "-1"};
        Engine.entry((String[])datxArgs);
    }

    @Test
    public void test() {
        String path = this.getJobPath();
        try {
            String fileName = "J" + RefSequence.getInstance().nextId() + ".json";
            System.out.println("path=" + path);
            System.out.println("fileName=" + fileName);
            Mysql2MysqlBO mysql2MysqlBO = new Mysql2MysqlBO();
            MysqlReader mysqlReader = new MysqlReader();
            mysqlReader.setReaderJdbcUrl("mysql:jdbc");
            MysqlWriter mysqlWriter = new MysqlWriter();
            mysqlWriter.setWriterJdbcUrl("mysql:jdbc2");
            ArrayList<DataxColumn> writerColumn = new ArrayList<DataxColumn>();
            DataxColumn writerColumnBO = new DataxColumn();
            writerColumnBO.setName("order_id");
            writerColumnBO.setType("INT");
            writerColumn.add(writerColumnBO);
            mysqlWriter.setWriterColumn(writerColumn);
            mysql2MysqlBO.init(mysqlReader, mysqlWriter);
            String content = this.parseContent(mysql2MysqlBO);
            System.out.println(content);
            this.createJobFile(path, fileName, content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void executeDatax() throws Throwable {
        System.setProperty("datax.home", "D:\\software\\datax");
        String[] datxArgs = new String[]{"-job", "D:\\software\\datax\\job\\J681949924089466880.json", "-mode", "standalone", "-jobid", "-1"};
        Engine.entry((String[])datxArgs);
    }
}

