/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.ref.datax.job;

import com.alibaba.fastjson.annotation.JSONField;
import com.yqsmartcity.data.ref.datax.job.DataxColumn;
import com.yqsmartcity.data.ref.datax.job.DataxJobWriterBuilder;
import com.yqsmartcity.data.ref.datax.job.HdfsWriter;
import com.yqsmartcity.data.ref.datax.job.MysqlReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public class Mysql2HdfsBO {
    @JSONField(serialize=false)
    private MysqlReader mysqlReader;
    @JSONField(serialize=false)
    private HdfsWriter hdfsWriter;
    private Job job = new Job();

    public void init(MysqlReader mysqlReader, HdfsWriter hdfsWriter) {
        this.mysqlReader = mysqlReader;
        this.hdfsWriter = hdfsWriter;
        this.job = new Job();
        this.job.init();
    }

    public void init() {
        this.mysqlReader = new MysqlReader();
        this.hdfsWriter = new HdfsWriter();
        this.job = new Job();
        this.job.init();
    }

    @Test
    public void test() {
        Mysql2HdfsBO mysql2HdfsBO = new Mysql2HdfsBO();
        MysqlReader mysqlReader = new MysqlReader();
        mysqlReader.setReaderJdbcUrl("mysql:jdbc");
        ArrayList<String> readerColumn = new ArrayList<String>();
        readerColumn.add("a1");
        readerColumn.add("b1");
        mysqlReader.setReaderColumn(readerColumn);
        HdfsWriter hdfsWriter = new HdfsWriter();
        hdfsWriter.setHaveKerberos(true);
        hdfsWriter.setKerberosKeytabFilePath("path");
        hdfsWriter.setKerberosPrincipal("acount");
        HashMap<String, String> hadoopConfig = new HashMap<String, String>();
        hadoopConfig.put("dfs.data.transfer.protection", "integrity");
        hdfsWriter.setHadoopConfig(hadoopConfig);
        mysql2HdfsBO.init(mysqlReader, hdfsWriter);
        System.out.println(new DataxJobWriterBuilder().parseContent(mysql2HdfsBO));
    }

    @Test
    public void subStr() {
        String str = "hdfs://39.106.248.178:9000/user/hive/warehouse/hive_datax_test.db/datax_ucc_test";
        System.out.println(str);
        Integer index = str.indexOf("/", 8);
        System.out.println(index);
        System.out.println(str.substring(index));
        System.out.println(str.substring(0, index));
    }

    public MysqlReader getMysqlReader() {
        return this.mysqlReader;
    }

    public HdfsWriter getHdfsWriter() {
        return this.hdfsWriter;
    }

    public Job getJob() {
        return this.job;
    }

    public void setMysqlReader(MysqlReader mysqlReader) {
        this.mysqlReader = mysqlReader;
    }

    public void setHdfsWriter(HdfsWriter hdfsWriter) {
        this.hdfsWriter = hdfsWriter;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Mysql2HdfsBO)) {
            return false;
        }
        Mysql2HdfsBO other = (Mysql2HdfsBO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MysqlReader this$mysqlReader = this.getMysqlReader();
        MysqlReader other$mysqlReader = other.getMysqlReader();
        if (this$mysqlReader == null ? other$mysqlReader != null : !((Object)this$mysqlReader).equals(other$mysqlReader)) {
            return false;
        }
        HdfsWriter this$hdfsWriter = this.getHdfsWriter();
        HdfsWriter other$hdfsWriter = other.getHdfsWriter();
        if (this$hdfsWriter == null ? other$hdfsWriter != null : !((Object)this$hdfsWriter).equals(other$hdfsWriter)) {
            return false;
        }
        Job this$job = this.getJob();
        Job other$job = other.getJob();
        return !(this$job == null ? other$job != null : !((Object)this$job).equals(other$job));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Mysql2HdfsBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MysqlReader $mysqlReader = this.getMysqlReader();
        result = result * 59 + ($mysqlReader == null ? 43 : ((Object)$mysqlReader).hashCode());
        HdfsWriter $hdfsWriter = this.getHdfsWriter();
        result = result * 59 + ($hdfsWriter == null ? 43 : ((Object)$hdfsWriter).hashCode());
        Job $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : ((Object)$job).hashCode());
        return result;
    }

    public String toString() {
        return "Mysql2HdfsBO(mysqlReader=" + this.getMysqlReader() + ", hdfsWriter=" + this.getHdfsWriter() + ", job=" + this.getJob() + ")";
    }

    public class Job {
        private Setting setting;
        private List<Content> content;

        public void init() {
            this.setting = new Setting();
            this.setting.init();
            this.content = new ArrayList<Content>();
            Content contentBO = new Content();
            contentBO.init();
            this.content.add(contentBO);
        }

        public Setting getSetting() {
            return this.setting;
        }

        public List<Content> getContent() {
            return this.content;
        }

        public void setSetting(Setting setting) {
            this.setting = setting;
        }

        public void setContent(List<Content> content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Job)) {
                return false;
            }
            Job other = (Job)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Setting this$setting = this.getSetting();
            Setting other$setting = other.getSetting();
            if (this$setting == null ? other$setting != null : !((Object)this$setting).equals(other$setting)) {
                return false;
            }
            List<Content> this$content = this.getContent();
            List<Content> other$content = other.getContent();
            return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Job;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Setting $setting = this.getSetting();
            result = result * 59 + ($setting == null ? 43 : ((Object)$setting).hashCode());
            List<Content> $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
            return result;
        }

        public String toString() {
            return "Mysql2HdfsBO.Job(setting=" + this.getSetting() + ", content=" + this.getContent() + ")";
        }

        public class Content {
            private Reader reader;
            private Writer writer;

            public void init() {
                this.reader = new Reader();
                this.reader.init();
                this.writer = new Writer();
                this.writer.init();
            }

            public Reader getReader() {
                return this.reader;
            }

            public Writer getWriter() {
                return this.writer;
            }

            public void setReader(Reader reader) {
                this.reader = reader;
            }

            public void setWriter(Writer writer) {
                this.writer = writer;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Content)) {
                    return false;
                }
                Content other = (Content)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Reader this$reader = this.getReader();
                Reader other$reader = other.getReader();
                if (this$reader == null ? other$reader != null : !((Object)this$reader).equals(other$reader)) {
                    return false;
                }
                Writer this$writer = this.getWriter();
                Writer other$writer = other.getWriter();
                return !(this$writer == null ? other$writer != null : !((Object)this$writer).equals(other$writer));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Content;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Reader $reader = this.getReader();
                result = result * 59 + ($reader == null ? 43 : ((Object)$reader).hashCode());
                Writer $writer = this.getWriter();
                result = result * 59 + ($writer == null ? 43 : ((Object)$writer).hashCode());
                return result;
            }

            public String toString() {
                return "Mysql2HdfsBO.Job.Content(reader=" + this.getReader() + ", writer=" + this.getWriter() + ")";
            }

            public class Writer {
                private String name;
                private Parameter parameter;

                public void init() {
                    this.name = Mysql2HdfsBO.this.hdfsWriter.getWriterName();
                    this.parameter = new Parameter();
                    this.parameter.init();
                }

                public String getName() {
                    return this.name;
                }

                public Parameter getParameter() {
                    return this.parameter;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setParameter(Parameter parameter) {
                    this.parameter = parameter;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Writer)) {
                        return false;
                    }
                    Writer other = (Writer)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    Parameter this$parameter = this.getParameter();
                    Parameter other$parameter = other.getParameter();
                    return !(this$parameter == null ? other$parameter != null : !((Object)this$parameter).equals(other$parameter));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Writer;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    Parameter $parameter = this.getParameter();
                    result = result * 59 + ($parameter == null ? 43 : ((Object)$parameter).hashCode());
                    return result;
                }

                public String toString() {
                    return "Mysql2HdfsBO.Job.Content.Writer(name=" + this.getName() + ", parameter=" + this.getParameter() + ")";
                }

                public class Parameter {
                    private String compress;
                    private String defaultFS;
                    private String fieldDelimiter;
                    private String fileName;
                    private String fileType;
                    private String path;
                    private String writeMode;
                    private List<DataxColumn> column;
                    private Boolean haveKerberos;
                    private String kerberosKeytabFilePath;
                    private String kerberosPrincipal;
                    private Map<String, String> hadoopConfig;

                    public void init() {
                        this.compress = Mysql2HdfsBO.this.hdfsWriter.getCompress();
                        this.defaultFS = Mysql2HdfsBO.this.hdfsWriter.getDefaultFS();
                        this.fieldDelimiter = Mysql2HdfsBO.this.hdfsWriter.getFieldDelimiter();
                        this.fileName = Mysql2HdfsBO.this.hdfsWriter.getFileName();
                        this.fileType = Mysql2HdfsBO.this.hdfsWriter.getFileType();
                        this.path = Mysql2HdfsBO.this.hdfsWriter.getPath();
                        this.writeMode = Mysql2HdfsBO.this.hdfsWriter.getWriteMode();
                        this.haveKerberos = Mysql2HdfsBO.this.hdfsWriter.getHaveKerberos();
                        this.kerberosKeytabFilePath = Mysql2HdfsBO.this.hdfsWriter.getKerberosKeytabFilePath();
                        this.kerberosPrincipal = Mysql2HdfsBO.this.hdfsWriter.getKerberosPrincipal();
                        this.hadoopConfig = Mysql2HdfsBO.this.hdfsWriter.getHadoopConfig();
                        this.column = Mysql2HdfsBO.this.hdfsWriter.getWriterColumn() == null || Mysql2HdfsBO.this.hdfsWriter.getWriterColumn().size() == 0 ? new ArrayList<DataxColumn>() : Mysql2HdfsBO.this.hdfsWriter.getWriterColumn();
                    }

                    public String getCompress() {
                        return this.compress;
                    }

                    public String getDefaultFS() {
                        return this.defaultFS;
                    }

                    public String getFieldDelimiter() {
                        return this.fieldDelimiter;
                    }

                    public String getFileName() {
                        return this.fileName;
                    }

                    public String getFileType() {
                        return this.fileType;
                    }

                    public String getPath() {
                        return this.path;
                    }

                    public String getWriteMode() {
                        return this.writeMode;
                    }

                    public List<DataxColumn> getColumn() {
                        return this.column;
                    }

                    public Boolean getHaveKerberos() {
                        return this.haveKerberos;
                    }

                    public String getKerberosKeytabFilePath() {
                        return this.kerberosKeytabFilePath;
                    }

                    public String getKerberosPrincipal() {
                        return this.kerberosPrincipal;
                    }

                    public Map<String, String> getHadoopConfig() {
                        return this.hadoopConfig;
                    }

                    public void setCompress(String compress) {
                        this.compress = compress;
                    }

                    public void setDefaultFS(String defaultFS) {
                        this.defaultFS = defaultFS;
                    }

                    public void setFieldDelimiter(String fieldDelimiter) {
                        this.fieldDelimiter = fieldDelimiter;
                    }

                    public void setFileName(String fileName) {
                        this.fileName = fileName;
                    }

                    public void setFileType(String fileType) {
                        this.fileType = fileType;
                    }

                    public void setPath(String path) {
                        this.path = path;
                    }

                    public void setWriteMode(String writeMode) {
                        this.writeMode = writeMode;
                    }

                    public void setColumn(List<DataxColumn> column) {
                        this.column = column;
                    }

                    public void setHaveKerberos(Boolean haveKerberos) {
                        this.haveKerberos = haveKerberos;
                    }

                    public void setKerberosKeytabFilePath(String kerberosKeytabFilePath) {
                        this.kerberosKeytabFilePath = kerberosKeytabFilePath;
                    }

                    public void setKerberosPrincipal(String kerberosPrincipal) {
                        this.kerberosPrincipal = kerberosPrincipal;
                    }

                    public void setHadoopConfig(Map<String, String> hadoopConfig) {
                        this.hadoopConfig = hadoopConfig;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Parameter)) {
                            return false;
                        }
                        Parameter other = (Parameter)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$compress = this.getCompress();
                        String other$compress = other.getCompress();
                        if (this$compress == null ? other$compress != null : !this$compress.equals(other$compress)) {
                            return false;
                        }
                        String this$defaultFS = this.getDefaultFS();
                        String other$defaultFS = other.getDefaultFS();
                        if (this$defaultFS == null ? other$defaultFS != null : !this$defaultFS.equals(other$defaultFS)) {
                            return false;
                        }
                        String this$fieldDelimiter = this.getFieldDelimiter();
                        String other$fieldDelimiter = other.getFieldDelimiter();
                        if (this$fieldDelimiter == null ? other$fieldDelimiter != null : !this$fieldDelimiter.equals(other$fieldDelimiter)) {
                            return false;
                        }
                        String this$fileName = this.getFileName();
                        String other$fileName = other.getFileName();
                        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                            return false;
                        }
                        String this$fileType = this.getFileType();
                        String other$fileType = other.getFileType();
                        if (this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType)) {
                            return false;
                        }
                        String this$path = this.getPath();
                        String other$path = other.getPath();
                        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                            return false;
                        }
                        String this$writeMode = this.getWriteMode();
                        String other$writeMode = other.getWriteMode();
                        if (this$writeMode == null ? other$writeMode != null : !this$writeMode.equals(other$writeMode)) {
                            return false;
                        }
                        List<DataxColumn> this$column = this.getColumn();
                        List<DataxColumn> other$column = other.getColumn();
                        if (this$column == null ? other$column != null : !((Object)this$column).equals(other$column)) {
                            return false;
                        }
                        Boolean this$haveKerberos = this.getHaveKerberos();
                        Boolean other$haveKerberos = other.getHaveKerberos();
                        if (this$haveKerberos == null ? other$haveKerberos != null : !((Object)this$haveKerberos).equals(other$haveKerberos)) {
                            return false;
                        }
                        String this$kerberosKeytabFilePath = this.getKerberosKeytabFilePath();
                        String other$kerberosKeytabFilePath = other.getKerberosKeytabFilePath();
                        if (this$kerberosKeytabFilePath == null ? other$kerberosKeytabFilePath != null : !this$kerberosKeytabFilePath.equals(other$kerberosKeytabFilePath)) {
                            return false;
                        }
                        String this$kerberosPrincipal = this.getKerberosPrincipal();
                        String other$kerberosPrincipal = other.getKerberosPrincipal();
                        if (this$kerberosPrincipal == null ? other$kerberosPrincipal != null : !this$kerberosPrincipal.equals(other$kerberosPrincipal)) {
                            return false;
                        }
                        Map<String, String> this$hadoopConfig = this.getHadoopConfig();
                        Map<String, String> other$hadoopConfig = other.getHadoopConfig();
                        return !(this$hadoopConfig == null ? other$hadoopConfig != null : !((Object)this$hadoopConfig).equals(other$hadoopConfig));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Parameter;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $compress = this.getCompress();
                        result = result * 59 + ($compress == null ? 43 : $compress.hashCode());
                        String $defaultFS = this.getDefaultFS();
                        result = result * 59 + ($defaultFS == null ? 43 : $defaultFS.hashCode());
                        String $fieldDelimiter = this.getFieldDelimiter();
                        result = result * 59 + ($fieldDelimiter == null ? 43 : $fieldDelimiter.hashCode());
                        String $fileName = this.getFileName();
                        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
                        String $fileType = this.getFileType();
                        result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
                        String $path = this.getPath();
                        result = result * 59 + ($path == null ? 43 : $path.hashCode());
                        String $writeMode = this.getWriteMode();
                        result = result * 59 + ($writeMode == null ? 43 : $writeMode.hashCode());
                        List<DataxColumn> $column = this.getColumn();
                        result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
                        Boolean $haveKerberos = this.getHaveKerberos();
                        result = result * 59 + ($haveKerberos == null ? 43 : ((Object)$haveKerberos).hashCode());
                        String $kerberosKeytabFilePath = this.getKerberosKeytabFilePath();
                        result = result * 59 + ($kerberosKeytabFilePath == null ? 43 : $kerberosKeytabFilePath.hashCode());
                        String $kerberosPrincipal = this.getKerberosPrincipal();
                        result = result * 59 + ($kerberosPrincipal == null ? 43 : $kerberosPrincipal.hashCode());
                        Map<String, String> $hadoopConfig = this.getHadoopConfig();
                        result = result * 59 + ($hadoopConfig == null ? 43 : ((Object)$hadoopConfig).hashCode());
                        return result;
                    }

                    public String toString() {
                        return "Mysql2HdfsBO.Job.Content.Writer.Parameter(compress=" + this.getCompress() + ", defaultFS=" + this.getDefaultFS() + ", fieldDelimiter=" + this.getFieldDelimiter() + ", fileName=" + this.getFileName() + ", fileType=" + this.getFileType() + ", path=" + this.getPath() + ", writeMode=" + this.getWriteMode() + ", column=" + this.getColumn() + ", haveKerberos=" + this.getHaveKerberos() + ", kerberosKeytabFilePath=" + this.getKerberosKeytabFilePath() + ", kerberosPrincipal=" + this.getKerberosPrincipal() + ", hadoopConfig=" + this.getHadoopConfig() + ")";
                    }
                }
            }

            public class Reader {
                private String name;
                private Parameter parameter;

                public void init() {
                    this.name = Mysql2HdfsBO.this.mysqlReader.getReaderName();
                    this.parameter = new Parameter();
                    this.parameter.init();
                }

                public String getName() {
                    return this.name;
                }

                public Parameter getParameter() {
                    return this.parameter;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setParameter(Parameter parameter) {
                    this.parameter = parameter;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Reader)) {
                        return false;
                    }
                    Reader other = (Reader)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    Parameter this$parameter = this.getParameter();
                    Parameter other$parameter = other.getParameter();
                    return !(this$parameter == null ? other$parameter != null : !((Object)this$parameter).equals(other$parameter));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Reader;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    Parameter $parameter = this.getParameter();
                    result = result * 59 + ($parameter == null ? 43 : ((Object)$parameter).hashCode());
                    return result;
                }

                public String toString() {
                    return "Mysql2HdfsBO.Job.Content.Reader(name=" + this.getName() + ", parameter=" + this.getParameter() + ")";
                }

                public class Parameter {
                    private List<String> column;
                    private List<Connection> connection;
                    private String username;
                    private String password;
                    private String where;

                    public void init() {
                        this.column = Mysql2HdfsBO.this.mysqlReader.getReaderColumn() == null || Mysql2HdfsBO.this.mysqlReader.getReaderColumn().size() == 0 ? new ArrayList<String>() : Mysql2HdfsBO.this.mysqlReader.getReaderColumn();
                        this.connection = new ArrayList<Connection>();
                        Connection connectionBO = new Connection();
                        connectionBO.init();
                        this.connection.add(connectionBO);
                        this.username = Mysql2HdfsBO.this.mysqlReader.getReaderUsername();
                        this.password = Mysql2HdfsBO.this.mysqlReader.getReaderPassword();
                        this.where = Mysql2HdfsBO.this.mysqlReader.getReaderWhere();
                    }

                    public List<String> getColumn() {
                        return this.column;
                    }

                    public List<Connection> getConnection() {
                        return this.connection;
                    }

                    public String getUsername() {
                        return this.username;
                    }

                    public String getPassword() {
                        return this.password;
                    }

                    public String getWhere() {
                        return this.where;
                    }

                    public void setColumn(List<String> column) {
                        this.column = column;
                    }

                    public void setConnection(List<Connection> connection) {
                        this.connection = connection;
                    }

                    public void setUsername(String username) {
                        this.username = username;
                    }

                    public void setPassword(String password) {
                        this.password = password;
                    }

                    public void setWhere(String where) {
                        this.where = where;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Parameter)) {
                            return false;
                        }
                        Parameter other = (Parameter)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        List<String> this$column = this.getColumn();
                        List<String> other$column = other.getColumn();
                        if (this$column == null ? other$column != null : !((Object)this$column).equals(other$column)) {
                            return false;
                        }
                        List<Connection> this$connection = this.getConnection();
                        List<Connection> other$connection = other.getConnection();
                        if (this$connection == null ? other$connection != null : !((Object)this$connection).equals(other$connection)) {
                            return false;
                        }
                        String this$username = this.getUsername();
                        String other$username = other.getUsername();
                        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                            return false;
                        }
                        String this$password = this.getPassword();
                        String other$password = other.getPassword();
                        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                            return false;
                        }
                        String this$where = this.getWhere();
                        String other$where = other.getWhere();
                        return !(this$where == null ? other$where != null : !this$where.equals(other$where));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Parameter;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        List<String> $column = this.getColumn();
                        result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
                        List<Connection> $connection = this.getConnection();
                        result = result * 59 + ($connection == null ? 43 : ((Object)$connection).hashCode());
                        String $username = this.getUsername();
                        result = result * 59 + ($username == null ? 43 : $username.hashCode());
                        String $password = this.getPassword();
                        result = result * 59 + ($password == null ? 43 : $password.hashCode());
                        String $where = this.getWhere();
                        result = result * 59 + ($where == null ? 43 : $where.hashCode());
                        return result;
                    }

                    public String toString() {
                        return "Mysql2HdfsBO.Job.Content.Reader.Parameter(column=" + this.getColumn() + ", connection=" + this.getConnection() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", where=" + this.getWhere() + ")";
                    }

                    public class Connection {
                        private List<String> jdbcUrl = new ArrayList<String>();
                        private List<String> table = new ArrayList<String>();

                        public void init() {
                            this.jdbcUrl = new ArrayList<String>();
                            this.table = new ArrayList<String>();
                            this.jdbcUrl.add(Mysql2HdfsBO.this.mysqlReader.getReaderJdbcUrl());
                            this.table.add(Mysql2HdfsBO.this.mysqlReader.getReaderTable());
                        }

                        public List<String> getJdbcUrl() {
                            return this.jdbcUrl;
                        }

                        public List<String> getTable() {
                            return this.table;
                        }

                        public void setJdbcUrl(List<String> jdbcUrl) {
                            this.jdbcUrl = jdbcUrl;
                        }

                        public void setTable(List<String> table) {
                            this.table = table;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Connection)) {
                                return false;
                            }
                            Connection other = (Connection)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            List<String> this$jdbcUrl = this.getJdbcUrl();
                            List<String> other$jdbcUrl = other.getJdbcUrl();
                            if (this$jdbcUrl == null ? other$jdbcUrl != null : !((Object)this$jdbcUrl).equals(other$jdbcUrl)) {
                                return false;
                            }
                            List<String> this$table = this.getTable();
                            List<String> other$table = other.getTable();
                            return !(this$table == null ? other$table != null : !((Object)this$table).equals(other$table));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof Connection;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            List<String> $jdbcUrl = this.getJdbcUrl();
                            result = result * 59 + ($jdbcUrl == null ? 43 : ((Object)$jdbcUrl).hashCode());
                            List<String> $table = this.getTable();
                            result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
                            return result;
                        }

                        public String toString() {
                            return "Mysql2HdfsBO.Job.Content.Reader.Parameter.Connection(jdbcUrl=" + this.getJdbcUrl() + ", table=" + this.getTable() + ")";
                        }
                    }
                }
            }
        }

        public class Setting {
            private Speed speed;

            public void init() {
                this.speed = new Speed();
                this.speed.init();
            }

            public Speed getSpeed() {
                return this.speed;
            }

            public void setSpeed(Speed speed) {
                this.speed = speed;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Setting)) {
                    return false;
                }
                Setting other = (Setting)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Speed this$speed = this.getSpeed();
                Speed other$speed = other.getSpeed();
                return !(this$speed == null ? other$speed != null : !((Object)this$speed).equals(other$speed));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Setting;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Speed $speed = this.getSpeed();
                result = result * 59 + ($speed == null ? 43 : ((Object)$speed).hashCode());
                return result;
            }

            public String toString() {
                return "Mysql2HdfsBO.Job.Setting(speed=" + this.getSpeed() + ")";
            }

            public class Speed {
                private Integer channel;

                public void init() {
                    this.channel = 1;
                }

                public Integer getChannel() {
                    return this.channel;
                }

                public void setChannel(Integer channel) {
                    this.channel = channel;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Speed)) {
                        return false;
                    }
                    Speed other = (Speed)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Integer this$channel = this.getChannel();
                    Integer other$channel = other.getChannel();
                    return !(this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Speed;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Integer $channel = this.getChannel();
                    result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
                    return result;
                }

                public String toString() {
                    return "Mysql2HdfsBO.Job.Setting.Speed(channel=" + this.getChannel() + ")";
                }
            }
        }
    }
}

