/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.ref.db;

import com.alibaba.druid.pool.DruidDataSource;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.ref.ability.bo.RefRspBaseAbilityBO;
import com.yqsmartcity.data.ref.ability.bo.RfCreateTableReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfDataSourceBO;
import com.yqsmartcity.data.ref.ability.bo.RfFieldBO;
import com.yqsmartcity.data.ref.ability.bo.RfTableColumnRspBO;
import com.yqsmartcity.data.ref.ability.bo.RfTableRspBO;
import com.yqsmartcity.data.ref.db.HiveDruidTemplate;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.stereotype.Component;

@Component
public class CommDruidTemplate {
    private static final Logger log = LoggerFactory.getLogger(CommDruidTemplate.class);
    @Autowired
    HiveDruidTemplate hiveDruidTemplate;
    @Value(value="${comm.initialSize:1}")
    private Integer initialSize;
    @Value(value="${comm.minIdle:3}")
    private Integer minIdle;
    @Value(value="${comm.maxActive:20}")
    private Integer maxActive;
    @Value(value="${comm.maxWait:60000}")
    private Integer maxWait;
    @Value(value="${comm.timeBetweenEvictionRunsMillis:60000}")
    private Integer timeBetweenEvictionRunsMillis;
    @Value(value="${comm.minEvictableIdleTimeMillis:30000}")
    private Integer minEvictableIdleTimeMillis;
    @Value(value="${comm.validationQuery:select 1}")
    private String validationQuery;
    @Value(value="${comm.testWhileIdle:true}")
    private boolean testWhileIdle;
    @Value(value="${comm.testOnBorrow:false}")
    private boolean testOnBorrow;
    @Value(value="${comm.testOnReturn:false}")
    private boolean testOnReturn;
    @Value(value="${comm.poolPreparedStatements:true}")
    private boolean poolPreparedStatements;
    @Value(value="${comm.maxPoolPreparedStatementPerConnectionSize:20}")
    private Integer maxPoolPreparedStatementPerConnectionSize;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JdbcTemplate createNewJdbcTemplate(RfDataSourceBO rfDataSourceBO) {
        try (DruidDataSource datasource = new DruidDataSource();){
            if (!"MYSQL".equals(rfDataSourceBO.getDataSourceType())) {
                if (!"HDFS".equals(rfDataSourceBO.getDataSourceType())) throw new ZTBusinessException("\u521b\u5efa\u6570\u636e\u6e90\u5931\u8d25\uff1a\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b");
                JdbcTemplate jdbcTemplate = this.hiveDruidTemplate.createNewJdbcTemplate();
                return jdbcTemplate;
            }
            datasource.setDriverClassName("com.mysql.jdbc.Driver");
            if (!rfDataSourceBO.getDataSourceUrl().contains("?")) {
                rfDataSourceBO.setDataSourceUrl(rfDataSourceBO.getDataSourceUrl() + "?useSSL=false");
            }
            datasource.setUrl(rfDataSourceBO.getDataSourceUrl());
            datasource.setUsername(rfDataSourceBO.getUserName());
            datasource.setPassword(rfDataSourceBO.getPassword());
            datasource.setInitialSize(this.initialSize.intValue());
            datasource.setMinIdle(this.minIdle.intValue());
            datasource.setMaxActive(this.maxActive.intValue());
            datasource.setMaxWait((long)this.maxWait.intValue());
            datasource.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis.intValue());
            datasource.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis.intValue());
            datasource.setValidationQuery(this.validationQuery);
            datasource.setTestWhileIdle(this.testWhileIdle);
            datasource.setTestOnBorrow(this.testOnBorrow);
            datasource.setTestOnReturn(this.testOnReturn);
            datasource.setPoolPreparedStatements(this.poolPreparedStatements);
            datasource.setMaxPoolPreparedStatementPerConnectionSize(this.maxPoolPreparedStatementPerConnectionSize.intValue());
            JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)datasource);
            return jdbcTemplate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void executeSql(RfDataSourceBO rfDataSourceBO, final String sql) {
        log.info("Running: " + sql);
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            final JdbcTemplate jdbcTemplate = this.createNewJdbcTemplate(rfDataSourceBO);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            String[] sqls = sql.split(";");
                            for (int i = 0; i < sqls.length; ++i) {
                                if (!StringUtils.isNotBlank((CharSequence)sqls[i])) continue;
                                jdbcTemplate.execute(sqls[i]);
                            }
                        }
                        catch (DataAccessException dae) {
                            if (dae.getMessage().contains("code 2")) break block3;
                            String result = "executeSql encounter an error: " + dae.getMessage();
                            log.error(result);
                        }
                    }
                }
            });
            t.start();
        } else {
            log.error("Running failed: sql\u4e3a\u7a7a");
        }
    }

    public RefRspBaseAbilityBO executeSqlWithoutThread(RfDataSourceBO rfDataSourceBO, String sql) {
        RefRspBaseAbilityBO rspBO = new RefRspBaseAbilityBO();
        log.info("Running: " + sql);
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            JdbcTemplate jdbcTemplate = this.createNewJdbcTemplate(rfDataSourceBO);
            try {
                String[] sqls = sql.split(";");
                for (int i = 0; i < sqls.length; ++i) {
                    if (!StringUtils.isNotBlank((CharSequence)sqls[i])) continue;
                    jdbcTemplate.execute(sqls[i]);
                }
            }
            catch (DataAccessException dae) {
                if (dae.getMessage().contains("code 2")) {
                    rspBO.setRespDesc("\u6210\u529f");
                    rspBO.setRespCode("0000");
                    return rspBO;
                }
                String result = "executeSql encounter an error: " + dae.getMessage();
                log.error(result);
                rspBO.setRespDesc(dae.getMessage());
                rspBO.setRespCode("8888");
                return rspBO;
            }
        } else {
            log.error("Running failed: sql\u4e3a\u7a7a");
            rspBO.setRespDesc("Running failed: sql\u4e3a\u7a7a");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RfTableColumnRspBO getTableColumns(RfDataSourceBO rfDataSourceBO, String tableName) {
        if (StringUtils.isBlank((CharSequence)tableName)) {
            throw new ZTBusinessException("\u67e5\u8be2\u8868\u5217\u4fe1\u606f\u5931\u8d25\uff1a\u8868\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RfTableColumnRspBO rspBO = new RfTableColumnRspBO();
        try {
            if ("MYSQL".equals(rfDataSourceBO.getDataSourceType())) {
                ArrayList<RfFieldBO> list = new ArrayList<RfFieldBO>();
                JdbcTemplate jdbcTemplate = this.createNewJdbcTemplate(rfDataSourceBO);
                String sql = "select * from " + tableName + " limit 0";
                SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet(sql);
                SqlRowSetMetaData sqlRowSetMetaData = sqlRowSet.getMetaData();
                int columnCount = sqlRowSetMetaData.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    RfFieldBO rfFieldBO = new RfFieldBO();
                    int index = sqlRowSetMetaData.getColumnName(i).indexOf(".") + 1;
                    rfFieldBO.setFieldName(sqlRowSetMetaData.getColumnName(i).substring(index));
                    rfFieldBO.setFieldType(sqlRowSetMetaData.getColumnTypeName(i));
                    list.add(rfFieldBO);
                }
                rspBO.setData(list);
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setRespCode("0000");
            } else if ("HDFS".equals(rfDataSourceBO.getDataSourceType())) {
                return this.hiveDruidTemplate.getTableColumns(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Running failed: \u83b7\u53d6\u8868\u5b57\u6bb5\u5217\u8868\u5931\u8d25");
            rspBO.setRespDesc("Running failed: \u83b7\u53d6\u8868\u5b57\u6bb5\u5217\u8868\u5931\u8d25");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        return rspBO;
    }

    public RfTableRspBO getTables(RfDataSourceBO rfDataSourceBO) {
        RfTableRspBO rspBO = new RfTableRspBO();
        JdbcTemplate jdbcTemplate = this.createNewJdbcTemplate(rfDataSourceBO);
        String sql = "show tables";
        try {
            List tables = jdbcTemplate.queryForList(sql, String.class);
            rspBO.setTables(tables);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Running failed: \u83b7\u53d6\u8868\u5217\u8868\u5931\u8d25");
            rspBO.setRespDesc("Running failed: \u83b7\u53d6\u8868\u5217\u8868\u5931\u8d25");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public RefRspBaseAbilityBO createTables(RfDataSourceBO rfDataSourceBO, RfCreateTableReqBO rfCreateTableReqBO) {
        if (rfCreateTableReqBO.getFieldList() == null || rfCreateTableReqBO.getFieldList().size() == 0) {
            throw new ZTBusinessException("\u521b\u5efa\u8868\u5931\u8d25\uff1a\u8868\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RfTableRspBO rfTableRspBO = this.getTables(rfDataSourceBO);
        if (rfTableRspBO.getTables() != null && rfTableRspBO.getTables().contains(rfCreateTableReqBO.getTableName())) {
            throw new ZTBusinessException("\u521b\u5efa\u8868\u5931\u8d25\uff1a" + rfCreateTableReqBO.getTableName() + "\u8868\u5df2\u7ecf\u5b58\u5728");
        }
        String fieldType = "";
        if ("MYSQL".equals(rfDataSourceBO.getDataSourceType())) {
            fieldType = "VARCHAR(128)";
        } else if ("HDFS".equals(rfDataSourceBO.getDataSourceType())) {
            fieldType = "string";
        } else {
            throw new ZTBusinessException("\u521b\u5efa\u8868\u5931\u8d25\uff1a\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b");
        }
        StringBuffer sb = new StringBuffer();
        List fieldList = rfCreateTableReqBO.getFieldList();
        sb.append("create table ").append(rfCreateTableReqBO.getTableName()).append("(").append("\n ");
        for (int i = 0; i < fieldList.size(); ++i) {
            sb.append((String)fieldList.get(i)).append(" ").append(fieldType);
            if (i != fieldList.size() - 1) {
                sb.append(",");
            }
            sb.append("\n");
        }
        if ("MYSQL".equals(rfDataSourceBO.getDataSourceType())) {
            sb.append(")").append("\n ");
            sb.append("ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;");
        } else if ("HDFS".equals(rfDataSourceBO.getDataSourceType())) {
            sb.append(")").append("\n ");
            sb.append("row format delimited").append("\n ");
            sb.append(";");
        } else {
            throw new ZTBusinessException("\u521b\u5efa\u8868\u5931\u8d25\uff1a\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b");
        }
        String sql = sb.toString();
        return this.executeSqlWithoutThread(rfDataSourceBO, sql);
    }
}

