/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.constant;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.SFTPv3Client;
import ch.ethz.ssh2.SFTPv3FileAttributes;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import com.yqsmartcity.data.swap.api.bo.RemoteConnectBO;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectLinuxCommand {
    private static final Logger logger = LoggerFactory.getLogger(ConnectLinuxCommand.class);
    private static String DEFAULTCHARTSET = "UTF-8";
    private static Connection conn;

    public static Boolean login(RemoteConnectBO remoteConnect) {
        boolean flag = false;
        try {
            conn = new Connection(remoteConnect.getIp(), remoteConnect.getPort());
            conn.connect();
            flag = conn.authenticateWithPassword(remoteConnect.getUserName(), remoteConnect.getPassword());
            if (flag) {
                logger.info("\u8ba4\u8bc1\u6210\u529f\uff01");
            } else {
                logger.info("\u8ba4\u8bc1\u5931\u8d25\uff01");
                conn.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static void logOut() {
        conn.close();
        logger.info("\u9000\u51fa\u6210\u529f\uff01");
    }

    public static Boolean loginByFileKey(RemoteConnectBO remoteConnect, File keyFile, String keyfilePass) {
        boolean flag = false;
        try {
            conn = new Connection(remoteConnect.getIp());
            conn.connect();
            flag = conn.authenticateWithPublicKey(remoteConnect.getUserName(), keyFile, keyfilePass);
            if (flag) {
                logger.info("\u8ba4\u8bc1\u6210\u529f\uff01");
            } else {
                logger.info("\u8ba4\u8bc1\u5931\u8d25\uff01");
                conn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static Boolean loginByCharsKey(RemoteConnectBO remoteConnect, char[] keys, String keyPass) {
        boolean flag = false;
        File keyfile = new File("C:\\temp\\private");
        try {
            conn = new Connection(remoteConnect.getIp());
            conn.connect();
            flag = conn.authenticateWithPublicKey(remoteConnect.getUserName(), keys, keyPass);
            if (flag) {
                logger.info("\u8ba4\u8bc1\u6210\u529f\uff01");
            } else {
                logger.info("\u8ba4\u8bc1\u5931\u8d25\uff01");
                conn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static String execute(String cmd) {
        String result = "";
        try {
            Session session = conn.openSession();
            session.execCommand(cmd);
            result = ConnectLinuxCommand.processStdout(session.getStdout(), DEFAULTCHARTSET);
            if (StringUtils.isBlank((String)result)) {
                result = ConnectLinuxCommand.processStdout(session.getStderr(), DEFAULTCHARTSET);
            }
            conn.close();
            session.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String executeSuccess(String cmd) {
        String result = "";
        try {
            Session session = conn.openSession();
            session.execCommand(cmd);
            result = ConnectLinuxCommand.processStdout(session.getStdout(), DEFAULTCHARTSET);
            conn.close();
            session.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String processStdout(InputStream in, String charset) {
        StreamGobbler stdout = new StreamGobbler(in);
        StringBuffer buffer = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)stdout, charset));
            String line = null;
            while ((line = br.readLine()) != null) {
                buffer.append(line + "\n");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public static boolean connectLinux(String ip, String userName, String password, String commandStr) {
        logger.info("ConnectLinuxCommand  scpGet===ip:" + ip + "  userName:" + userName + "  commandStr:" + commandStr);
        String returnStr = "";
        boolean result = true;
        RemoteConnectBO remoteConnect = new RemoteConnectBO();
        remoteConnect.setIp(ip);
        remoteConnect.setUserName(userName);
        remoteConnect.setPassword(password);
        try {
            if (ConnectLinuxCommand.login(remoteConnect).booleanValue()) {
                returnStr = ConnectLinuxCommand.execute(commandStr);
                System.out.println(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isBlank((String)returnStr)) {
            result = false;
        }
        return result;
    }

    public static void scpGet(String ip, String userName, String password, String remoteFile, String localDir) throws IOException {
        logger.info("ConnectLinuxCommand  scpGet===ip:" + ip + "  userName:" + userName + "  remoteFile:" + remoteFile + "  localDir:" + localDir);
        RemoteConnectBO remoteConnect = new RemoteConnectBO();
        remoteConnect.setIp(ip);
        remoteConnect.setUserName(userName);
        remoteConnect.setPassword(password);
        if (ConnectLinuxCommand.login(remoteConnect).booleanValue()) {
            SCPClient client = new SCPClient(conn);
            client.get(remoteFile, localDir);
            conn.close();
        }
    }

    public static void scpPut(String localFile, String remoteDir) throws IOException {
        SFTPv3Client sftpv3Client = new SFTPv3Client(conn);
        Boolean result = ConnectLinuxCommand.isDir(sftpv3Client, remoteDir);
        if (!result.booleanValue()) {
            sftpv3Client.mkdir(remoteDir, 493);
        }
        SCPClient client = new SCPClient(conn);
        client.put(localFile, remoteDir);
    }

    public static Boolean isDir(SFTPv3Client sftpv3Client, String path) {
        if (sftpv3Client != null && path != null && !"".equals(path)) {
            SFTPv3FileAttributes sFTPv3FileAttributes;
            try {
                sFTPv3FileAttributes = sftpv3Client.lstat(path);
            }
            catch (IOException e) {
                System.out.println("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff1a" + e.getLocalizedMessage());
                return false;
            }
            return sFTPv3FileAttributes.isDirectory();
        }
        return false;
    }

    @Test
    public void testDemo3() {
        try {
            RemoteConnectBO remoteConnect = new RemoteConnectBO();
            remoteConnect.setIp("10.10.101.6");
            remoteConnect.setUserName("admin");
            remoteConnect.setPassword("lNyHwJ%qFg9@Admin");
            ConnectLinuxCommand.login(remoteConnect);
            ConnectLinuxCommand.scpPut("D:\\work\\prog\\data-center\\azkaban_conf_file\\20200708\\zdc\\sql\\da_szwb_ms1_y_accept_base_info_sum.sql", "/middleware/datax/json_file/");
            ConnectLinuxCommand.logOut();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testDemo4() {
        try {
            RemoteConnectBO remoteConnect = new RemoteConnectBO();
            remoteConnect.setIp("10.10.101.6");
            remoteConnect.setUserName("admin");
            File keyFile = new File("D:\\id_rsa");
            String keyfilePass = null;
            Boolean result = ConnectLinuxCommand.loginByFileKey(remoteConnect, keyFile, keyfilePass);
            logger.info(result.toString());
            SFTPv3Client sftpv3Client = new SFTPv3Client(conn);
            Boolean result2 = ConnectLinuxCommand.isDir(sftpv3Client, "/middleware/datax/json_file1/");
            logger.info(result2.toString());
            ConnectLinuxCommand.scpPut("D:\\da_swbw_ms0_y_governance_area_code_ad.sql", "/middleware/datax/json_file1/");
            ConnectLinuxCommand.logOut();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

