/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.constant;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class FileZipUtilTools {
    private static final int BUFFER_SIZE = 2048;

    public static void toZip(File sourceFile, OutputStream out, boolean KeepDirStructure) throws RuntimeException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(out);
            FileZipUtilTools.compress(sourceFile, zos, sourceFile.getName(), KeepDirStructure);
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void toZip(List<File> srcFiles, OutputStream out) throws RuntimeException {
        long start = System.currentTimeMillis();
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(out);
            for (File srcFile : srcFiles) {
                int len;
                byte[] buf = new byte[2048];
                zos.putNextEntry(new ZipEntry(srcFile.getName()));
                FileInputStream in = new FileInputStream(srcFile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            }
            long end = System.currentTimeMillis();
            System.out.println("\u538b\u7f29\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (end - start) + " ms");
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean KeepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            zos.putNextEntry(new ZipEntry(name));
            try (FileInputStream in = new FileInputStream(sourceFile);){
                int len;
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
            }
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (KeepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (KeepDirStructure) {
                        FileZipUtilTools.compress(file, zos, name + "/" + file.getName(), KeepDirStructure);
                        continue;
                    }
                    FileZipUtilTools.compress(file, zos, file.getName(), KeepDirStructure);
                }
            }
        }
    }

    public static void txtFile(StringBuffer odpsSql, String path, String fileName) {
        try {
            path = path.replace("\\", "/");
            File writename = new File(path);
            if (!writename.exists()) {
                writename.mkdirs();
            }
            writename = new File(path + "/" + fileName);
            writename.createNewFile();
            try (BufferedWriter out = new BufferedWriter(new FileWriter(writename));){
                out.write(odpsSql.toString());
                out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void xmlFile(String document, String path, String fileName) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            File writename = new File(path);
            if (!writename.exists()) {
                writename.mkdirs();
            }
            File file = new File(path + "/" + fileName);
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(file), format);
            writer.setEscapeText(false);
            writer.write(DocumentHelper.parseText((String)document));
            writer.close();
            System.out.println("\u751f\u6210.xml\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileZipUtilTools.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

