/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.controller.dept;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapQrySysParaListReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapQrySysParaListRspBO;
import com.yqsmartcity.data.swap.api.base.bo.SysParaBO;
import com.yqsmartcity.data.swap.api.base.service.SwapQrySysParaListBusiService;
import com.yqsmartcity.data.swap.api.dept.bo.ResourceSystemInfoBO;
import com.yqsmartcity.data.swap.api.dept.bo.SwapResourceSystemListReqBO;
import com.yqsmartcity.data.swap.api.dept.bo.SwapResourceSystemListRspBO;
import com.yqsmartcity.data.swap.api.dept.service.SwapRecourceSystemListService;
import java.util.ArrayList;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/swap-api/data/dept"})
public class SwapResourceSystemListController {
    @Value(value="${is.rely.recource}")
    private String isRelyRecource;
    @Autowired
    private SwapRecourceSystemListService swapRecourceSystemListService;
    @Autowired
    private SwapQrySysParaListBusiService swapQrySysParaListBusiService;

    @RequestMapping(value={"/qryRecourceSystemList"}, method={RequestMethod.POST})
    @BusiResponseBody
    public SwapResourceSystemListRspBO qryRecourceSystemList(@Valid SwapResourceSystemListReqBO reqBO, BindingResult result) {
        SwapResourceSystemListRspBO swapResourceSystemListRspBO = new SwapResourceSystemListRspBO();
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        if ("2".equalsIgnoreCase(this.isRelyRecource)) {
            swapResourceSystemListRspBO = this.swapRecourceSystemListService.recourceSystemList(reqBO);
        } else {
            SwapQrySysParaListReqBO swapQrySystemListReqBO = new SwapQrySysParaListReqBO();
            swapQrySystemListReqBO.setParaType(reqBO.getDeptNo());
            SwapQrySysParaListRspBO swapQrySystemListRspBO = this.swapQrySysParaListBusiService.qrySysParaList(swapQrySystemListReqBO);
            if (null != swapQrySystemListRspBO) {
                ArrayList<ResourceSystemInfoBO> resourceSystemInfoBOList = new ArrayList<ResourceSystemInfoBO>();
                for (SysParaBO systemInfoBO : swapQrySystemListRspBO.getSysParaBOList()) {
                    ResourceSystemInfoBO sesourceSystemInfoBO = new ResourceSystemInfoBO();
                    sesourceSystemInfoBO.setSystemId(systemInfoBO.getParaCode());
                    sesourceSystemInfoBO.setSysName(systemInfoBO.getParaName());
                    resourceSystemInfoBOList.add(sesourceSystemInfoBO);
                }
                swapResourceSystemListRspBO.setResourceSystemInfoBOList(resourceSystemInfoBOList);
            }
        }
        return swapResourceSystemListRspBO;
    }
}

