/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.controller.odps;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileRspBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.ScriptDownloadRspBO;
import com.yqsmartcity.data.swap.api.taskpublish.bo.QryPublishFileReqBO;
import com.yqsmartcity.data.swap.api.taskpublish.service.SwapQryPublishFileService;
import com.yqsmartcity.data.swap.constant.FileZipUtilTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/swap-api/data/task"})
public class SwapShareZipDownloadController {
    private static final Logger logger = LoggerFactory.getLogger(SwapShareZipDownloadController.class);
    @Autowired
    private SwapQryPublishFileService swapQryPublishFileService;
    @Value(value="${zip.file.path}")
    private String zipFilePath;

    @RequestMapping(value={"/shareZipDownload"}, method={RequestMethod.GET})
    @BusiResponseBody
    public Object zipDownload(@Valid QryPublishFileReqBO reqBO, BindingResult result, HttpServletResponse response) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        ScriptDownloadRspBO scriptDownloadRspBO = this.swapQryPublishFileService.qryPublishFile(reqBO);
        Date sysDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String dateString = "temp_" + format.format(sysDate);
        String zipFileName = "";
        for (CreateImportFileRspBO createImportFileRspBO : scriptDownloadRspBO.getCreateImportFileRspBOList()) {
            for (CreateImportFileBO createImportFileBO : createImportFileRspBO.getReateImportFileBO()) {
                logger.info("------createImportFileBO.getFilePath()=" + createImportFileBO.getFilePath());
                if ("txt".equalsIgnoreCase(createImportFileBO.getFileType())) {
                    FileZipUtilTools.txtFile(createImportFileBO.getFileContent(), this.zipFilePath + "/" + dateString + "/" + createImportFileRspBO.getZipName() + "/" + createImportFileBO.getFilePath(), createImportFileBO.getFileName());
                    continue;
                }
                if (!"xml".equalsIgnoreCase(createImportFileBO.getFileType())) continue;
                FileZipUtilTools.xmlFile(createImportFileBO.getFileContent().toString(), this.zipFilePath + "/" + dateString + "/" + createImportFileRspBO.getZipName() + "/" + createImportFileBO.getFilePath(), createImportFileBO.getFileName());
            }
            SwapShareZipDownloadController.zipFile(this.zipFilePath + "/" + dateString + "/" + createImportFileRspBO.getZipName());
            zipFileName = createImportFileRspBO.getZipName();
            FileZipUtilTools.deleteDir(new File(this.zipFilePath + "/" + dateString + "/" + createImportFileRspBO.getZipName()));
        }
        String zipTypePath = "/" + dateString;
        SwapShareZipDownloadController.zipFile(this.zipFilePath + "/" + dateString);
        zipTypePath = "";
        zipFileName = dateString;
        response.setHeader("Content-Disposition", "attachment; filename=" + zipFileName + ".zip");
        try {
            ServletOutputStream output = response.getOutputStream();
            File zipFile = new File(this.zipFilePath + zipTypePath + "/" + zipFileName + ".zip");
            try (FileInputStream fileStream = new FileInputStream(zipFile);){
                byte[] buf = new byte[1024];
                int r = 0;
                while ((r = fileStream.read(buf)) != -1) {
                    output.write(buf);
                }
                zipFile.delete();
                output.flush();
            }
        }
        catch (IOException e) {
            throw new ZTBusinessException("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff01");
        }
        FileZipUtilTools.deleteDir(new File(this.zipFilePath + zipTypePath));
        return 1;
    }

    private static void zipFile(String filePath) throws ZTBusinessException {
        try {
            FileOutputStream fos1 = new FileOutputStream(new File(filePath + ".zip"));
            FileZipUtilTools.toZip(new File(filePath), fos1, true);
        }
        catch (FileNotFoundException e) {
            throw new ZTBusinessException(e.getLocalizedMessage());
        }
    }
}

