/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.controller.table;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.azkaban.service.CreateAzkabanConfFileService;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileRspBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.ScriptDownloadReqBO;
import com.yqsmartcity.data.swap.api.oozie.service.CreateOozieConfFileService;
import com.yqsmartcity.data.swap.constant.FileZipUtilTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/swap-api/data/cleanrule"})
public class CreateLocalFileController {
    private static final Logger logger = LoggerFactory.getLogger(CreateLocalFileController.class);
    @Autowired
    private CreateAzkabanConfFileService createAzkabanConfFileService;
    @Autowired
    private CreateOozieConfFileService createOozieConfFileService;
    @Value(value="${zip.file.path}")
    private String zipFilePath;

    @RequestMapping(value={"/localFile"}, method={RequestMethod.POST})
    @BusiResponseBody
    public List<CreateImportFileRspBO> zipDownload(@Valid ScriptDownloadReqBO reqBO, BindingResult result, HttpServletResponse response) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        List scriptDownloadRspBO = this.createOozieConfFileService.createOozieConf(reqBO);
        return scriptDownloadRspBO;
    }

    private static void zipFile(String filePath) throws ZTBusinessException {
        try {
            FileOutputStream fos1 = new FileOutputStream(new File(filePath + ".zip"));
            FileZipUtilTools.toZip(new File(filePath), fos1, true);
        }
        catch (FileNotFoundException e) {
            throw new ZTBusinessException(e.getLocalizedMessage());
        }
    }
}

