/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.azkaban;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.azkaban.bo.GetFileStringBufferBO;
import com.yqsmartcity.data.swap.api.azkaban.service.CreateAzkabanConfFileService;
import com.yqsmartcity.data.swap.api.azkaban.service.SwapGetAzkabanJobService;
import com.yqsmartcity.data.swap.api.dataX.service.SwapGetDataXJsonService;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileListReqBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileReqBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileRspBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.ScriptDownloadReqBO;
import com.yqsmartcity.data.swap.api.hivedb.GoveGetHiveSumStringService;
import com.yqsmartcity.data.swap.api.hivedb.SwapGetHiveDDlStringService;
import com.yqsmartcity.data.swap.api.hivedb.SwapHiveIncrementTranService;
import com.yqsmartcity.data.swap.dao.DataWorksDao;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.dao.TaskPublishFileMapper;
import com.yqsmartcity.data.swap.dao.TaskPublishMapper;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import com.yqsmartcity.data.swap.po.TaskPublishFilePO;
import com.yqsmartcity.data.swap.po.TaskPublishPO;
import com.yqsmartcity.data.swap.service.busi.impl.azkaban.SwapGetAzkabanShellServiceimpl;
import com.yqsmartcity.data.swap.service.busi.impl.dataworks.FileZipUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CreateAzkabanConfFileServiceImpl
implements CreateAzkabanConfFileService {
    private static final Logger log = LoggerFactory.getLogger(CreateAzkabanConfFileServiceImpl.class);
    @Value(value="${azkaban.shell.home}")
    private String azkabanShellHome;
    @Value(value="${datax.json.home}")
    private String dataxJsonHome;
    @Value(value="${hive.sql.home}")
    private String hiveSqlHome;
    @Autowired
    private SwapGetHiveDDlStringService swapGetHiveDDlStringService;
    @Autowired
    private SwapGetAzkabanJobService swapGetAzkabanJobService;
    @Autowired
    private SwapGetAzkabanShellServiceimpl swapGetAzkabanShellServiceimpl;
    @Autowired
    private GoveGetHiveSumStringService goveGetHiveSumStringService;
    @Autowired
    private SwapHiveIncrementTranService swapHiveIncrementTranService;
    @Autowired
    private SwapGetDataXJsonService swapGetDataXJsonService;
    @Autowired
    private TaskPublishMapper taskPublishMapper;
    @Autowired
    private TaskPublishFileMapper taskPublishFileMapper;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private DataWorksDao dataWorksDao;

    public List<CreateImportFileRspBO> createAzkabanConf(ScriptDownloadReqBO scriptDownloadReqBO) throws ZTBusinessException {
        ArrayList<CreateImportFileRspBO> createImportFileRspBOList = new ArrayList<CreateImportFileRspBO>();
        this.validateParam(scriptDownloadReqBO);
        List<CreateImportFileReqBO> listCreateImportFileReqBO = this.dataWorksDao.getListCreateImportFile(scriptDownloadReqBO.getTableNameList());
        if (CollectionUtils.isEmpty(listCreateImportFileReqBO)) {
            throw new ZTBusinessException("\u67e5\u8be2\u8868\u548c\u5b57\u6bb5\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        CreateImportFileListReqBO createImportFileListReqBO = new CreateImportFileListReqBO();
        BeanUtils.copyProperties((Object)scriptDownloadReqBO, (Object)createImportFileListReqBO);
        createImportFileListReqBO.setListCreateImportFileReqBO(listCreateImportFileReqBO);
        if (StringUtils.isEmpty((CharSequence)createImportFileListReqBO.getBizType())) {
            createImportFileListReqBO.setBizType("ddl,sync,sum,ad");
        }
        CreateImportFileListReqBO createImportFileBO = new CreateImportFileListReqBO();
        for (CreateImportFileReqBO importFileBO : createImportFileListReqBO.getListCreateImportFileReqBO()) {
            CreateImportFileRspBO createImportFileRspBO = new CreateImportFileRspBO();
            ArrayList<CreateImportFileBO> reateImportFileBO = new ArrayList<CreateImportFileBO>();
            List jobList = this.swapGetAzkabanJobService.getJobList(importFileBO);
            List<GetFileStringBufferBO> shellList = this.swapGetAzkabanShellServiceimpl.getShellList(importFileBO);
            for (String bizType2 : createImportFileListReqBO.getBizType().split(",")) {
                CreateImportFileBO folderDiFileBO;
                if ("sync".equalsIgnoreCase(bizType2)) {
                    folderDiFileBO = new CreateImportFileBO();
                    folderDiFileBO.setFileName(importFileBO.getTableName() + "_sync.json");
                    folderDiFileBO.setFilePath(this.dataxJsonHome + "/");
                    folderDiFileBO.setFileType("json");
                    folderDiFileBO.setFileContent(this.swapGetDataXJsonService.getDataXJson(importFileBO));
                    reateImportFileBO.add(folderDiFileBO);
                } else if ("ddl".equalsIgnoreCase(bizType2)) {
                    folderDiFileBO = new CreateImportFileBO();
                    folderDiFileBO.setFileName(importFileBO.getTableName() + "_DDL.sql");
                    folderDiFileBO.setFilePath(this.hiveSqlHome + "/");
                    folderDiFileBO.setFileType("sql");
                    folderDiFileBO.setFileContent(this.swapGetHiveDDlStringService.getHiveDDlString(importFileBO));
                    reateImportFileBO.add(folderDiFileBO);
                } else if ("sum".equalsIgnoreCase(bizType2)) {
                    folderDiFileBO = new CreateImportFileBO();
                    folderDiFileBO.setFileName(importFileBO.getTableName() + "_sum.sql");
                    folderDiFileBO.setFilePath(this.hiveSqlHome + "/");
                    folderDiFileBO.setFileType("sql");
                    folderDiFileBO.setFileContent(this.goveGetHiveSumStringService.sumStr(importFileBO));
                    reateImportFileBO.add(folderDiFileBO);
                } else if ("ad".equalsIgnoreCase(bizType2)) {
                    folderDiFileBO = new CreateImportFileBO();
                    folderDiFileBO.setFileName(importFileBO.getTableName() + "_ad.sql");
                    folderDiFileBO.setFilePath(this.hiveSqlHome + "/");
                    folderDiFileBO.setFileType("sql");
                    folderDiFileBO.setFileContent(this.swapHiveIncrementTranService.hiveIncrementTran(importFileBO));
                    reateImportFileBO.add(folderDiFileBO);
                }
                CreateImportFileBO jobFileBO = new CreateImportFileBO();
                this.getJobFile(jobList, bizType2, jobFileBO);
                jobFileBO.setFileType("mappers/job");
                reateImportFileBO.add(jobFileBO);
                CreateImportFileBO shellFileBO = new CreateImportFileBO();
                this.getJobFile(shellList, bizType2, shellFileBO);
                shellFileBO.setFileType("sh");
                reateImportFileBO.add(shellFileBO);
            }
            createImportFileRspBO.setReateImportFileBO(reateImportFileBO);
            createImportFileRspBO.setTableName(importFileBO.getTableName());
            createImportFileRspBOList.add(createImportFileRspBO);
        }
        Date sysDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String dateString = format.format(sysDate);
        for (CreateImportFileRspBO createImportFileRspBOFor : createImportFileRspBOList) {
            String[] size = createImportFileListReqBO.getBizType().split(",");
            TaskPublishPO taskPublishPO = new TaskPublishPO();
            taskPublishPO.setPublishName(createImportFileRspBOFor.getTableName());
            int count = this.taskPublishMapper.getCheckByPublishName(taskPublishPO);
            if (count > 0) {
                taskPublishPO.setModifyType("2");
            } else {
                taskPublishPO.setModifyType("1");
            }
            if (size.length > 1) {
                taskPublishPO.setNodeType("mix");
            } else {
                taskPublishPO.setNodeType(((CreateImportFileBO)createImportFileRspBOFor.getReateImportFileBO().get(0)).getFileType());
            }
            taskPublishPO.setStatus("1");
            taskPublishPO.setOperName(scriptDownloadReqBO.getName());
            taskPublishPO.setCreateTime(new Date());
            if (null != scriptDownloadReqBO.getUserId()) {
                taskPublishPO.setOperId(String.valueOf(scriptDownloadReqBO.getUserId()));
            }
            this.taskPublishMapper.insert(taskPublishPO);
            TableInfoPO tableInfoPO = new TableInfoPO();
            tableInfoPO.setDatabaseTable(createImportFileRspBOFor.getTableName());
            tableInfoPO.setStatus("1");
            TableInfoPO result = this.tableInfoDao.getModelBy(tableInfoPO);
            for (CreateImportFileBO createImportFileBOFor : createImportFileRspBOFor.getReateImportFileBO()) {
                FileZipUtil.txtFile(createImportFileBOFor.getFileContent().toString(), "azkaban_conf_file/user_file/" + dateString + "/" + scriptDownloadReqBO.getUsername() + "/" + createImportFileBOFor.getFileType(), createImportFileBOFor.getFileName());
                TaskPublishFilePO taskPublishFilePO = new TaskPublishFilePO();
                taskPublishFilePO.setPublishId(taskPublishPO.getUnid().toString());
                taskPublishFilePO.setDatabaseTableId(result.getDatabaseTableId());
                taskPublishFilePO.setFilePath("azkaban_conf_file/user_file/" + dateString + "/" + scriptDownloadReqBO.getUsername() + "/" + createImportFileBOFor.getFileType());
                taskPublishFilePO.setFileName(createImportFileBOFor.getFileName());
                taskPublishFilePO.setCreateTime(new Date());
                if (null != scriptDownloadReqBO.getUserId()) {
                    taskPublishFilePO.setOperId(String.valueOf(scriptDownloadReqBO.getUserId()));
                }
                taskPublishFilePO.setOperName(scriptDownloadReqBO.getName());
                this.taskPublishFileMapper.insert(taskPublishFilePO);
            }
        }
        return createImportFileRspBOList;
    }

    private void getJobFile(List<GetFileStringBufferBO> jobList, String bizType2, CreateImportFileBO folderDiFileBO) {
        StringBuffer fileContent = new StringBuffer();
        for (GetFileStringBufferBO jobBO : jobList) {
            if (!bizType2.equalsIgnoreCase(jobBO.getBizType())) continue;
            folderDiFileBO.setFileName(jobBO.getFileName());
            folderDiFileBO.setFileContent(jobBO.getFileContent());
        }
    }

    private void validateParam(ScriptDownloadReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getTableNameList())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8868\u540d\u5217\u8868\u3010TableNameList\u3011\u4e3a\u7a7a");
        }
    }
}

