/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.azkaban;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.azkaban.bo.AzkabanMetadataBO;
import com.yqsmartcity.data.swap.api.azkaban.service.AzkabanLoginService;
import com.yqsmartcity.data.swap.api.azkaban.service.UploadJobZipService;
import com.yqsmartcity.data.swap.service.busi.impl.azkaban.util.AzkabanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UploadJobZipServiceImpl
implements UploadJobZipService {
    private static final Logger log = LoggerFactory.getLogger(UploadJobZipServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(UploadJobZipServiceImpl.class);
    @Value(value="${azkaban.project}")
    private String azkabanProject;
    @Autowired
    AzkabanLoginService azkabanLoginService;

    public void uploadAzkabanZip(AzkabanMetadataBO azkabanMetadataBO) throws ZTBusinessException {
        ObjectMapper mapper = new ObjectMapper();
        logger.info("----------------------1---------------");
        AzkabanMetadataBO azkabanMetadataBOReturn = this.azkabanLoginService.login(azkabanMetadataBO);
        azkabanMetadataBOReturn.setProject(this.azkabanProject);
        try {
            String uploadZip = AzkabanUtil.uploadZip(azkabanMetadataBOReturn.getUrl(), azkabanMetadataBOReturn.getSessionID(), azkabanMetadataBOReturn.getProject(), azkabanMetadataBOReturn.getZipPath());
            if (!mapper.readTree(uploadZip).has("error")) {
                log.info("azkaban:\u4e0a\u4f20job\u7684zip\u5305\u6210\u529f");
                azkabanMetadataBOReturn.setProjectID(mapper.readTree(uploadZip).path("projectId").asText());
                azkabanMetadataBOReturn.setZip_version(mapper.readTree(uploadZip).path("version").asText());
            }
        }
        catch (Exception e) {
            log.error("azkaban:\u4e0a\u4f20job\u7684zip\u5305\u5931\u8d25");
            e.printStackTrace();
            throw new ZTBusinessException("azkaban:\u4e0a\u4f20job\u7684zip\u5305\u5931\u8d25");
        }
    }
}

