/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.azkaban.util;

import java.io.File;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class AzkabanUtil {
    private static RestTemplate restTemplate = null;

    public static void getExecuteFlow(String url, String session_ID, String project, String flow, String start, String length) {
        HttpHeaders hs = new HttpHeaders();
        hs.add("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        hs.add("X-Requested-With", "XMLHttpRequest");
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        linkedMultiValueMap.add((Object)"session.id", (Object)session_ID);
        linkedMultiValueMap.add((Object)"ajax", (Object)"fetchFlowExecutions");
        linkedMultiValueMap.add((Object)"project", (Object)project);
        linkedMultiValueMap.add((Object)"start", (Object)start);
        linkedMultiValueMap.add((Object)"length", (Object)length);
        linkedMultiValueMap.add((Object)"flow", (Object)flow);
        HttpEntity httpEntity = new HttpEntity((Object)linkedMultiValueMap, (MultiValueMap)hs);
        String postForObject = (String)restTemplate.postForObject(url + "/manager", (Object)httpEntity, String.class, new Object[0]);
        System.out.println(postForObject);
    }

    public static String executeFlow(String url, String session_ID, String project, String flow) {
        HttpHeaders hs = new HttpHeaders();
        hs.add("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        hs.add("X-Requested-With", "XMLHttpRequest");
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        linkedMultiValueMap.add((Object)"session.id", (Object)session_ID);
        linkedMultiValueMap.add((Object)"ajax", (Object)"executeFlow");
        linkedMultiValueMap.add((Object)"project", (Object)project);
        linkedMultiValueMap.add((Object)"flow", (Object)flow);
        HttpEntity httpEntity = new HttpEntity((Object)linkedMultiValueMap, (MultiValueMap)hs);
        return (String)restTemplate.postForObject(url + "/executor", (Object)httpEntity, String.class, new Object[0]);
    }

    public static String login(String url, String userName, String password) throws Exception {
        HttpHeaders hs = new HttpHeaders();
        hs.add("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        hs.add("X-Requested-With", "XMLHttpRequest");
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        linkedMultiValueMap.add((Object)"action", (Object)"login");
        linkedMultiValueMap.add((Object)"username", (Object)userName);
        linkedMultiValueMap.add((Object)"password", (Object)password);
        HttpEntity httpEntity = new HttpEntity((Object)linkedMultiValueMap, (MultiValueMap)hs);
        return (String)restTemplate.postForObject(url, (Object)httpEntity, String.class, new Object[0]);
    }

    public static void createProject(String url, String session_ID, String project, String description) throws Exception {
        HttpHeaders hs = new HttpHeaders();
        hs.add("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        hs.add("X-Requested-With", "XMLHttpRequest");
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        linkedMultiValueMap.add((Object)"session.id", (Object)session_ID);
        linkedMultiValueMap.add((Object)"action", (Object)"create");
        linkedMultiValueMap.add((Object)"name", (Object)project);
        linkedMultiValueMap.add((Object)"description", (Object)description);
        HttpEntity httpEntity = new HttpEntity((Object)linkedMultiValueMap, (MultiValueMap)hs);
        String postForObject = (String)restTemplate.postForObject(url + "/manager", (Object)httpEntity, String.class, new Object[0]);
        System.out.println(postForObject);
    }

    public static void deleteProject(String url, String session_ID, String project) throws Exception {
        HttpHeaders hs = new HttpHeaders();
        hs.add("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        hs.add("X-Requested-With", "XMLHttpRequest");
        hs.add("Accept", "text/plain;charset=utf-8");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", session_ID);
        map.put("project", project);
        ResponseEntity exchange = restTemplate.exchange(url + "/manager?session.id={id}&delete=true&project={project}", HttpMethod.GET, new HttpEntity((MultiValueMap)hs), String.class, map);
        System.out.println((String)exchange.getBody());
        System.out.println(exchange.getStatusCode());
        System.out.println(exchange.getStatusCodeValue());
    }

    public static String uploadZip(String url, String sessionID, String project, String zipPath) throws Exception {
        FileSystemResource resource = new FileSystemResource(new File(zipPath));
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        linkedMultiValueMap.add((Object)"session.id", (Object)sessionID);
        linkedMultiValueMap.add((Object)"ajax", (Object)"upload");
        linkedMultiValueMap.add((Object)"project", (Object)project);
        linkedMultiValueMap.add((Object)"file", (Object)resource);
        return (String)restTemplate.postForObject(url + "/manager", (Object)linkedMultiValueMap, String.class, new Object[0]);
    }

    public static String scheduleByCronEXEaFlow(String url, String sessionID, String project, String cron, String flow) throws KeyManagementException, NoSuchAlgorithmException {
        HttpHeaders hs = new HttpHeaders();
        hs.add("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        hs.add("X-Requested-With", "XMLHttpRequest");
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        linkedMultiValueMap.add((Object)"session.id", (Object)sessionID);
        linkedMultiValueMap.add((Object)"ajax", (Object)"scheduleCronFlow");
        linkedMultiValueMap.add((Object)"projectName", (Object)project);
        linkedMultiValueMap.add((Object)"cronExpression", (Object)cron);
        linkedMultiValueMap.add((Object)"flow", (Object)flow);
        HttpEntity httpEntity = new HttpEntity((Object)linkedMultiValueMap, (MultiValueMap)hs);
        return (String)restTemplate.postForObject(url + "/schedule", (Object)httpEntity, String.class, new Object[0]);
    }

    public static void unscheduleFlow(String url, String session_ID, String schedule_ID) throws KeyManagementException, NoSuchAlgorithmException {
        HttpHeaders hs = new HttpHeaders();
        hs.add("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        hs.add("X-Requested-With", "XMLHttpRequest");
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        linkedMultiValueMap.add((Object)"session.id", (Object)session_ID);
        linkedMultiValueMap.add((Object)"action", (Object)"removeSched");
        linkedMultiValueMap.add((Object)"scheduleId", (Object)schedule_ID);
        HttpEntity httpEntity = new HttpEntity((Object)linkedMultiValueMap, (MultiValueMap)hs);
        String postForObject = (String)restTemplate.postForObject(url + "/schedule", (Object)httpEntity, String.class, new Object[0]);
        System.out.println(postForObject);
    }

    static {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(8000);
        requestFactory.setReadTimeout(8000);
        restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }
}

