/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.collect;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.ref.ability.RfCollectDataTaskService;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogRspBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.api.base.service.SwapSelectDictService;
import com.yqsmartcity.data.swap.api.collect.bo.AddCollectionRuleConfigReqBO;
import com.yqsmartcity.data.swap.api.collect.service.AddCollectionRuleConfigService;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapInsertTableColInfoService;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.SysParaDao;
import com.yqsmartcity.data.swap.dao.TableColInfoDao;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.dao.TableResourceInfoDao;
import com.yqsmartcity.data.swap.dao.TaskInfoDao;
import com.yqsmartcity.data.swap.po.SysParaPO;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import com.yqsmartcity.data.swap.po.TableResourceInfoPO;
import com.yqsmartcity.data.swap.po.TaskInfoPO;
import java.util.Date;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AddCollectionRuleConfigServiceImpl
implements AddCollectionRuleConfigService {
    private static final Logger log = LoggerFactory.getLogger(AddCollectionRuleConfigServiceImpl.class);
    @Value(value="${is.rely.recource}")
    private String isRelyRecource;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private DatabaseInfoDao databaseInfoDao;
    @Autowired
    private SwapInsertOperLogService swapInsertOperLogService;
    @Autowired
    private SwapSelectDictService swapSelectDictService;
    @Autowired
    private SwapInsertTableColInfoService swapInsertTableColInfoService;
    @Autowired
    private TableResourceInfoDao tableResourceInfoDao;
    @Autowired
    private TableColInfoDao tableColInfoDao;
    @Value(value="${technology.type}")
    private String technologyType;
    @Value(value="${target.database.code}")
    private String targetDatabaseCode;
    @Autowired
    private SysParaDao sysParaDao;
    @Autowired
    private RfCollectDataTaskService rfCollectDataTaskService;

    @Transactional(rollbackFor={Exception.class})
    public void addCollectionRuleConfig(AddCollectionRuleConfigReqBO reqBO) throws ZTBusinessException {
        this.validateParam(reqBO);
        TaskInfoPO taskInfoPO2 = new TaskInfoPO();
        taskInfoPO2.setTaskName(reqBO.getTaskName());
        TaskInfoPO taskInfoPO1 = this.taskInfoDao.getModelBy(taskInfoPO2);
        if (null != taskInfoPO1) {
            throw new ZTBusinessException("\u8be5\u4efb\u52a1\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u5efa\u7acb\uff01");
        }
        TaskInfoPO taskInfoPO = new TaskInfoPO();
        String str = AddCollectionRuleConfigServiceImpl.getRandom(7);
        taskInfoPO.setTaskId(reqBO.getDeptCode() + "_" + str);
        taskInfoPO.setTaskName(reqBO.getTaskName());
        taskInfoPO.setTaskBigType("01");
        taskInfoPO.setTaskSubType("1");
        taskInfoPO.setCreateTime(new Date());
        taskInfoPO.setUpdateTime(new Date());
        taskInfoPO.setStatus("1");
        taskInfoPO.setNeedDesc(reqBO.getNeedDesc());
        if (null != reqBO.getUserId()) {
            taskInfoPO.setOperId(String.valueOf(reqBO.getUserId()));
        }
        taskInfoPO.setOperName(reqBO.getName());
        int taskInfoResult = this.taskInfoDao.insert(taskInfoPO);
        if (taskInfoResult < 1) {
            throw new ZTBusinessException("\u4ea4\u6362\u4efb\u52a1\u65b0\u589e\u5931\u8d25");
        }
        TableInfoPO tableInfoPO = new TableInfoPO();
        String strTable = AddCollectionRuleConfigServiceImpl.getRandom(7);
        tableInfoPO.setDatabaseTableId(reqBO.getDatabaseCode() + strTable);
        tableInfoPO.setTaskId(taskInfoPO.getTaskId());
        tableInfoPO.setDatabaseCode(reqBO.getDatabaseCode());
        tableInfoPO.setSourceTable(reqBO.getSourceTable());
        tableInfoPO.setDatabaseTable(reqBO.getDatabaseTable());
        tableInfoPO.setConfigState("0");
        tableInfoPO.setCreateTime(new Date());
        tableInfoPO.setUpdateTime(new Date());
        tableInfoPO.setStatus(reqBO.getOperation());
        tableInfoPO.setSwapMode(reqBO.getSwapMode());
        tableInfoPO.setQueryWhere(reqBO.getQueryWhere());
        tableInfoPO.setPartionMode(reqBO.getPartionMode());
        tableInfoPO.setPartionWhere(reqBO.getPartionWhere());
        if (null != reqBO.getUserId()) {
            tableInfoPO.setOperId(String.valueOf(reqBO.getUserId()));
        }
        tableInfoPO.setOperName(reqBO.getName());
        tableInfoPO.setTargetDatabaseCode(this.targetDatabaseCode);
        int tableInfoResult = this.tableInfoDao.insert(tableInfoPO);
        if (tableInfoResult < 1) {
            throw new ZTBusinessException("\u8868\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
        RfCollectDataTaskReqBO insertRfCollectDataTaskReqBO = new RfCollectDataTaskReqBO();
        insertRfCollectDataTaskReqBO.setCollectTaskCode(tableInfoPO.getTaskId());
        insertRfCollectDataTaskReqBO.setCollectTaskDesc(taskInfoPO.getTaskName());
        insertRfCollectDataTaskReqBO.setCollectDataSourceCode(tableInfoPO.getDatabaseCode());
        insertRfCollectDataTaskReqBO.setCollectTable(tableInfoPO.getSourceTable());
        insertRfCollectDataTaskReqBO.setTargetDataSourceCode(tableInfoPO.getTargetDatabaseCode());
        insertRfCollectDataTaskReqBO.setTargetTable(tableInfoPO.getDatabaseTable());
        if ("1".equals(reqBO.getOperation())) {
            insertRfCollectDataTaskReqBO.setStatus("SUSPEND");
        } else if ("2".equals(reqBO.getOperation())) {
            insertRfCollectDataTaskReqBO.setStatus("COLLECT");
        }
        insertRfCollectDataTaskReqBO.setSysCode("data-center");
        this.rfCollectDataTaskService.addRfCollectDataTask(insertRfCollectDataTaskReqBO);
        if ("2".equalsIgnoreCase(this.isRelyRecource)) {
            TableResourceInfoPO tableResourceInfoPO = new TableResourceInfoPO();
            tableResourceInfoPO.setDatabaseTableId(tableInfoPO.getDatabaseTableId());
            tableResourceInfoPO.setResourceId(reqBO.getDataTableId());
            tableResourceInfoPO.setCreateTime(new Date());
            tableResourceInfoPO.setUpdateTime(new Date());
            tableResourceInfoPO.setStatus("1");
            tableResourceInfoPO.setConfigState("0");
            int result = this.tableResourceInfoDao.insert(tableResourceInfoPO);
            if (result < 1) {
                throw new ZTBusinessException("\u65b0\u589e\u5931\u8d25\uff01");
            }
        }
        SwapInsertOperLogReqBO swapInsertOperLogReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)swapInsertOperLogReqBO);
        swapInsertOperLogReqBO.setRequestDate(new Date().toString());
        swapInsertOperLogReqBO.setOperMode("\u5f52\u96c6\u89c4\u5219\u914d\u7f6e");
        swapInsertOperLogReqBO.setOperType("A");
        swapInsertOperLogReqBO.setOperContent("\u65b0\u589e:" + reqBO.getTaskName() + "\u5f52\u96c6\u4efb\u52a1");
        this.logg(swapInsertOperLogReqBO);
    }

    private void validateParam(AddCollectionRuleConfigReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getTaskName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5f52\u96c6\u4efb\u52a1\u540d\u79f0\u3010taskName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getDatabaseCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u6e90\u7f16\u7801\u3010databaseCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getDatabaseName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u6e90\u540d\u79f0\u3010databaseName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getDeptCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u90e8\u95e8\u7f16\u7801\u3010deptCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getDeptName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u90e8\u95e8\u540d\u79f0\u3010deptName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getSourceTable())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6e90\u6570\u636e\u8868\u540d\u3010sourceTable\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getDatabaseTable())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u76ee\u6807\u6570\u636e\u8868\u540d\u3010databaseTable\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getSwapMode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5f52\u96c6\u65b9\u5f0f\u3010swapMode\u3011\u4e3a\u7a7a");
        }
        if ("add".equals(reqBO.getSwapMode()) && StringUtils.isEmpty((CharSequence)reqBO.getQueryWhere())) {
            throw new ZTBusinessException("\u5f52\u96c6\u65b9\u5f0f\u4e3a\u589e\u91cf\u65f6\u589e\u91cf\u6761\u4ef6\u3010queryWhere\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPartionMode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5206\u533a\u65b9\u5f0f\u3010partionMode\u3011\u4e3a\u7a7a");
        }
        if ("1".equals(reqBO.getPartionMode()) && StringUtils.isEmpty((CharSequence)reqBO.getPartionWhere())) {
            throw new ZTBusinessException("\u5206\u533a\u65b9\u5f0f\u4e3a\u5206\u533a\u8868\u65f6\u5206\u533a\u6761\u4ef6\u3010paartionWhere\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getOperation())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u64cd\u4f5c\u7c7b\u578b\u3010operation\u3011\u4e3a\u7a7a");
        }
        if (null == reqBO.getDataTableId()) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8d44\u6e90\u76ee\u5f55\u8868id\u3010dataTableId\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getSysCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u7cfb\u7edf\u7f16\u7801\u3010sysCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getSysName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u7cfb\u7edf\u540d\u79f0\u3010sysName\u3011\u4e3a\u7a7a");
        }
    }

    public static String getRandom(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }

    private String getSysPara(String paraCode, String paraType) {
        SwapSelectDictReqBO swapSelectDictReqBO = new SwapSelectDictReqBO();
        swapSelectDictReqBO.setParaCode(paraCode);
        swapSelectDictReqBO.setParaType(paraType);
        SwapSelectDictRspBO swapSelectDictRspBO = this.swapSelectDictService.queryDict(swapSelectDictReqBO);
        if ("0".equals(swapSelectDictRspBO.getCode()) && null != swapSelectDictRspBO.getSysParaBO()) {
            String descrip = swapSelectDictRspBO.getSysParaBO().getParaName();
            return null == descrip ? "" : descrip;
        }
        return "";
    }

    private void logg(SwapInsertOperLogReqBO swapInsertOperLogReqBO) {
        SwapInsertOperLogRspBO swapInsertOperLogRspBO = this.swapInsertOperLogService.insertOperLog(swapInsertOperLogReqBO);
        if (!"0".equals(swapInsertOperLogRspBO.getCode())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25!");
        }
    }

    private String qryDatabase(String paraName) {
        SysParaPO reqPO = new SysParaPO();
        reqPO.setParaName(paraName);
        reqPO.setParaType("DATABASE_TYPE");
        reqPO.setStatus("1");
        SysParaPO sysParaPO = this.sysParaDao.getModelBy(reqPO);
        if (null != sysParaPO) {
            return sysParaPO.getParaCode();
        }
        return "";
    }
}

