/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.collect;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.ref.ability.RfCollectDataTaskService;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskReqBO;
import com.yqsmartcity.data.ref.ability.bo.RfCollectDataTaskRspBO;
import com.yqsmartcity.data.swap.api.collect.bo.BatchDeleteCollectionConfigReqBO;
import com.yqsmartcity.data.swap.api.collect.service.BatchDeleteCollectionConfigService;
import com.yqsmartcity.data.swap.dao.TableColInfoDao;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.dao.TaskInfoDao;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BatchDeleteCollectionConfigServiceImpl
implements BatchDeleteCollectionConfigService {
    private static final Logger log = LoggerFactory.getLogger(BatchDeleteCollectionConfigServiceImpl.class);
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private TableColInfoDao tableColInfoDao;
    @Autowired
    private RfCollectDataTaskService rfCollectDataTaskService;

    @Transactional(rollbackFor={Exception.class})
    public void batchDeleteCollectionConfig(BatchDeleteCollectionConfigReqBO reqBO) throws ZTBusinessException {
        if (CollectionUtils.isEmpty((Collection)reqBO.getUnidList())) {
            throw new ZTBusinessException("\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long[] array = reqBO.getUnidList().stream().mapToLong(t -> t).toArray();
        this.taskInfoDao.deleteByTableUnids(array);
        this.tableColInfoDao.deleteByTableInfoUnid(array);
        for (Long unid : reqBO.getUnidList()) {
            TableInfoPO selectTableInfoPO = new TableInfoPO();
            selectTableInfoPO.setUnid(unid);
            TableInfoPO tableInfoPO = this.tableInfoDao.getModelBy(selectTableInfoPO);
            RfCollectDataTaskReqBO selectRfCollectDataTaskReqBO = new RfCollectDataTaskReqBO();
            selectRfCollectDataTaskReqBO.setCollectTaskCode(tableInfoPO.getTaskId());
            RfCollectDataTaskRspBO rfCollectDataTaskRspBO = this.rfCollectDataTaskService.queryRfCollectDataTaskSingle(selectRfCollectDataTaskReqBO);
            RfCollectDataTaskReqBO deleteRfCollectDataTaskReqBO = new RfCollectDataTaskReqBO();
            deleteRfCollectDataTaskReqBO.setId(rfCollectDataTaskRspBO.getData().getId());
            this.rfCollectDataTaskService.deleteRfCollectDataTask(deleteRfCollectDataTaskReqBO);
        }
        this.tableInfoDao.deleteByIds(array);
    }
}

