/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.collect;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapSelectDictService;
import com.yqsmartcity.data.swap.api.collect.bo.QryCollectionRuleConfigPageListReqBO;
import com.yqsmartcity.data.swap.api.collect.bo.QryCollectionRuleConfigPageListRspBO;
import com.yqsmartcity.data.swap.api.collect.bo.TableInfoBO;
import com.yqsmartcity.data.swap.api.collect.service.QryCollectionRuleConfigPageListService;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryCollectionRuleConfigPageListServiceImpl
implements QryCollectionRuleConfigPageListService {
    private static final Logger log = LoggerFactory.getLogger(QryCollectionRuleConfigPageListServiceImpl.class);
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private SwapSelectDictService swapSelectDictService;

    public QryCollectionRuleConfigPageListRspBO qryCollectionRuleConfigPageList(QryCollectionRuleConfigPageListReqBO reqBO) throws ZTBusinessException {
        QryCollectionRuleConfigPageListRspBO rspBO = new QryCollectionRuleConfigPageListRspBO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!StringUtils.isEmpty((String)reqBO.getUpdateTime())) {
            String[] updateTimeList = reqBO.getUpdateTime().split("~");
            String updateTimeStart = updateTimeList[0].trim() + " 00:00:00";
            String updateTimeEnd = updateTimeList[1].trim() + " 23:59:59";
            try {
                Date updateStart = sdf.parse(updateTimeStart);
                Date updateEnd = sdf.parse(updateTimeEnd);
                reqBO.setUpdateStart(updateStart);
                reqBO.setUpdateEnd(updateEnd);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<TableInfoBO> tableInfoBOList = this.tableInfoDao.getCollectionConfigPageList((Page<TableInfoBO>)page, reqBO);
        for (TableInfoBO tableInfoBO : tableInfoBOList) {
            if ("1".equals(tableInfoBO.getStatus())) {
                tableInfoBO.setStatusDesc("\u8349\u7a3f");
            } else {
                tableInfoBO.setStatusDesc("\u5df2\u63d0\u4ea4");
            }
            tableInfoBO.setSwapModeDesc(this.getSysPara(tableInfoBO.getSwapMode(), "SWAP_MODE_TYPE"));
            tableInfoBO.setPartionModeDesc(this.getSysPara(tableInfoBO.getPartionMode(), "PARTION_MODE_TYPE"));
        }
        rspBO.setRows(tableInfoBOList);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    private String getSysPara(String paraCode, String paraType) {
        SwapSelectDictReqBO swapSelectDictReqBO = new SwapSelectDictReqBO();
        swapSelectDictReqBO.setParaCode(paraCode);
        swapSelectDictReqBO.setParaType(paraType);
        SwapSelectDictRspBO swapSelectDictRspBO = this.swapSelectDictService.queryDict(swapSelectDictReqBO);
        if ("0".equals(swapSelectDictRspBO.getCode()) && null != swapSelectDictRspBO.getSysParaBO()) {
            String descrip = swapSelectDictRspBO.getSysParaBO().getParaName();
            return null == descrip ? "" : descrip;
        }
        return "";
    }
}

