/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.collect;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapSelectDictService;
import com.yqsmartcity.data.swap.api.collect.bo.QryCollectionTaskDetailReqBO;
import com.yqsmartcity.data.swap.api.collect.bo.QryCollectionTaskDetailRspBO;
import com.yqsmartcity.data.swap.api.collect.service.QryCollectionTaskDetailService;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.dao.TaskInfoDao;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import com.yqsmartcity.data.swap.po.TaskInfoPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryCollectionTaskDetailServiceImpl
implements QryCollectionTaskDetailService {
    private static final Logger log = LoggerFactory.getLogger(QryCollectionTaskDetailServiceImpl.class);
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private SwapSelectDictService swapSelectDictService;

    public QryCollectionTaskDetailRspBO qryCollectionTaskDetail(QryCollectionTaskDetailReqBO reqBO) throws ZTBusinessException {
        QryCollectionTaskDetailRspBO rspBO = new QryCollectionTaskDetailRspBO();
        if (null == reqBO.getUnid()) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TaskInfoPO taskInfoPO = this.taskInfoDao.getModelById(reqBO.getUnid());
        BeanUtils.copyProperties((Object)taskInfoPO, (Object)rspBO);
        rspBO.setCrontabExpression(taskInfoPO.getSwapFreq());
        rspBO.setSwapCycleDesc(this.getSysPara(taskInfoPO.getSwapCycle(), "DISPATCH_CYCLE"));
        TableInfoPO tableInfoPO = this.tableInfoDao.getTableInfoByTaskUnid(reqBO.getUnid());
        if (null != tableInfoPO) {
            rspBO.setTableName(tableInfoPO.getSourceTable());
            rspBO.setTableDesc(tableInfoPO.getDatabaseTableName());
        }
        return rspBO;
    }

    private String getSysPara(String paraCode, String paraType) {
        SwapSelectDictReqBO swapSelectDictReqBO = new SwapSelectDictReqBO();
        swapSelectDictReqBO.setParaCode(paraCode);
        swapSelectDictReqBO.setParaType(paraType);
        SwapSelectDictRspBO swapSelectDictRspBO = this.swapSelectDictService.queryDict(swapSelectDictReqBO);
        if ("0".equals(swapSelectDictRspBO.getCode()) && null != swapSelectDictRspBO.getSysParaBO()) {
            String descrip = swapSelectDictRspBO.getSysParaBO().getParaName();
            return null == descrip ? "" : descrip;
        }
        return "";
    }
}

