/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.collect;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.collect.bo.DeptInfoBO;
import com.yqsmartcity.data.swap.api.collect.bo.QryQueryParaListReqBO;
import com.yqsmartcity.data.swap.api.collect.bo.QryQueryParaListRspBO;
import com.yqsmartcity.data.swap.api.collect.service.QryQueryParaListService;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.po.DeptInfoPO;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QryQueryParaListServiceImpl
implements QryQueryParaListService {
    private static final Logger log = LoggerFactory.getLogger(QryQueryParaListServiceImpl.class);
    @Autowired
    private TableInfoDao tableInfoDao;

    public QryQueryParaListRspBO qryQueryParaList(QryQueryParaListReqBO reqBO) throws ZTBusinessException {
        if (StringUtils.isEmpty((CharSequence)reqBO.getOperSource())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u9875\u9762\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QryQueryParaListRspBO rspBO = new QryQueryParaListRspBO();
        ArrayList<String> sourceTableList = new ArrayList<String>();
        ArrayList<String> databaseTableList = new ArrayList<String>();
        ArrayList<DeptInfoBO> deptInfoBOList = new ArrayList<DeptInfoBO>();
        List<TableInfoPO> tableInfoPOList = this.tableInfoDao.getQueryParaTableName(reqBO);
        for (TableInfoPO tableInfoPO : tableInfoPOList) {
            sourceTableList.add(tableInfoPO.getSourceTable());
            databaseTableList.add(tableInfoPO.getDatabaseTable());
        }
        List<DeptInfoPO> deptInfoPOList = this.tableInfoDao.getQueryParaDeptInfo(reqBO);
        for (DeptInfoPO deptInfoPO : deptInfoPOList) {
            DeptInfoBO deptInfoBO = new DeptInfoBO();
            deptInfoBO.setDeptCode(deptInfoPO.getDeptCode());
            deptInfoBO.setDeptName(deptInfoPO.getDeptName());
            deptInfoBOList.add(deptInfoBO);
        }
        rspBO.setDatabaseTableList(databaseTableList.stream().distinct().collect(Collectors.toList()));
        rspBO.setDeptInfoBOList(deptInfoBOList);
        rspBO.setSourceTableList(sourceTableList.stream().distinct().collect(Collectors.toList()));
        return rspBO;
    }
}

