/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.collect;

import com.alibaba.druid.filter.config.ConfigTools;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.collect.bo.QryTableListReqBO;
import com.yqsmartcity.data.swap.api.collect.bo.QryTableListRspBO;
import com.yqsmartcity.data.swap.api.collect.service.QryTableListService;
import com.yqsmartcity.data.swap.api.database.bo.DatabaseInfoBO;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkMysqlService;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkOracleService;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkSqlServerService;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class QryTableListServiceImpl
implements QryTableListService {
    private static final Logger log = LoggerFactory.getLogger(QryTableListServiceImpl.class);
    @Value(value="${is.rely.recource}")
    private String isRelyRecource;
    @Autowired
    private DatabaseInfoDao databaseInfoDao;
    @Autowired
    private SwapLinkOracleService swapLinkOracleService;
    @Autowired
    private SwapLinkMysqlService swapLinkMysqlService;
    @Autowired
    private SwapLinkSqlServerService swapLinkSqlServerService;

    public QryTableListRspBO qryTableList(QryTableListReqBO reqBO) throws ZTBusinessException {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getDatabaseCode())) {
            throw new ZTBusinessException("\u6570\u636e\u6e90\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QryTableListRspBO rspBO = new QryTableListRspBO();
        List tableBOList = new ArrayList();
        DatabaseInfoPO qryDatabaseInfoPO = new DatabaseInfoPO();
        qryDatabaseInfoPO.setDatabaseCode(reqBO.getDatabaseCode());
        qryDatabaseInfoPO.setStatus("1");
        DatabaseInfoPO databaseInfoPO = this.databaseInfoDao.getModelBy(qryDatabaseInfoPO);
        try {
            databaseInfoPO.setUserPass(ConfigTools.decrypt((String)databaseInfoPO.getUserPass()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DatabaseInfoBO databaseInfoBO = new DatabaseInfoBO();
        BeanUtils.copyProperties((Object)databaseInfoPO, (Object)databaseInfoBO);
        databaseInfoBO.setQryTableFlag("table");
        if (StringUtils.isEmpty((Object)databaseInfoBO.getTableSchema())) {
            databaseInfoBO.setTableSchema(databaseInfoBO.getServerName());
        }
        if ("OR".equals(databaseInfoBO.getDatabaseType())) {
            tableBOList = this.swapLinkOracleService.linkOracle(databaseInfoBO);
        } else if ("MS".equalsIgnoreCase(databaseInfoBO.getDatabaseType())) {
            tableBOList = this.swapLinkMysqlService.linkMysql(databaseInfoBO);
        } else if ("SS".equalsIgnoreCase(databaseInfoBO.getDatabaseType())) {
            tableBOList = this.swapLinkSqlServerService.linkSqlServer(databaseInfoBO);
        }
        rspBO.setTableBOList(tableBOList.stream().distinct().collect(Collectors.toList()));
        return rspBO;
    }
}

