/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.database;

import com.alibaba.druid.filter.config.ConfigTools;
import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapInsertOperLogRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.api.database.bo.SwapInsertDatabaseInfoReqBO;
import com.yqsmartcity.data.swap.api.database.bo.SwapInsertDatabaseInfoRspBO;
import com.yqsmartcity.data.swap.api.database.service.SwapInsertDatabaseInfoBusiService;
import com.yqsmartcity.data.swap.dao.DatabaseDbidInfoDao;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.DeptInfoDao;
import com.yqsmartcity.data.swap.po.DatabaseDbidInfoPO;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import com.yqsmartcity.data.swap.po.DeptInfoPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapInsertDatabaseInfoBusiServiceImpl
implements SwapInsertDatabaseInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(SwapInsertDatabaseInfoBusiServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SwapInsertDatabaseInfoBusiServiceImpl.class);
    @Autowired
    private DatabaseInfoDao databaseInfoDao;
    @Autowired
    private DeptInfoDao deptInfoDao;
    @Autowired
    private DatabaseDbidInfoDao databaseDbidInfoDao;
    @Autowired
    private SwapInsertOperLogService swapInsertOperLogService;

    @Transactional(rollbackFor={Exception.class})
    public SwapInsertDatabaseInfoRspBO insertDatabaseInfoBusi(SwapInsertDatabaseInfoReqBO swapInsertDatabaseInfoReqBO) throws ZTBusinessException {
        logger.info("\u5165\u53c2\u4fe1\u606f:" + swapInsertDatabaseInfoReqBO.toString());
        this.validateParam(swapInsertDatabaseInfoReqBO);
        DatabaseInfoPO qryDatabaseInfoPO = new DatabaseInfoPO();
        qryDatabaseInfoPO.setSysCode(swapInsertDatabaseInfoReqBO.getSysCode());
        qryDatabaseInfoPO.setDatabaseName(swapInsertDatabaseInfoReqBO.getDatabaseName());
        qryDatabaseInfoPO.setStatus("1");
        DatabaseInfoPO databaseInfoPO1 = this.databaseInfoDao.getModelBy(qryDatabaseInfoPO);
        if (null != databaseInfoPO1) {
            throw new ZTBusinessException("\u8be5\u6570\u636e\u6e90\u5df2\u5165\u5e93\uff01");
        }
        DeptInfoPO deptInfoPO = new DeptInfoPO();
        deptInfoPO.setDeptCode(swapInsertDatabaseInfoReqBO.getDeptCode());
        deptInfoPO.setStatus("1");
        DeptInfoPO deptInfoPO1 = this.deptInfoDao.getModelBy(deptInfoPO);
        String deptNo = null;
        if (null == deptInfoPO1) {
            DeptInfoPO addDeptInfoPO = new DeptInfoPO();
            deptNo = this.deptInfoDao.abbrDeptName(swapInsertDatabaseInfoReqBO.getDeptName()).toLowerCase();
            if (deptNo.length() > 4) {
                deptNo = deptNo.substring(0, 4);
            } else if (deptNo.length() < 4) {
                StringBuffer sb = null;
                while (deptNo.length() < 4) {
                    sb = new StringBuffer();
                    sb.append(deptNo).append("0");
                    deptNo = sb.toString();
                }
            }
            addDeptInfoPO.setDeptCode(deptNo);
            addDeptInfoPO.setDeptName(swapInsertDatabaseInfoReqBO.getDeptName());
            addDeptInfoPO.setSourceDeptCode(swapInsertDatabaseInfoReqBO.getDeptCode());
            addDeptInfoPO.setStatus("1");
            addDeptInfoPO.setCreateTime(new Date());
            addDeptInfoPO.setUpdateTime(new Date());
            int result = this.deptInfoDao.insert(addDeptInfoPO);
            if (result < 1) {
                throw new ZTBusinessException("\u90e8\u95e8\u65b0\u589e\u5931\u8d25!");
            }
        }
        SwapInsertDatabaseInfoRspBO rspBO = new SwapInsertDatabaseInfoRspBO();
        DatabaseInfoPO databaseInfoPO = new DatabaseInfoPO();
        if (swapInsertDatabaseInfoReqBO.getUnid() != null) {
            swapInsertDatabaseInfoReqBO.setUnid(Long.valueOf(swapInsertDatabaseInfoReqBO.getUnid() + 1L));
        }
        BeanUtils.copyProperties((Object)swapInsertDatabaseInfoReqBO, (Object)databaseInfoPO);
        if (null == deptInfoPO1) {
            databaseInfoPO.setDeptCode(deptNo);
        } else {
            databaseInfoPO.setDeptCode(deptInfoPO1.getDeptCode());
        }
        int number = 0;
        if (swapInsertDatabaseInfoReqBO.getDatabaseTypeDesc().equals("Oracle")) {
            String databaseCode;
            do {
                databaseCode = databaseInfoPO.getDeptCode() + "_or" + number;
                databaseInfoPO.setDatabaseCode(databaseCode);
                ++number;
            } while (this.qryDatabaseCode(databaseCode));
        } else if (swapInsertDatabaseInfoReqBO.getDatabaseTypeDesc().equals("MySQL")) {
            String databaseCode;
            do {
                databaseCode = databaseInfoPO.getDeptCode() + "_ms" + number;
                databaseInfoPO.setDatabaseCode(databaseCode);
                ++number;
            } while (this.qryDatabaseCode(databaseCode));
        } else if (swapInsertDatabaseInfoReqBO.getDatabaseTypeDesc().equals("SqlServer")) {
            String databaseCode;
            do {
                databaseCode = databaseInfoPO.getDeptCode() + "_ss" + number;
                databaseInfoPO.setDatabaseCode(databaseCode);
                ++number;
            } while (this.qryDatabaseCode(databaseCode));
        } else if (swapInsertDatabaseInfoReqBO.getDatabaseTypeDesc().equals("db2")) {
            String databaseCode;
            do {
                databaseCode = databaseInfoPO.getDeptCode() + "_db" + number;
                databaseInfoPO.setDatabaseCode(databaseCode);
                ++number;
            } while (this.qryDatabaseCode(databaseCode));
        } else if (swapInsertDatabaseInfoReqBO.getDatabaseTypeDesc().equals("oss")) {
            String databaseCode;
            do {
                databaseCode = databaseInfoPO.getDeptCode() + "_os" + number;
                databaseInfoPO.setDatabaseCode(databaseCode);
                ++number;
            } while (this.qryDatabaseCode(databaseCode));
        } else if (swapInsertDatabaseInfoReqBO.getDatabaseTypeDesc().equals("ftp")) {
            String databaseCode;
            do {
                databaseCode = databaseInfoPO.getDeptCode() + "_ft" + number;
                databaseInfoPO.setDatabaseCode(databaseCode);
                ++number;
            } while (this.qryDatabaseCode(databaseCode));
        } else if (swapInsertDatabaseInfoReqBO.getDatabaseTypeDesc().equals("MaxCompute")) {
            String databaseCode;
            do {
                databaseCode = databaseInfoPO.getDeptCode() + "_od" + number;
                databaseInfoPO.setDatabaseCode(databaseCode);
                ++number;
            } while (this.qryDatabaseCode(databaseCode));
        } else {
            String databaseCode;
            do {
                databaseCode = databaseInfoPO.getDeptCode() + "_ot" + number;
                databaseInfoPO.setDatabaseCode(databaseCode);
                ++number;
            } while (this.qryDatabaseCode(databaseCode));
        }
        databaseInfoPO.setCreateTime(new Date());
        databaseInfoPO.setUpdateTime(new Date());
        databaseInfoPO.setStatus("1");
        if (null != swapInsertDatabaseInfoReqBO.getUserId()) {
            databaseInfoPO.setOperId(String.valueOf(swapInsertDatabaseInfoReqBO.getUserId()));
        }
        logger.info("\u767b\u5f55\u4eba\u5458\u59d3\u540duserinfo.name:" + swapInsertDatabaseInfoReqBO.getName());
        logger.info("\u767b\u5f55\u4eba\u5458\u59d3\u540duserinfo.username:" + swapInsertDatabaseInfoReqBO.getUsername());
        databaseInfoPO.setOperName(swapInsertDatabaseInfoReqBO.getName());
        try {
            databaseInfoPO.setUserPass(ConfigTools.encrypt((String)databaseInfoPO.getUserPass()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        databaseInfoPO.setDatabaseSource("1");
        logger.info("\u6570\u636e\u6e90\u65b0\u589e\u5165\u5e93PO\uff1a" + databaseInfoPO.toString());
        int insert = this.databaseInfoDao.insert(databaseInfoPO);
        if (insert < 1) {
            throw new ZTBusinessException("\u8c03\u7528\u5931\u8d25!");
        }
        if (null == databaseInfoPO.getUnid()) {
            rspBO.setCode("1");
            rspBO.setMessage("\u65b0\u589e\u5931\u8d25!");
            return rspBO;
        }
        DatabaseDbidInfoPO qryDatabaseDbidInfoPO = new DatabaseDbidInfoPO();
        qryDatabaseDbidInfoPO.setDatabaseCode(databaseInfoPO.getDatabaseCode());
        qryDatabaseDbidInfoPO.setStatus("1");
        DatabaseDbidInfoPO databaseDbidInfoPO1 = this.databaseDbidInfoDao.getModelBy(qryDatabaseDbidInfoPO);
        if (null == databaseDbidInfoPO1) {
            DatabaseDbidInfoPO databaseDbidInfoPO = new DatabaseDbidInfoPO();
            databaseDbidInfoPO.setDatabaseCode(databaseInfoPO.getDatabaseCode());
            databaseDbidInfoPO.setDbid(swapInsertDatabaseInfoReqBO.getDbId());
            databaseDbidInfoPO.setCreateTime(new Date());
            databaseDbidInfoPO.setUpdateTime(new Date());
            databaseDbidInfoPO.setStatus("1");
            databaseDbidInfoPO.setConfigState(swapInsertDatabaseInfoReqBO.getConfigState());
            int result1 = this.databaseDbidInfoDao.insert(databaseDbidInfoPO);
            if (result1 < 1) {
                throw new ZTBusinessException("\u65b0\u589e\u5931\u8d25!");
            }
        } else {
            databaseDbidInfoPO1.setDbid(swapInsertDatabaseInfoReqBO.getDbId());
            int result2 = this.databaseDbidInfoDao.updateById(databaseDbidInfoPO1);
            if (result2 < 1) {
                throw new ZTBusinessException("\u65b0\u589e\u5931\u8d25!");
            }
        }
        SwapInsertOperLogReqBO swapInsertOperLogReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)swapInsertDatabaseInfoReqBO, (Object)swapInsertOperLogReqBO);
        swapInsertOperLogReqBO.setOperType("A");
        swapInsertOperLogReqBO.setOperContent("\u65b0\u589e:" + swapInsertDatabaseInfoReqBO.getDatabaseName() + "\u6570\u636e\u6e90");
        this.log(swapInsertOperLogReqBO);
        rspBO.setCode("0");
        rspBO.setMessage("\u6210\u529f!");
        return rspBO;
    }

    private void validateParam(SwapInsertDatabaseInfoReqBO reqBO) {
        if (StringUtils.isEmpty((String)reqBO.getDeptCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u90e8\u95e8\u7f16\u7801\u3010DeptCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDeptName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u90e8\u95e8\u540d\u79f0\u3010DeptName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDatabaseName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u6e90\u3010databaseName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDatabaseType())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u6e90\u7c7b\u578b\u3010DatabaseType\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getDatabaseTypeDesc())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6570\u636e\u6e90\u7c7b\u578b\u63cf\u8ff0\u3010DatabaseTypeDesc\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getNodeCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8282\u70b9\u7f16\u7801\u3010nodeCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getNodeName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8282\u70b9\u540d\u79f0\u3010nodeName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getUserName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u7528\u6237\u540d\u3010userName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getUserPass())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5bc6\u7801\u3010UserPass\u3011\u4e3a\u7a7a");
        }
        if (null == reqBO.getDbId()) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8d44\u6e90\u76ee\u5f55\u6570\u636e\u6e90ID\u3010dbId\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSysCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u7cfb\u7edf\u7f16\u7801\u3010SysCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getSysName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u7cfb\u7edf\u540d\u79f0\u3010SysName\u3011\u4e3a\u7a7a");
        }
    }

    private void log(SwapInsertOperLogReqBO swapInsertOperLogReqBO) {
        SwapInsertOperLogRspBO swapInsertOperLogRspBO = this.swapInsertOperLogService.insertOperLog(swapInsertOperLogReqBO);
        if (!"0".equals(swapInsertOperLogRspBO.getCode())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25!");
        }
    }

    private boolean qryDatabaseCode(String databaseCode) {
        DatabaseInfoPO databaseInfoPO = new DatabaseInfoPO();
        databaseInfoPO.setDatabaseCode(databaseCode);
        databaseInfoPO.setStatus("1");
        DatabaseInfoPO databaseInfoPO1 = this.databaseInfoDao.getModelBy(databaseInfoPO);
        return null != databaseInfoPO1;
    }
}

