/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.database;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapSelectDictRspBO;
import com.yqsmartcity.data.swap.api.base.service.SwapInsertOperLogService;
import com.yqsmartcity.data.swap.api.base.service.SwapSelectDictService;
import com.yqsmartcity.data.swap.api.database.bo.DatabaseInfoBO;
import com.yqsmartcity.data.swap.api.database.bo.SwapQryDatabaseListReqBO;
import com.yqsmartcity.data.swap.api.database.bo.SwapQryDatabaseListRspBO;
import com.yqsmartcity.data.swap.api.database.service.SwapQryDatabaseListBusiService;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.DeptInfoDao;
import com.yqsmartcity.data.swap.dao.NodeInfoDao;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import com.yqsmartcity.data.swap.po.DeptInfoPO;
import com.yqsmartcity.data.swap.po.NodeInfoPO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SwapQryDatabaseListBusiServiceImpl
implements SwapQryDatabaseListBusiService {
    private static final Logger log = LoggerFactory.getLogger(SwapQryDatabaseListBusiServiceImpl.class);
    @Autowired
    private DatabaseInfoDao databaseInfoDao;
    @Autowired
    private DeptInfoDao deptInfoDao;
    @Autowired
    private SwapInsertOperLogService swapInsertOperLogService;
    @Autowired
    private SwapSelectDictService swapSelectDictService;
    @Autowired
    private NodeInfoDao nodeInfoDao;

    @Transactional(rollbackFor={Exception.class})
    public SwapQryDatabaseListRspBO qryDatabaseListBusi(SwapQryDatabaseListReqBO reqBO) throws ZTBusinessException {
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        SwapQryDatabaseListRspBO rspBO = new SwapQryDatabaseListRspBO();
        ArrayList<DatabaseInfoBO> databaseInfoBOS = new ArrayList<DatabaseInfoBO>();
        DatabaseInfoPO databaseInfoPO = new DatabaseInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)databaseInfoPO);
        databaseInfoPO.setDatabaseName(SwapQryDatabaseListBusiServiceImpl.queryString(reqBO.getDatabaseName()));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!StringUtils.isEmpty((String)reqBO.getCreateTime())) {
            String[] createTimeList = reqBO.getCreateTime().split("~");
            String createTimeStart = createTimeList[0].trim() + " 00:00:00";
            String createTimeEnd = createTimeList[1].trim() + " 23:59:59";
            try {
                Date createStart = sdf.parse(createTimeStart);
                Date EndStart = sdf.parse(createTimeEnd);
                databaseInfoPO.setCreateStart(createStart);
                databaseInfoPO.setCreateEnd(EndStart);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (!StringUtils.isEmpty((String)reqBO.getUpdateTime())) {
            String[] updateTimeList = reqBO.getUpdateTime().split("~");
            String updateTimeStart = updateTimeList[0].trim() + " 00:00:00";
            String updateTimeEnd = updateTimeList[1].trim() + " 23:59:59";
            try {
                Date updateStart = sdf.parse(updateTimeStart);
                Date updateEnd = sdf.parse(updateTimeEnd);
                databaseInfoPO.setUpdateStart(updateStart);
                databaseInfoPO.setUpdateEnd(updateEnd);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        databaseInfoPO.setStatus("1");
        databaseInfoPO.setDatabaseSource("1");
        List<DatabaseInfoPO> databaseInfoPOList = this.databaseInfoDao.getListPage((Page<DatabaseInfoPO>)page, databaseInfoPO);
        for (DatabaseInfoPO databaseInfoPO1 : databaseInfoPOList) {
            DatabaseInfoBO databaseInfoBO = new DatabaseInfoBO();
            BeanUtils.copyProperties((Object)databaseInfoPO1, (Object)databaseInfoBO);
            if (!StringUtils.isEmpty((String)databaseInfoPO1.getDeptCode())) {
                DeptInfoPO deptInfoPO = new DeptInfoPO();
                deptInfoPO.setDeptCode(databaseInfoPO1.getDeptCode());
                deptInfoPO.setStatus("1");
                DeptInfoPO deptInfoPO1 = this.deptInfoDao.getModelBy(deptInfoPO);
                if (null != deptInfoPO1) {
                    databaseInfoBO.setDeptName(deptInfoPO1.getDeptName());
                    databaseInfoBO.setDeptCode(deptInfoPO1.getSourceDeptCode());
                }
            }
            NodeInfoPO qryNodeInfoPO = new NodeInfoPO();
            qryNodeInfoPO.setNodeCode(databaseInfoBO.getNodeCode());
            qryNodeInfoPO.setStatus("1");
            NodeInfoPO nodeInfoPO = this.nodeInfoDao.getModelBy(qryNodeInfoPO);
            if (null != nodeInfoPO) {
                databaseInfoBO.setNodeName(nodeInfoPO.getNodeName());
            }
            databaseInfoBO.setDatabaseTypeDesc(this.getSysPara(databaseInfoBO.getDatabaseType(), "DATABASE_TYPE"));
            databaseInfoBO.setUserPass("******");
            databaseInfoBOS.add(databaseInfoBO);
        }
        rspBO.setRows(databaseInfoBOS);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    private void validateParam(SwapQryDatabaseListReqBO reqBO) {
    }

    private String getSysPara(String paraCode, String paraType) {
        SwapSelectDictReqBO swapSelectDictReqBO = new SwapSelectDictReqBO();
        swapSelectDictReqBO.setParaCode(paraCode);
        swapSelectDictReqBO.setParaType(paraType);
        SwapSelectDictRspBO swapSelectDictRspBO = this.swapSelectDictService.queryDict(swapSelectDictReqBO);
        if ("0".equals(swapSelectDictRspBO.getCode()) && null != swapSelectDictRspBO.getSysParaBO()) {
            String descrip = swapSelectDictRspBO.getSysParaBO().getParaName();
            return null == descrip ? "" : descrip;
        }
        return "";
    }

    public static String queryString(String temp) {
        if (temp == null || temp == "") {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(temp.trim());
        StringBuilder tempBuilder = new StringBuilder();
        tempBuilder.append(temp.trim());
        int j = 0;
        for (int i = 0; i < b.length(); ++i) {
            char x = b.charAt(i);
            if (x != '%' && x != '_') continue;
            tempBuilder.insert(i + j, '\\');
            ++j;
        }
        return tempBuilder.toString();
    }
}

