/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.dataworks;

import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileListReqBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileReqBO;
import com.yqsmartcity.data.swap.api.dataworks.service.CreateDWXmlFileService;
import com.yqsmartcity.data.swap.constant.SwapCommConstant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CreateDWXmlFileServiceImpl
implements CreateDWXmlFileService {
    private static final Logger log = LoggerFactory.getLogger(CreateDWXmlFileServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(CreateDWXmlFileServiceImpl.class);
    @Value(value="${dataworks.xml.type}")
    String dataworksXmlType;
    @Value(value="${odps.project.name}")
    String odpsProjectName;
    private String folderDiPathName = "folderDi";
    private String folderMaxComputePathName = "folderMaxCompute";
    private String bizInfoVersion = "1";
    private String folderVersion = "1";
    private String commitStatus = "0";

    private void addFolderElement(Element folders, String deptName, String engineType) throws Exception {
        Element folder = folders.addElement("folder");
        folder.addAttribute("folderItemType", "2");
        if ("MaxCompute".equalsIgnoreCase(engineType)) {
            folder.addAttribute("folderItemName", this.folderMaxComputePathName);
            folder.addAttribute("folderItemPath", "bizroot/" + deptName + "/" + this.folderMaxComputePathName);
            folder.addAttribute("type", "2");
            folder.addAttribute("engineType", "MaxCompute");
        } else if ("folderDi".equalsIgnoreCase(engineType)) {
            folder.addAttribute("folderItemName", this.folderDiPathName);
            folder.addAttribute("folderItemPath", "bizroot/" + deptName + "/" + this.folderDiPathName);
            folder.addAttribute("type", "1");
            folder.addAttribute("engineType", "Data Integration");
        } else {
            folder.addAttribute("folderItemName", deptName);
            folder.addAttribute("folderItemPath", "bizroot/" + deptName);
            folder.addAttribute("type", "0");
        }
        folder.addAttribute("bizId", deptName);
        folder.addAttribute("bizUseType", "0");
        folder.addAttribute("subType", "0");
        folder.addAttribute("sourceApp", "ide");
        folder.addAttribute("version", this.folderVersion);
        folder.addAttribute("labelFlags", "[]");
    }

    private void addOtherFileElement(Element otherFile, String deptName, String tableName, String engineType, String bizType2) throws Exception {
        if ("MaxCompute".equalsIgnoreCase(engineType)) {
            otherFile.addAttribute("sourcePath", "bizroot/" + deptName + "/" + this.folderMaxComputePathName + "/" + SwapCommConstant.tablePrefix.get(bizType2) + tableName + "_" + bizType2 + ".txt");
            otherFile.addAttribute("fileName", SwapCommConstant.tablePrefix.get(bizType2) + tableName + "_" + bizType2);
            otherFile.addAttribute("fileType", "10");
            otherFile.addAttribute("fileDelete", "0");
            otherFile.addAttribute("isUserNode", "0");
            otherFile.addAttribute("connName", "odps_first");
            otherFile.addAttribute("labelName", "folderProcess");
            otherFile.addAttribute("folderPath", "bizroot/" + deptName + "/" + this.folderMaxComputePathName);
            otherFile.addAttribute("useType", "0");
            otherFile.addAttribute("nodeId", SwapCommConstant.tablePrefix.get(bizType2) + tableName + "_" + bizType2);
        } else if ("folderDi".equalsIgnoreCase(engineType)) {
            otherFile.addAttribute("sourcePath", "bizroot/" + deptName + "/" + this.folderDiPathName + "/" + SwapCommConstant.tablePrefix.get(bizType2) + tableName + "_" + bizType2 + ".txt");
            otherFile.addAttribute("fileName", SwapCommConstant.tablePrefix.get(bizType2) + tableName + "_" + bizType2);
            otherFile.addAttribute("fileType", "23");
            otherFile.addAttribute("fileDelete", "0");
            otherFile.addAttribute("isUserNode", "0");
            otherFile.addAttribute("folderPath", "bizroot/" + deptName + "/" + this.folderDiPathName);
            otherFile.addAttribute("useType", "0");
            otherFile.addAttribute("nodeId", SwapCommConstant.tablePrefix.get(bizType2) + tableName + "_" + bizType2);
            otherFile.addAttribute("extend", "{\"mode\":\"wizard\",\"resourceGroup\":\"group_190857053002656\"}");
        }
        otherFile.addAttribute("commitStatus", this.commitStatus);
        otherFile.addAttribute("owner", "287326168777888303");
        otherFile.addAttribute("isAutoParse", "0");
        otherFile.addAttribute("bizId", deptName);
        otherFile.addAttribute("bizUseType", "0");
        otherFile.addAttribute("isOdps", "1");
    }

    private void addOtherFilesElement(Element otherFiles, String deptName, String tableName, String engineType, String bizType2, String partValue, String parentBizType) throws Exception {
        Element otherFile = otherFiles.addElement("otherFile");
        this.addOtherFileElement(otherFile, deptName, tableName, engineType, bizType2);
        Element fileRelations = otherFile.addElement("fileRelations");
        Element fileRelation = fileRelations.addElement("fileRelation");
        if ("root".equals(parentBizType)) {
            fileRelation.addAttribute("parentId", this.odpsProjectName + "_" + parentBizType);
        } else {
            fileRelation.addAttribute("parentId", tableName + "_" + parentBizType);
            if ("sync".equalsIgnoreCase(parentBizType)) {
                fileRelation.addAttribute("parentFileFolderPath", "bizroot/" + deptName + "/" + this.folderDiPathName);
            } else {
                fileRelation.addAttribute("parentFileFolderPath", "bizroot/" + deptName + "/" + this.folderMaxComputePathName);
            }
        }
        fileRelation.addAttribute("parentFileDelete", "0");
        fileRelation.addAttribute("refTable", "");
        Element nodeDef = otherFile.addElement("nodeDef");
        CreateDWXmlFileServiceImpl.addNodeDefElement(nodeDef, deptName, tableName, engineType, bizType2, partValue);
        Element nodeInputOutputs = otherFile.addElement("nodeInputOutputs");
        Element nodeInputOutput = nodeInputOutputs.addElement("nodeInputOutput");
        nodeInputOutput.addAttribute("parseType", "2");
        nodeInputOutput.addAttribute("type", "1");
        nodeInputOutput.addAttribute("str", "zl_stg.500422963_out");
        nodeInputOutput.addAttribute("refTableName", tableName);
    }

    private static void addNodeDefElement(Element nodeDef, String deptName, String tableName, String engineType, String bizType2, String partValue) throws Exception {
        if ("MaxCompute".equalsIgnoreCase(engineType)) {
            nodeDef.addAttribute("nodeName", SwapCommConstant.tablePrefix.get(bizType2) + tableName + "_" + bizType2);
            nodeDef.addAttribute("fileId", SwapCommConstant.tablePrefix.get(bizType2) + tableName + "_" + bizType2);
        } else if ("folderDi".equalsIgnoreCase(engineType)) {
            nodeDef.addAttribute("nodeName", SwapCommConstant.tablePrefix.get(bizType2) + tableName);
            nodeDef.addAttribute("fileId", SwapCommConstant.tablePrefix.get(bizType2) + tableName);
        }
        nodeDef.addAttribute("isStop", "0");
        nodeDef.addAttribute("paraValue", "bizdate=$bizdate taskid=$taskid beforebizdate=${yyyymmdd-1} begintime=$[yyyy-mm-ddhh24:mi-1/24] endtime=$[yyyy-mm-ddhh24:mi] " + partValue);
        nodeDef.addAttribute("startEffectDate", "1970-01-01 00:00:00");
        nodeDef.addAttribute("endEffectDate", "9999-01-01 00:00:00");
        nodeDef.addAttribute("cronExpress", "00 52 00 * * ?");
        nodeDef.addAttribute("owner", "287326168777888303");
        nodeDef.addAttribute("resGroupId", "7146");
        nodeDef.addAttribute("createTime", new Date().toString());
        nodeDef.addAttribute("createUser", "287326168777888303");
        nodeDef.addAttribute("lastModifyTime", new Date().toString());
        nodeDef.addAttribute("cycleType", "0");
        nodeDef.addAttribute("dependentType", "0");
        nodeDef.addAttribute("lastModifyUser", "287326168777888303");
        nodeDef.addAttribute("dependentDataNode", "");
        nodeDef.addAttribute("input", "");
        nodeDef.addAttribute("output", "[{\"str\":\"" + tableName + "_" + bizType2 + "\",\"parseType\":2,\"refTableName\":\"" + SwapCommConstant.tablePrefix.get(bizType2) + tableName + "_" + bizType2 + "\"}]");
        nodeDef.addAttribute("reRunAble", "1");
        nodeDef.addAttribute("taskReRunTime", "0");
        nodeDef.addAttribute("taskReRunInterval", "0");
    }

    public StringBuffer createXml(CreateImportFileListReqBO createImportFileBO) {
        StringBuffer returnString = new StringBuffer();
        Document document = DocumentHelper.createDocument();
        if ("private_cloud".equalsIgnoreCase(this.dataworksXmlType)) {
            this.folderDiPathName = "\u6570\u636e\u96c6\u6210";
            this.folderMaxComputePathName = "\u6570\u636e\u5f00\u53d1";
            this.bizInfoVersion = "0";
            this.folderVersion = "0";
            this.commitStatus = "1";
        }
        logger.info("=========folderDiPathName=" + this.folderDiPathName + ",dataworksXmlType=" + this.dataworksXmlType);
        try {
            Element rss = document.addElement("application");
            Element zType = rss.addElement("zipType");
            zType.addAttribute("zipType", "new");
            Element solutions = rss.addElement("solutions");
            Element bizInfos = rss.addElement("bizInfos");
            List deptNameList = createImportFileBO.getListCreateImportFileReqBO().stream().map(CreateImportFileReqBO::getDeptName).distinct().collect(Collectors.toList());
            ArrayList<String> disBusiFlowName = new ArrayList<String>();
            for (String bizType2 : createImportFileBO.getBizType().split(",")) {
                disBusiFlowName.add((String)SwapCommConstant.busiFlowName.get(bizType2));
            }
            List listbusiFlowName = disBusiFlowName.stream().distinct().collect(Collectors.toList());
            for (String deptName : deptNameList) {
                for (Object bizType3 : listbusiFlowName) {
                    Element bizInfo = bizInfos.addElement("bizInfo");
                    bizInfo.addAttribute("bizName", deptName + (String)bizType3);
                    bizInfo.addAttribute("owner", "");
                    bizInfo.addAttribute("sourceApp", "ide");
                    bizInfo.addAttribute("useType", "0");
                    bizInfo.addAttribute("version", this.bizInfoVersion);
                    bizInfo.addElement("refBizSols");
                }
            }
            Element folders = rss.addElement("folders");
            for (String deptName : deptNameList) {
                for (String bizType4 : listbusiFlowName) {
                    this.addFolderElement(folders, deptName + bizType4, "");
                    this.addFolderElement(folders, deptName + bizType4, "folderDi");
                    this.addFolderElement(folders, deptName + bizType4, "MaxCompute");
                }
            }
            Element resourceFiles = rss.addElement("resourceFiles");
            Element udfFiles = rss.addElement("udfFiles");
            Element otherFiles = rss.addElement("otherFiles");
            for (CreateImportFileReqBO importFileReqBO : createImportFileBO.getListCreateImportFileReqBO()) {
                String partitionValue = "partitionvalue=${yyyymmdd}";
                if ("h".equalsIgnoreCase(importFileReqBO.getSwapCycle())) {
                    partitionValue = "partitionvalue=$[yyyymmddhh241/24]";
                } else if ("mi".equalsIgnoreCase(importFileReqBO.getSwapCycle())) {
                    partitionValue = "partitionvalue=$[yyyymmddhh24mi1/24]";
                }
                String[] bizType5 = createImportFileBO.getBizType().split(",");
                for (int i = 0; i < bizType5.length; ++i) {
                    String parentBizType = "root";
                    if (i >= 1) {
                        parentBizType = bizType5[i - 1];
                    }
                    if ("sync".equalsIgnoreCase(bizType5[i]) || "sum_sync".equalsIgnoreCase(bizType5[i])) {
                        this.addOtherFilesElement(otherFiles, importFileReqBO.getDeptName() + SwapCommConstant.busiFlowName.get(bizType5[i]), importFileReqBO.getTableName(), "folderDi", bizType5[i], partitionValue, parentBizType);
                        continue;
                    }
                    this.addOtherFilesElement(otherFiles, importFileReqBO.getDeptName() + SwapCommConstant.busiFlowName.get(bizType5[i]), importFileReqBO.getTableName(), "MaxCompute", bizType5[i], partitionValue, parentBizType);
                }
            }
            Element element = rss.addElement("innerFiles");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u751f\u6210rss.xml\u5931\u8d25");
        }
        returnString.append(document.asXML());
        return returnString;
    }
}

