/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.dataworks;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileListReqBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileReqBO;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileRspBO;
import com.yqsmartcity.data.swap.api.dataworks.service.CreateDWXmlFileService;
import com.yqsmartcity.data.swap.api.dataworks.service.CreateEngineInfoTxtFileService;
import com.yqsmartcity.data.swap.api.dataworks.service.CreateFolderDiTxtFileService;
import com.yqsmartcity.data.swap.api.dataworks.service.CreateImportFileService;
import com.yqsmartcity.data.swap.api.dataworks.service.GoveGetAdStringService;
import com.yqsmartcity.data.swap.api.dataworks.service.GoveGetDDlStringService;
import com.yqsmartcity.data.swap.api.dataworks.service.GoveGetSumStringService;
import com.yqsmartcity.data.swap.api.dataworks.service.GoveGetSyncScriptStringService;
import com.yqsmartcity.data.swap.api.linkdb.bo.ColumnBO;
import com.yqsmartcity.data.swap.constant.SwapCommConstant;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CreateImportFileServiceImpl
implements CreateImportFileService {
    private static final Logger log = LoggerFactory.getLogger(CreateImportFileServiceImpl.class);
    @Value(value="${dataworks.xml.type}")
    String dataworksXmlType;
    @Autowired
    private CreateDWXmlFileService createDWXmlFileService;
    @Autowired
    private CreateEngineInfoTxtFileService createEngineInfoTxtFileService;
    @Autowired
    private CreateFolderDiTxtFileService createFolderDiTxtFileService;
    @Autowired
    private GoveGetSyncScriptStringService goveGetSyncScriptStringService;
    @Autowired
    private GoveGetDDlStringService goveGetDDlStringService;
    @Autowired
    private GoveGetSumStringService goveGetSumStringService;
    @Autowired
    private GoveGetAdStringService goveGetAdStringService;

    public List<CreateImportFileRspBO> createImportFile(CreateImportFileListReqBO createImportFileListReqBO) throws ZTBusinessException {
        ArrayList<CreateImportFileRspBO> createImportFileRspBOList = new ArrayList<CreateImportFileRspBO>();
        this.validateParam(createImportFileListReqBO);
        int xmlSum = 0;
        if (StringUtils.isEmpty((CharSequence)createImportFileListReqBO.getBizType())) {
            createImportFileListReqBO.setBizType("ddl,sync,sum,ad");
        }
        CreateImportFileRspBO createImportFileRspBO = new CreateImportFileRspBO();
        ArrayList<CreateImportFileBO> reateImportFileBO = new ArrayList<CreateImportFileBO>();
        CreateImportFileListReqBO createImportFileBO = new CreateImportFileListReqBO();
        String folderDiPathName = "folderDi";
        String folderMaxComputePathName = "folderMaxCompute";
        if ("private_cloud".equalsIgnoreCase(this.dataworksXmlType)) {
            folderDiPathName = "\u6570\u636e\u96c6\u6210";
            folderMaxComputePathName = "\u6570\u636e\u5f00\u53d1";
        }
        for (CreateImportFileReqBO importFileBO : createImportFileListReqBO.getListCreateImportFileReqBO()) {
            if ("all".equalsIgnoreCase(createImportFileListReqBO.getZipType())) {
                if (xmlSum >= createImportFileListReqBO.getListCreateImportFileReqBO().size()) break;
                xmlSum = createImportFileListReqBO.getListCreateImportFileReqBO().size() - 1;
                BeanUtils.copyProperties((Object)createImportFileListReqBO, (Object)createImportFileBO);
            } else {
                ArrayList<CreateImportFileReqBO> createImportFileReqBOList = new ArrayList<CreateImportFileReqBO>();
                createImportFileReqBOList.add(importFileBO);
                createImportFileBO.setZipType(createImportFileListReqBO.getZipType());
                createImportFileBO.setBizType(createImportFileListReqBO.getBizType());
                createImportFileBO.setListCreateImportFileReqBO(createImportFileReqBOList);
            }
            if (xmlSum++ < createImportFileListReqBO.getListCreateImportFileReqBO().size()) {
                createImportFileRspBO = new CreateImportFileRspBO();
                reateImportFileBO = new ArrayList();
                createImportFileRspBO.setZipName("temp_" + importFileBO.getTableName());
                CreateImportFileBO xmlFileBO = new CreateImportFileBO();
                xmlFileBO.setFileName(importFileBO.getTableName() + "." + "xml");
                xmlFileBO.setFilePath("");
                xmlFileBO.setFileType("xml");
                xmlFileBO.setFileContent(this.createDWXmlFileService.createXml(createImportFileBO));
                reateImportFileBO.add(xmlFileBO);
                CreateImportFileBO engineInfoFileBO = new CreateImportFileBO();
                engineInfoFileBO.setFileName("engineInfo.txt");
                engineInfoFileBO.setFilePath("");
                engineInfoFileBO.setFileType("txt");
                engineInfoFileBO.setFileContent(this.createEngineInfoTxtFileService.createEngineInfoTxt(createImportFileBO));
                reateImportFileBO.add(engineInfoFileBO);
                CreateImportFileBO versionFileBO = new CreateImportFileBO();
                versionFileBO.setFileName("version.txt");
                versionFileBO.setFilePath("");
                versionFileBO.setFileType("txt");
                versionFileBO.setFileContent(new StringBuffer("V3"));
                reateImportFileBO.add(versionFileBO);
            }
            for (CreateImportFileReqBO createimportFileReqBO : createImportFileBO.getListCreateImportFileReqBO()) {
                for (String bizType2 : createImportFileBO.getBizType().split(",")) {
                    if ("sync".equalsIgnoreCase(bizType2)) {
                        CreateImportFileBO folderDiFileBO = new CreateImportFileBO();
                        folderDiFileBO.setFileName(SwapCommConstant.tablePrefix.get(bizType2) + createimportFileReqBO.getTableName() + "_" + bizType2 + ".txt");
                        folderDiFileBO.setFilePath("file_content\\bizroot\\" + createimportFileReqBO.getDeptName() + SwapCommConstant.busiFlowName.get(bizType2) + "\\" + folderDiPathName);
                        folderDiFileBO.setFileType("txt");
                        folderDiFileBO.setFileContent(this.createFolderDiTxtFileService.createFolderDiTxt(createimportFileReqBO));
                        reateImportFileBO.add(folderDiFileBO);
                        continue;
                    }
                    CreateImportFileBO odpsSqlFileBO = new CreateImportFileBO();
                    odpsSqlFileBO.setFileName(SwapCommConstant.tablePrefix.get(bizType2) + createimportFileReqBO.getTableName() + "_" + bizType2 + ".txt");
                    odpsSqlFileBO.setFilePath("file_content\\bizroot\\" + createimportFileReqBO.getDeptName() + SwapCommConstant.busiFlowName.get(bizType2) + "\\" + folderMaxComputePathName);
                    odpsSqlFileBO.setFileType("txt");
                    if ("ddl".equalsIgnoreCase(bizType2)) {
                        odpsSqlFileBO.setFileContent(this.goveGetDDlStringService.createOdpsTable(createimportFileReqBO));
                        reateImportFileBO.add(odpsSqlFileBO);
                        continue;
                    }
                    if ("sum".equalsIgnoreCase(bizType2)) {
                        odpsSqlFileBO.setFileContent(this.goveGetSumStringService.sumStr(createimportFileReqBO));
                        reateImportFileBO.add(odpsSqlFileBO);
                        continue;
                    }
                    if (!"ad".equalsIgnoreCase(bizType2)) continue;
                    odpsSqlFileBO.setFileContent(this.goveGetAdStringService.adStr(createimportFileReqBO));
                    reateImportFileBO.add(odpsSqlFileBO);
                }
            }
            createImportFileRspBO.setReateImportFileBO(reateImportFileBO);
            createImportFileRspBOList.add(createImportFileRspBO);
        }
        return createImportFileRspBOList;
    }

    public void txtFile(StringBuffer odpsSql, String path, String fileName) {
        try {
            File writename = new File(path);
            if (!writename.exists()) {
                writename.mkdirs();
            }
            writename = new File(path + "\\" + fileName);
            writename.createNewFile();
            try (BufferedWriter out = new BufferedWriter(new FileWriter(writename));){
                out.write(odpsSql.toString());
                out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void xmlFile(StringBuffer document, String path, String fileName) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            File writename = new File(path);
            if (!writename.exists()) {
                writename.mkdirs();
            }
            File file = new File(path + "\\" + fileName + ".xml");
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(file), format);
            writer.setEscapeText(false);
            writer.write((Object)document);
            writer.close();
            System.out.println("\u751f\u6210rss.xml\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void validateParam(CreateImportFileListReqBO createImportFileListReqBO) {
        for (CreateImportFileReqBO importFileReqBO : createImportFileListReqBO.getListCreateImportFileReqBO()) {
            if (StringUtils.isEmpty((CharSequence)importFileReqBO.getDeptName())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u90e8\u95e8\u540d\u79f0\u3010DeptName\u3011\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)importFileReqBO.getDeptNo())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u90e8\u95e8\u7f16\u7801\u3010DeptNo\u3011\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)importFileReqBO.getTableName())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8868\u540d\u3010TableName\u3011\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)importFileReqBO.getSourceTableName())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u6765\u6e90\u8868\u540d\u3010sourceTableName\u3011\u4e3a\u7a7a");
            }
            List listColumnBO = importFileReqBO.getColumnBo();
            if (listColumnBO == null) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8868\u5b57\u6bb5\u3010ColumnBO\u3011\u4e3a\u7a7a");
            }
            for (ColumnBO columnBO : listColumnBO) {
                if (StringUtils.isEmpty((CharSequence)columnBO.getColumnName())) {
                    throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8868\u5b57\u6bb5\u540d\u3010ColumnName\u3011\u4e3a\u7a7a");
                }
                if (!StringUtils.isEmpty((CharSequence)columnBO.getColumnType())) continue;
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8868\u5b57\u6bb5\u7c7b\u578b\u3010ColumnType\u3011\u4e3a\u7a7a");
            }
        }
    }
}

