/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.dataworks;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.dataX.bo.DataXRWHDFSBO;
import com.yqsmartcity.data.swap.api.dataX.bo.DataXRWMysqlBO;
import com.yqsmartcity.data.swap.api.dataworks.service.SwapGetDataWorksJsonConfService;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.SysParaDao;
import com.yqsmartcity.data.swap.interfaces.bo.DataShareSubscribeReqBO;
import com.yqsmartcity.data.swap.interfaces.db.bo.ExternalColumnBO;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import com.yqsmartcity.data.swap.po.SysParaPO;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SwapGetDataWorksJsonConfServiceImpl
implements SwapGetDataWorksJsonConfService {
    private static final Logger log = LoggerFactory.getLogger(SwapGetDataWorksJsonConfServiceImpl.class);
    @Autowired
    private SysParaDao sysParaDao;
    @Autowired
    private DatabaseInfoDao databaseInfoDao;

    public StringBuffer getDataWorksJson(DataShareSubscribeReqBO reqBO) throws ZTBusinessException {
        SysParaPO sysParaPO = new SysParaPO();
        sysParaPO.setParaType("DATAX_DATA_TYPE_HIVE");
        sysParaPO.setStatus("1");
        sysParaPO.setOrderBy("sort");
        List<SysParaPO> sysParaPOList = this.sysParaDao.getList(sysParaPO);
        Map<String, String> dataXDataType = sysParaPOList.stream().collect(Collectors.toMap(SysParaPO::getParaCode, SysParaPO::getParaName));
        String sourceDbCode = reqBO.getSourceDatabaseCode();
        String targetDbCode = reqBO.getTargetDatabaseCode();
        DataXRWMysqlBO dataXRWMysqlBO = new DataXRWMysqlBO();
        dataXRWMysqlBO.setReaderUserName(reqBO.getSourceDataSourceInfo().getDbUserName());
        dataXRWMysqlBO.setReaderDbName(sourceDbCode);
        dataXRWMysqlBO.setReaderPassword(reqBO.getSourceDataSourceInfo().getDbPasswd());
        dataXRWMysqlBO.setReaderTableName(reqBO.getSourceDbTableName());
        dataXRWMysqlBO.setReaderColumn(SwapGetDataWorksJsonConfServiceImpl.getTableCol(reqBO.getSourceDbColumnBo(), reqBO.getSourceDataSourceInfo().getDbType(), dataXDataType, "reader"));
        JSONObject readerJSON = null;
        if ("MySQL".equals(reqBO.getSourceDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setName("MySQL");
            dataXRWMysqlBO.setReaderQuerySql(reqBO.getSourceDbQuerySql());
            readerJSON = SwapGetDataWorksJsonConfServiceImpl.mysqlReader(dataXRWMysqlBO);
        } else if ("Oracle".equals(reqBO.getSourceDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setName("Oracle");
            readerJSON = SwapGetDataWorksJsonConfServiceImpl.mysqlReader(dataXRWMysqlBO);
        } else if ("SqlServer".equals(reqBO.getSourceDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setName("SqlServer");
            readerJSON = SwapGetDataWorksJsonConfServiceImpl.mysqlReader(dataXRWMysqlBO);
        } else if ("Hive".equals(reqBO.getSourceDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setName("hdfsreader");
            DataXRWHDFSBO dataXRWHDFSBO = new DataXRWHDFSBO();
            BeanUtils.copyProperties((Object)dataXRWMysqlBO, (Object)dataXRWHDFSBO);
            dataXRWHDFSBO.setDefaultFS("hdfs://" + reqBO.getSourceDataSourceInfo().getDbJDBCUrl());
            dataXRWHDFSBO.setPath(reqBO.getSourceDbPath());
            readerJSON = SwapGetDataWorksJsonConfServiceImpl.hdfsReader(dataXRWHDFSBO);
        } else {
            throw new ZTBusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u6570\u636e\u5e93\u7c7b\u578b\u7684\u8bfb\u53d6\uff01");
        }
        JSONObject writerJSON = null;
        dataXRWMysqlBO.setWriterUserName(reqBO.getTargetDataSourceInfo().getDbUserName());
        dataXRWMysqlBO.setWriterDbName(targetDbCode);
        dataXRWMysqlBO.setWriterPassword(reqBO.getTargetDataSourceInfo().getDbPasswd());
        dataXRWMysqlBO.setWriterTableName(reqBO.getTargetDbTableName());
        dataXRWMysqlBO.setWriterColumn(SwapGetDataWorksJsonConfServiceImpl.getTableCol(reqBO.getTargetDbColumnBO(), reqBO.getTargetDataSourceInfo().getDbType(), dataXDataType, "writer"));
        if ("MySQL".equals(reqBO.getTargetDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setName("MySQL");
            writerJSON = SwapGetDataWorksJsonConfServiceImpl.mysqlWriter(dataXRWMysqlBO);
        } else if ("SqlServer".equals(reqBO.getTargetDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setName("SqlServer");
            writerJSON = SwapGetDataWorksJsonConfServiceImpl.mysqlWriter(dataXRWMysqlBO);
        } else if ("Oracle".equals(reqBO.getTargetDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setName("Oracle");
            writerJSON = SwapGetDataWorksJsonConfServiceImpl.mysqlWriter(dataXRWMysqlBO);
        } else if ("Hive".equals(reqBO.getTargetDataSourceInfo().getDbType())) {
            dataXRWMysqlBO.setName("hdfswriter");
            DataXRWHDFSBO dataXRWHDFSBO = new DataXRWHDFSBO();
            BeanUtils.copyProperties((Object)dataXRWMysqlBO, (Object)dataXRWHDFSBO);
            dataXRWHDFSBO.setDefaultFS("hdfs://" + reqBO.getTargetDataSourceInfo().getDbJDBCUrl());
            dataXRWHDFSBO.setFileName(reqBO.getTargetDbTableName());
            dataXRWHDFSBO.setPath(reqBO.getTargetDbPath());
            writerJSON = SwapGetDataWorksJsonConfServiceImpl.hdfsWriter(dataXRWHDFSBO);
        } else {
            throw new ZTBusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u6570\u636e\u5e93\u7c7b\u578b\u7684\u5199\u5165\uff01");
        }
        HashMap<String, Object> job = new HashMap<String, Object>();
        job.put("type", "mappers/job");
        job.put("version", "2.0");
        ArrayList<JSONObject> stepsList = new ArrayList<JSONObject>();
        stepsList.add(readerJSON);
        stepsList.add(writerJSON);
        job.put("steps", stepsList);
        HashMap settingMap = new HashMap();
        settingMap.put("executeMode", null);
        HashMap<String, Object> errorLimitMap = new HashMap<String, Object>();
        errorLimitMap.put("record", null);
        settingMap.put("errorLimit", errorLimitMap);
        HashMap<String, Constable> speedMap = new HashMap<String, Constable>();
        speedMap.put("concurrent", Integer.valueOf(1));
        speedMap.put("throttle", Boolean.valueOf(false));
        settingMap.put("speed", speedMap);
        job.put("setting", settingMap);
        HashMap<String, 1> orderMap = new HashMap<String, 1>();
        final HashMap<String, String> hopsMap = new HashMap<String, String>();
        hopsMap.put("from", "Reader");
        hopsMap.put("to", "Writer");
        orderMap.put("hops", new ArrayList<Object>(){
            {
                this.add(hopsMap);
            }
        });
        job.put("order", orderMap);
        String str = JSON.toJSONString(job);
        JSONObject object = JSONObject.parseObject((String)str);
        str = JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        StringBuffer buffer = new StringBuffer(str);
        return buffer;
    }

    static JSONObject getTableCol(List<ExternalColumnBO> columnBOList, String DBType, Map<String, String> dataXDataType, String rwFlag) {
        StringBuffer sql = new StringBuffer();
        int sortId = 0;
        for (ExternalColumnBO columm : columnBOList) {
            if ("sync_time".equals(columm.getColumnName())) continue;
            if (0 < sortId++) {
                sql.append(",");
            }
            if ("HIVE".equalsIgnoreCase(DBType)) {
                String colType = dataXDataType.get(columm.getDataType());
                String colType1 = StringUtils.isEmpty((Object)colType) ? columm.getDataType() : colType;
                HashMap<String, Object> hiveMap = new HashMap<String, Object>();
                if ("reader".equalsIgnoreCase(rwFlag)) {
                    hiveMap.put("index", sortId);
                } else {
                    hiveMap.put("name", columm.getColumnName());
                }
                hiveMap.put("type", colType1);
                sql.append(JSON.parseObject((String)JSON.toJSONString(hiveMap)));
                continue;
            }
            sql.append("\"" + columm.getColumnName() + "\"");
        }
        return JSON.parseObject((String)("{\"column\":[" + sql.toString() + "]}"));
    }

    static JSONObject mysqlReader(final DataXRWMysqlBO dataXRWMysqlBO) {
        HashMap<String, Object> stepsReaderMap = new HashMap<String, Object>();
        stepsReaderMap.put("name", "Reader");
        stepsReaderMap.put("category", "reader");
        stepsReaderMap.put("stepType", dataXRWMysqlBO.getName());
        HashMap<String, Object> stepsReaderparameterMap = new HashMap<String, Object>();
        stepsReaderparameterMap.put("envType", 1);
        stepsReaderparameterMap.put("datasource", dataXRWMysqlBO.getReaderDbName());
        stepsReaderparameterMap.put("column", dataXRWMysqlBO.getReaderColumn().get((Object)"column"));
        if ("MySQL".equals(dataXRWMysqlBO.getName())) {
            ArrayList connectionList = new ArrayList();
            HashMap<String, Object> connectionMap = new HashMap<String, Object>();
            connectionMap.put("datasource", dataXRWMysqlBO.getReaderDbName());
            if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getReaderQuerySql())) {
                connectionMap.put("querySql", new ArrayList<String>(){
                    {
                        this.add(dataXRWMysqlBO.getReaderQuerySql());
                    }
                });
            } else {
                connectionMap.put("table", new ArrayList<String>(){
                    {
                        this.add(dataXRWMysqlBO.getReaderTableName());
                    }
                });
            }
            connectionList.add(connectionMap);
            stepsReaderparameterMap.put("connection", connectionList);
        } else if ("Oracle".equals(dataXRWMysqlBO.getName())) {
            stepsReaderparameterMap.put("table", dataXRWMysqlBO.getReaderTableName());
        } else if ("SqlServer".equals(dataXRWMysqlBO.getName())) {
            stepsReaderparameterMap.put("table", dataXRWMysqlBO.getReaderTableName());
        }
        stepsReaderparameterMap.put("where", dataXRWMysqlBO.getReaderWhere());
        stepsReaderparameterMap.put("splitPk", dataXRWMysqlBO.getReaderSplitPk());
        stepsReaderparameterMap.put("encoding", "UTF-8");
        stepsReaderMap.put("parameter", stepsReaderparameterMap);
        return JSON.parseObject((String)JSON.toJSONString(stepsReaderMap));
    }

    static JSONObject mysqlWriter(final DataXRWMysqlBO dataXRWMysqlBO) {
        HashMap<String, Object> writerMap = new HashMap<String, Object>();
        writerMap.put("name", "Writer");
        writerMap.put("category", "writer");
        writerMap.put("stepType", dataXRWMysqlBO.getName());
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("writeMode", "insert");
        parameter.put("batchSize", 1024);
        parameter.put("encoding", "UTF-8");
        parameter.put("datasource", dataXRWMysqlBO.getWriterDbName());
        parameter.put("column", dataXRWMysqlBO.getWriterColumn().get((Object)"column"));
        parameter.put("table", dataXRWMysqlBO.getWriterTableName());
        ArrayList<String> preSql = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getWritePreSql())) {
            preSql.add(dataXRWMysqlBO.getWritePreSql());
        }
        if ("20".equalsIgnoreCase(dataXRWMysqlBO.getWriteMode())) {
            preSql.add("truncate table " + dataXRWMysqlBO.getWriterTableName() + ";");
        }
        parameter.put("preSql", preSql);
        if (!StringUtils.isEmpty((Object)dataXRWMysqlBO.getWritePostSql())) {
            parameter.put("postSql", new ArrayList<String>(){
                {
                    this.add(dataXRWMysqlBO.getWritePostSql());
                }
            });
        }
        writerMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(writerMap));
    }

    static JSONObject hdfsReader(DataXRWHDFSBO dataXRWHDFSBO) {
        HashMap<String, Object> hdfsMap = new HashMap<String, Object>();
        hdfsMap.put("name", "hdfsreader");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("path", dataXRWHDFSBO.getPath());
        parameter.put("defaultFS", dataXRWHDFSBO.getDefaultFS());
        parameter.put("column", dataXRWHDFSBO.getReaderColumn().get((Object)"column"));
        parameter.put("fileType", "text");
        parameter.put("encoding", "UTF-8");
        parameter.put("fieldDelimiter", "\u0001");
        hdfsMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(hdfsMap));
    }

    static JSONObject hdfsWriter(DataXRWHDFSBO dataXRWHDFSBO) {
        HashMap<String, Object> hdfsWriterMap = new HashMap<String, Object>();
        hdfsWriterMap.put("name", "hdfswriter");
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("path", dataXRWHDFSBO.getPath());
        parameter.put("defaultFS", dataXRWHDFSBO.getDefaultFS());
        parameter.put("fileName", dataXRWHDFSBO.getFileName());
        parameter.put("column", dataXRWHDFSBO.getWriterColumn().get((Object)"column"));
        parameter.put("fileType", "text");
        parameter.put("writeMode", StringUtils.isEmpty((Object)dataXRWHDFSBO.getWriteMode()) ? "append" : dataXRWHDFSBO.getWriteMode());
        parameter.put("encoding", "UTF-8");
        parameter.put("fieldDelimiter", "\u0001");
        hdfsWriterMap.put("parameter", parameter);
        return JSON.parseObject((String)JSON.toJSONString(hdfsWriterMap));
    }

    public String queryDatabaseInfo(String sourceDbType, String dbJDBCUrl, String userName, String passwd) {
        String databaseCode = "";
        DatabaseInfoPO databaseInfoPO = new DatabaseInfoPO();
        databaseInfoPO.setStatus("1");
        databaseInfoPO.setDatabaseType(sourceDbType);
        if ("MS".equals(sourceDbType)) {
            databaseInfoPO.setIpAddr(dbJDBCUrl.substring(13, dbJDBCUrl.indexOf(":", 13)));
            databaseInfoPO.setPortNum(dbJDBCUrl.substring(dbJDBCUrl.indexOf(":", 13) + 1, dbJDBCUrl.indexOf("/", 13)));
            databaseInfoPO.setServerName(dbJDBCUrl.substring(dbJDBCUrl.indexOf("/", 13) + 1));
        } else if ("OR".equals(sourceDbType)) {
            String[] sourceDbJDBCUrl = dbJDBCUrl.substring(18).split(":");
            databaseInfoPO.setIpAddr(sourceDbJDBCUrl[0]);
            databaseInfoPO.setPortNum(sourceDbJDBCUrl[1]);
            databaseInfoPO.setServerName(sourceDbJDBCUrl[2]);
        } else if ("SS".equals(sourceDbType)) {
            databaseInfoPO.setIpAddr(dbJDBCUrl.substring(17, dbJDBCUrl.indexOf(":", 17)));
            databaseInfoPO.setPortNum(dbJDBCUrl.substring(dbJDBCUrl.indexOf(":", 17) + 1, dbJDBCUrl.indexOf(";")));
            databaseInfoPO.setServerName(dbJDBCUrl.substring(dbJDBCUrl.indexOf("=") + 1));
        } else if ("CK".equals(sourceDbType)) {
            databaseInfoPO.setIpAddr(dbJDBCUrl.substring(18, dbJDBCUrl.indexOf(":", 18)));
            databaseInfoPO.setPortNum(dbJDBCUrl.substring(dbJDBCUrl.indexOf(":", 18) + 1, dbJDBCUrl.indexOf("/", 18)));
            databaseInfoPO.setServerName(dbJDBCUrl.substring(dbJDBCUrl.indexOf("/") + 1));
        } else {
            throw new ZTBusinessException("\u6e90\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u652f\u6301\uff01");
        }
        databaseInfoPO.setUserName(userName);
        databaseInfoPO.setUserPass(passwd);
        DatabaseInfoPO databaseInfoPOQry = this.databaseInfoDao.getModelBy(databaseInfoPO);
        if (null != databaseInfoPOQry) {
            databaseCode = databaseInfoPOQry.getDatabaseCode();
        } else {
            databaseInfoPO.setDatabaseCode(databaseInfoPO.getIpAddr() + "_" + databaseInfoPO.getDatabaseType() + "_" + databaseInfoPO.getServerName());
            databaseInfoPO.setDatabaseSource("1");
            this.databaseInfoDao.insert(databaseInfoPO);
            databaseCode = databaseInfoPO.getDatabaseCode();
        }
        return databaseCode;
    }
}

