/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.hdfs;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.base.bo.SwapQrySysParaListReqBO;
import com.yqsmartcity.data.swap.api.base.bo.SwapQrySysParaListRspBO;
import com.yqsmartcity.data.swap.api.base.bo.SysParaBO;
import com.yqsmartcity.data.swap.api.base.service.SwapQrySysParaListBusiService;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileReqBO;
import com.yqsmartcity.data.swap.api.dataworks.service.GoveGetDDlStringService;
import com.yqsmartcity.data.swap.api.hivedb.SwapGetHiveDDlStringService;
import com.yqsmartcity.data.swap.api.linkdb.bo.LinkOdpsBO;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkOdpsService;
import com.yqsmartcity.data.swap.dao.DataWorksDao;
import com.yqsmartcity.data.swap.dao.DatabaseInfoDao;
import com.yqsmartcity.data.swap.dao.TableColInfoDao;
import com.yqsmartcity.data.swap.dao.TableInfoDao;
import com.yqsmartcity.data.swap.interfaces.db.bo.UploadTableColInfoBO;
import com.yqsmartcity.data.swap.interfaces.db.bo.UploadTableInfoReqBO;
import com.yqsmartcity.data.swap.interfaces.db.bo.UploadTableInfoRspBO;
import com.yqsmartcity.data.swap.interfaces.db.service.CreateTable2DbService;
import com.yqsmartcity.data.swap.po.DatabaseInfoPO;
import com.yqsmartcity.data.swap.po.TableColInfoPO;
import com.yqsmartcity.data.swap.po.TableInfoPO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CreateTable2DbServiceImpl
implements CreateTable2DbService {
    private static final Logger log = LoggerFactory.getLogger(CreateTable2DbServiceImpl.class);
    @Value(value="${hdfs.updata.database}")
    private String databaseName;
    @Value(value="${technology.type}")
    private String technologyType;
    @Autowired
    private TableInfoDao tableInfoDao;
    @Autowired
    private TableColInfoDao tableColInfoDao;
    @Autowired
    private DatabaseInfoDao databaseInfoDao;
    @Autowired
    private DataWorksDao dataWorksDao;
    @Autowired
    private GoveGetDDlStringService goveGetDDlStringService;
    @Autowired
    private SwapGetHiveDDlStringService swapGetHiveDDlStringService;
    @Autowired
    private SwapLinkOdpsService swapLinkOdpsService;
    @Autowired
    private SwapQrySysParaListBusiService swapQrySysParaListBusiService;
    Map<String, String> odpsType = null;
    Map<String, String> hiveMysqlType = null;
    Map<String, String> hiveOracleType = null;
    Map<String, String> hiveSqlserverType = null;
    private static PreparedStatement ps;
    private static ResultSet rs;

    public UploadTableInfoRspBO createTable(UploadTableInfoReqBO uploadBo) throws ZTBusinessException {
        UploadTableInfoRspBO uploadTableInfoRspBO = new UploadTableInfoRspBO();
        this.validateParam(uploadBo);
        TableInfoPO tableInfoPO = new TableInfoPO();
        String strTable = CreateTable2DbServiceImpl.getRandom(7);
        tableInfoPO.setDatabaseTableId(uploadBo.getDatabaseCode() + strTable);
        tableInfoPO.setTaskId("");
        tableInfoPO.setDatabaseCode(uploadBo.getDatabaseCode());
        tableInfoPO.setSourceTable(uploadBo.getSourceTable());
        if (uploadBo.getSourceTable().length() >= 110) {
            tableInfoPO.setDatabaseTable(this.databaseName + "_" + uploadBo.getDatabaseCode() + "_n_" + uploadBo.getSourceTable().substring(0, 109));
        } else {
            tableInfoPO.setDatabaseTable(this.databaseName + "_" + uploadBo.getDatabaseCode() + "_y_" + uploadBo.getSourceTable());
        }
        ArrayList<String> tableNameList1 = new ArrayList<String>();
        tableNameList1.add(tableInfoPO.getDatabaseTable());
        List<CreateImportFileReqBO> listCreateImportFileReqBO1 = this.dataWorksDao.getListCreateImportFile(tableNameList1);
        if (!CollectionUtils.isEmpty(listCreateImportFileReqBO1)) {
            throw new ZTBusinessException("\u8868\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        BeanUtils.copyProperties((Object)tableInfoPO, (Object)uploadTableInfoRspBO);
        tableInfoPO.setDatabaseTableName(uploadBo.getDatabaseTableName());
        tableInfoPO.setConfigState("0");
        tableInfoPO.setCreateTime(new Date());
        tableInfoPO.setUpdateTime(new Date());
        tableInfoPO.setStatus("1");
        tableInfoPO.setSwapMode("");
        tableInfoPO.setQueryWhere("");
        tableInfoPO.setPartionMode("");
        tableInfoPO.setPartionWhere("");
        tableInfoPO.setLifeCycle("d");
        int tableInfoResult = this.tableInfoDao.insert(tableInfoPO);
        if (tableInfoResult < 1) {
            throw new ZTBusinessException("\u8868\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
        SwapQrySysParaListReqBO swapQrySysParaListReqBO = new SwapQrySysParaListReqBO();
        swapQrySysParaListReqBO.setParaType("TO_ODPS_TYPE");
        SwapQrySysParaListRspBO odpsTypeList = this.swapQrySysParaListBusiService.qrySysParaList(swapQrySysParaListReqBO);
        this.odpsType = odpsTypeList.getSysParaBOList().stream().collect(Collectors.toMap(SysParaBO::getParaCode, SysParaBO::getParaName));
        swapQrySysParaListReqBO.setParaType("MYSQL_TO_HIVE_TYPE");
        SwapQrySysParaListRspBO hiveMysqlTypeList = this.swapQrySysParaListBusiService.qrySysParaList(swapQrySysParaListReqBO);
        this.hiveMysqlType = hiveMysqlTypeList.getSysParaBOList().stream().collect(Collectors.toMap(SysParaBO::getParaCode, SysParaBO::getParaName));
        DatabaseInfoPO databaseInfoPO = new DatabaseInfoPO();
        databaseInfoPO.setDatabaseCode(tableInfoPO.getDatabaseCode());
        databaseInfoPO.setStatus("1");
        DatabaseInfoPO queryDatabaseInfoPO = this.databaseInfoDao.getModelBy(databaseInfoPO);
        if (queryDatabaseInfoPO == null) {
            throw new ZTBusinessException("databaseCode\u4e0d\u5b58\u5728\uff01");
        }
        int sortId = 1;
        ArrayList<TableColInfoPO> listTableColInfoPO = new ArrayList<TableColInfoPO>();
        for (UploadTableColInfoBO colList : uploadBo.getColumnInfo()) {
            TableColInfoPO insertTableColInfoPO = new TableColInfoPO();
            insertTableColInfoPO.setTableName(tableInfoPO.getDatabaseTable());
            insertTableColInfoPO.setColumnName(colList.getColumnName());
            String getDataType = null;
            if ("dataworks".equals(this.technologyType)) {
                if (null != this.odpsType.get(colList.getDataType())) {
                    getDataType = this.odpsType.get(colList.getDataType());
                }
            } else if ("opensource".equals(this.technologyType) && null != this.hiveMysqlType.get(colList.getDataType()) && "MS".equals(databaseInfoPO.getDatabaseType())) {
                getDataType = this.hiveMysqlType.get(colList.getDataType());
            }
            if (StringUtils.isEmpty(getDataType)) {
                getDataType = colList.getDataType();
            }
            insertTableColInfoPO.setDataType(getDataType);
            insertTableColInfoPO.setColumnComment(colList.getColumnComment());
            insertTableColInfoPO.setColumnLength(colList.getColumnLength());
            insertTableColInfoPO.setIsPrimary(colList.getIsPrimary());
            insertTableColInfoPO.setIsNull(colList.getIsNull());
            insertTableColInfoPO.setSortId(sortId++);
            insertTableColInfoPO.setOperStatus("a");
            insertTableColInfoPO.setUpdateTime(new Date());
            listTableColInfoPO.add(insertTableColInfoPO);
        }
        TableColInfoPO insertTableColInfoPO = new TableColInfoPO();
        insertTableColInfoPO.setTableName(tableInfoPO.getDatabaseTable());
        insertTableColInfoPO.setColumnName("sync_time");
        if ("dataworks".equals(this.technologyType)) {
            insertTableColInfoPO.setDataType("datetime");
        } else if ("opensource".equals(this.technologyType)) {
            insertTableColInfoPO.setDataType("string");
        }
        insertTableColInfoPO.setColumnComment("\u540c\u6b65\u65f6\u95f4");
        insertTableColInfoPO.setSortId(sortId);
        insertTableColInfoPO.setOperStatus("a");
        insertTableColInfoPO.setUpdateTime(new Date());
        listTableColInfoPO.add(insertTableColInfoPO);
        this.tableColInfoDao.insertBatch(listTableColInfoPO);
        ArrayList<String> tableNameList = new ArrayList<String>();
        tableNameList.add(tableInfoPO.getDatabaseTable());
        List<CreateImportFileReqBO> listCreateImportFileReqBO = this.dataWorksDao.getListCreateImportFile(tableNameList);
        if (CollectionUtils.isEmpty(listCreateImportFileReqBO)) {
            throw new ZTBusinessException("\u83b7\u53d6\u8868\u4fe1\u606f\u5931\u8d25\uff01");
        }
        String DDLString = null;
        if ("dataworks".equals(this.technologyType)) {
            String[] DDLStringSub;
            DDLString = this.goveGetDDlStringService.createOdpsTable(listCreateImportFileReqBO.get(0)).toString();
            for (String ddlStr : DDLStringSub = DDLString.substring(DDLString.indexOf("CREATE TABLE")).split(";")) {
                if (StringUtils.isEmpty((String)(ddlStr = ddlStr.trim()))) continue;
                LinkOdpsBO linkOdpsBO = new LinkOdpsBO();
                linkOdpsBO.setExecSql(new StringBuffer(ddlStr));
                linkOdpsBO.setExecType("ddl");
                this.swapLinkOdpsService.execSql(linkOdpsBO);
            }
        } else if ("opensource".equals(this.technologyType)) {
            DDLString = this.swapGetHiveDDlStringService.getHiveDDlString(listCreateImportFileReqBO.get(0)).toString();
        }
        return uploadTableInfoRspBO;
    }

    public static String getRandom(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }

    private void validateParam(UploadTableInfoReqBO uploadBo) {
        if (StringUtils.isEmpty((String)uploadBo.getDatabaseCode())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u7cfb\u7edf\u7f16\u7801\u3010databaseCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)uploadBo.getSourceTable())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8868\u540d\u3010sourceTable\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)uploadBo.getDatabaseTableName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8868\u63cf\u8ff0\u3010databaseTableName\u3011\u4e3a\u7a7a");
        }
        if (uploadBo == null) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u8868\u7684\u5b57\u6bb5\u4fe1\u606f\u3010columnInfo\u3011\u4e3a\u7a7a");
        }
        for (UploadTableColInfoBO colList : uploadBo.getColumnInfo()) {
            if (StringUtils.isEmpty((String)colList.getColumnName())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5b57\u6bb5\u540d\u3010columnName\u3011\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)colList.getDataType())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u3010dataType\u3011\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)colList.getColumnComment())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5b57\u6bb5\u63cf\u8ff0\u3010columnComment\t\u3011\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)colList.getColumnLength().toString())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u5b57\u6bb5\u957f\u5ea6\u3010columnLength\u3011\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)colList.getIsPrimary())) {
                throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u662f\u5426\u4e3b\u952e\u3010isPrimary\u3011\u4e3a\u7a7a");
            }
            if (!StringUtils.isEmpty((String)colList.getIsNull())) continue;
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u662f\u5426\u4e3a\u7a7a\u3010isNull\u3011\u4e3a\u7a7a");
        }
    }
}

