/*
 * Decompiled with CFR 0.152.
 */
package com.yqsmartcity.data.swap.service.busi.impl.hdfs;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.yqsmartcity.data.swap.api.dataworks.bo.CreateImportFileReqBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.ColumnBO;
import com.yqsmartcity.data.swap.api.linkdb.bo.LinkOdpsBO;
import com.yqsmartcity.data.swap.api.linkdb.service.SwapLinkOdpsService;
import com.yqsmartcity.data.swap.dao.DataWorksDao;
import com.yqsmartcity.data.swap.interfaces.db.bo.DataStreamModelBO;
import com.yqsmartcity.data.swap.interfaces.db.bo.UploadDataStreamReqBO;
import com.yqsmartcity.data.swap.interfaces.db.bo.UploadDataStreamRspBO;
import com.yqsmartcity.data.swap.interfaces.db.service.SaveData2DbService;
import com.yqsmartcity.data.swap.service.busi.impl.hdfs.util.HdfsUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaveData2HdfsServiceImpl
implements SaveData2DbService {
    private static final Logger log = LoggerFactory.getLogger(SaveData2HdfsServiceImpl.class);
    @Value(value="${hdfs.updata.database}")
    private String databaseName;
    @Value(value="${technology.type}")
    private String technologyType;
    @Autowired
    private SwapLinkOdpsService swapLinkOdpsService;
    @Autowired
    private DataWorksDao dataWorksDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadDataStreamRspBO uploadDataStream2Db(UploadDataStreamReqBO uploadBo) {
        UploadDataStreamRspBO uploadDataStreamRspBO = new UploadDataStreamRspBO();
        if (uploadBo == null) {
            return uploadDataStreamRspBO;
        }
        Date date = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        if ("dataworks".equalsIgnoreCase(this.technologyType)) {
            ArrayList<String> tableNameList = new ArrayList<String>();
            tableNameList.add(uploadBo.getTableName());
            List<CreateImportFileReqBO> listCreateImportFileReqBO = this.dataWorksDao.getListCreateImportFile(tableNameList);
            if (CollectionUtils.isEmpty(listCreateImportFileReqBO)) {
                throw new ZTBusinessException("\u83b7\u53d6\u8868\u4fe1\u606f\u5931\u8d25\uff01");
            }
            String[] col = uploadBo.getTableColumn().split(",");
            List columnBo = listCreateImportFileReqBO.get(0).getColumnBo();
            String sourceCol = columnBo.stream().map(record -> record.getColumnName()).collect(Collectors.joining(","));
            log.info("sourceCol=" + sourceCol);
            for (String colSub : col) {
                log.info("sourceCol.indexOf(colSub):" + sourceCol.indexOf(colSub));
                if (sourceCol.indexOf(colSub) >= 0) continue;
                throw new ZTBusinessException("\u5728\u8868\u4e2d\u672a\u67e5\u5230\u5b57\u6bb5:[" + colSub + "]");
            }
            String sql = "insert into " + uploadBo.getTableName() + " PARTITION(dt=" + sf.format(date) + ") (" + uploadBo.getTableColumn() + ") values ";
            String insertValue = "";
            for (DataStreamModelBO employee : uploadBo.getDataStreamModelBOList()) {
                int colInt = 1;
                insertValue = insertValue + (StringUtils.isEmpty((String)insertValue) ? "(" : ",(");
                block27: for (Field field : employee.getClass().getDeclaredFields()) {
                    if (colInt > col.length) break;
                    field.setAccessible(true);
                    String colName = "column" + colInt++;
                    if (!colName.toLowerCase().equals(field.getName().toLowerCase())) continue;
                    try {
                        insertValue = insertValue + (colInt > 2 ? "," : "");
                        if (StringUtils.isEmpty((String)field.get(employee).toString())) {
                            insertValue = insertValue + "null";
                            continue;
                        }
                        for (ColumnBO colBO : columnBo) {
                            SimpleDateFormat standardFormat;
                            if (!col[colInt - 2].equalsIgnoreCase(colBO.getColumnName())) continue;
                            if ("boolean".equalsIgnoreCase(colBO.getColumnType().toLowerCase().trim())) {
                                if ("true".equalsIgnoreCase(field.get(employee).toString())) {
                                    insertValue = insertValue + "true";
                                    continue block27;
                                }
                                if ("false".equalsIgnoreCase(field.get(employee).toString())) {
                                    insertValue = insertValue + "false";
                                    continue block27;
                                }
                                throw new ZTBusinessException("boolean\u7c7b\u578b\u6570\u636e\u5f02\u5e38:[" + field.get(employee).toString() + "]");
                            }
                            if ("int".equalsIgnoreCase(colBO.getColumnType().toLowerCase().trim())) {
                                try {
                                    Integer.parseInt(field.get(employee).toString());
                                }
                                catch (NumberFormatException e) {
                                    throw new ZTBusinessException("int\u7c7b\u578b\u6570\u636e\u5f02\u5e38:[" + field.get(employee).toString() + "]");
                                }
                                insertValue = insertValue + field.get(employee).toString();
                                continue block27;
                            }
                            if ("bigint".equalsIgnoreCase(colBO.getColumnType().toLowerCase().trim())) {
                                try {
                                    Long.parseLong(field.get(employee).toString());
                                }
                                catch (NumberFormatException e) {
                                    throw new ZTBusinessException("bigint\u7c7b\u578b\u6570\u636e\u5f02\u5e38:[" + field.get(employee).toString() + "]");
                                }
                                insertValue = insertValue + field.get(employee).toString();
                                continue block27;
                            }
                            if ("float".equalsIgnoreCase(colBO.getColumnType().toLowerCase().trim())) {
                                try {
                                    Float.parseFloat(field.get(employee).toString());
                                }
                                catch (NumberFormatException e) {
                                    throw new ZTBusinessException("float\u7c7b\u578b\u6570\u636e\u5f02\u5e38:[" + field.get(employee).toString() + "]");
                                }
                                insertValue = insertValue + field.get(employee).toString();
                                continue block27;
                            }
                            if ("double".equalsIgnoreCase(colBO.getColumnType().toLowerCase().trim())) {
                                try {
                                    Double.parseDouble(field.get(employee).toString());
                                }
                                catch (NumberFormatException e) {
                                    throw new ZTBusinessException("double\u7c7b\u578b\u6570\u636e\u5f02\u5e38:[" + field.get(employee).toString() + "]");
                                }
                                insertValue = insertValue + field.get(employee).toString();
                                continue block27;
                            }
                            if ("date".equalsIgnoreCase(colBO.getColumnType().toLowerCase().trim())) {
                                standardFormat = new SimpleDateFormat("yyyy-MM-dd");
                                try {
                                    standardFormat.setLenient(false);
                                    standardFormat.parse(field.get(employee).toString());
                                }
                                catch (Exception e) {
                                    throw new ZTBusinessException("date\u7c7b\u578b\u6570\u636e\u5f02\u5e38:[" + field.get(employee).toString() + "]");
                                }
                                if (field.get(employee).toString().length() > 10) {
                                    throw new ZTBusinessException("date\u7c7b\u578b\u6570\u636e\u5f02\u5e38:[" + field.get(employee).toString() + "]");
                                }
                                insertValue = insertValue + "'" + field.get(employee).toString() + "'";
                                continue block27;
                            }
                            if ("datetime".equalsIgnoreCase(colBO.getColumnType().toLowerCase().trim())) {
                                standardFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                try {
                                    standardFormat.setLenient(false);
                                    standardFormat.parse(field.get(employee).toString());
                                }
                                catch (Exception e) {
                                    throw new ZTBusinessException("datetime\u7c7b\u578b\u6570\u636e\u5f02\u5e38:[" + field.get(employee).toString() + "]");
                                }
                                if (field.get(employee).toString().length() > 23) {
                                    throw new ZTBusinessException("datetime\u7c7b\u578b\u6570\u636e\u5f02\u5e38:[" + field.get(employee).toString() + "]");
                                }
                                insertValue = insertValue + "'" + field.get(employee).toString() + "'";
                                continue block27;
                            }
                            insertValue = insertValue + "'" + field.get(employee).toString() + "'";
                            continue block27;
                        }
                    }
                    catch (Exception e) {
                        log.info("colInt=" + colInt);
                        e.printStackTrace();
                        throw new ZTBusinessException(e.getMessage());
                    }
                }
                insertValue = insertValue + ")";
            }
            sql = sql + insertValue;
            LinkOdpsBO linkOdpsBO = new LinkOdpsBO();
            linkOdpsBO.setExecSql(new StringBuffer(sql));
            linkOdpsBO.setExecType("insert");
            this.swapLinkOdpsService.execSql(linkOdpsBO);
        } else {
            String path = HdfsUtil.getHadoopConfBO().getHivePath() + "/" + this.databaseName + ".db/" + uploadBo.getTableName() + "/" + UUID.randomUUID();
            log.info("\u51c6\u5907\u6dfb\u52a0\u6570\u636e\u5230{}\u4e2d\uff01", (Object)path);
            FileSystem fs = HdfsUtil.getFileSystem();
            FSDataOutputStream outputStream = null;
            try {
                outputStream = fs.create(new Path(path));
                for (DataStreamModelBO dataStreamModelBO : uploadBo.getDataStreamModelBOList()) {
                    outputStream.write(dataStreamModelBO.getString().getBytes());
                }
                outputStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    outputStream.close();
                    fs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        log.info("\u6570\u636e\u6dfb\u52a0\u6210\u529f");
        return uploadDataStreamRspBO;
    }
}

